/*****************************************************************************/
/* File name: Octal.java                                                     */
/* Purpose: Octal class for Jtar                                             */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import c.Byte;
import java.util.*;
import general.*;


class

Octal

     implements jtar.Constants, general.Constants

{

  private final static String RCSID = "$Header: /d/JTAR03/jtar/RCS/Octal.java,v 1.4 1998/12/13 17:19:21 vklimov Exp $";


  Octal( )
/*****************************************************************************/
/* Function name: Octal                                                      */
/* File name: Octal.java                                                     */
/* Purpose: constructor for the Octal object                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 24.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                           /* Octal */
/*---------------------------------------------------------------------------*/

    }
/*end of Octal*/


  static
  int
  fromOct( int digs, byte where[] )
/*****************************************************************************/
/* Function name: fromOct                                                    */
/* File name: Octal.java                                                     */
/* Purpose: quick and dirty octal conversion.                                */
/* Parameters: digs                                                          */
/*             where                                                         */
/* Returns: JAVA_ERROR_CODE if the field is invalid                          */
/*          (all blank, or nonoctal).                                        */
/* Last modified: 12.12.98                                                   */
/* Author of the java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int i = 0;
      int value;
                                                         /* fromOct */
/*---------------------------------------------------------------------------*/

      while( c.Byte.isspace(where[i]) )                /* skip spaces */
        {
          i++;
          if (--digs <= 0)
            return JAVA_ERROR_CODE;              /* all blank field */
          else
            ;
        /*end of if*/
        }
    /*end of while*/

      value = 0;
      while( (digs > 0) &&
             c.Byte.isodigit(where[i]) )
        {                                            /* Scan till nonoctal */
          value = (value << 3) | (where[i++] - '0');
          --digs;
        }
    /*end of while*/

      if ( (digs > 0) &&
           !c.Byte.isspace(where[i]) &&
           (where[i] != 0) 
         )
        {
          return JAVA_ERROR_CODE;                 /* ended on non-space/nul */
        }
      else
        return value;
    /*end of if*/

    }
/*end of fromOct*/


  static
  void
  toOct( int value, int digs, byte where[] )
/*****************************************************************************/
/* Function name: toOct                                                      */
/* File name: Octal.java                                                     */
/* Purpose: to convert an int value into a field, including a trailing space */
/*          and room for a \u0000                                            */
/*   For example: digs == 3  means one digit, a space, and a '\0'            */
/*          We *do* fill in the trailing '\0'.                               */
/*          This fact is used by startHeader and finishHeader,               */
/*          so don't change it!                                              */
/* Parameters: value - the int to convert                                    */
/*             digs - number of digits the field contains                    */
/*             where - the field to put the digits into                      */
/* Returns:                                                                  */
/* Last modified: 12.12.98                                                   */
/* Author of the java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
                                                         /* toOct */
/*---------------------------------------------------------------------------*/

      where[ --digs ] = general.Constants.NULL_BYTE;     /* Trailing null */
      where[ --digs ] = ' ';                           /* put in the space */

      do                            /* Produce the digits -- at least one  */
        {
          where[--digs] = (byte)                        /* one octal digit */
            ( '0' + (int) (value & 7) );
          value >>= 3;
        }
      while( (digs > 0) &&
             (value != 0)   );

      /* Leading spaces, if necessary.  */
      while( digs > 0 )
        where[--digs] = ' ';
    /*end of while-loop*/

    }
/*end of toOct*/

} /*end of class Octal */

/*****************************************************************************/
/* End of file: Octal.java                                                   */
/*****************************************************************************/
