/*****************************************************************************/
/* File name: MakeDirectories.java                                           */
/* Purpose: to implement MakeDirectories methods                             */
/* Last modified: 06.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/


package jtar;

import java.io.*;
import java.util.*;
import java.text.DecimalFormat;
import general.*;

public
class

MakeDirectories

       implements general.Constants

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/MakeDirectories.java,v 1.6 1999/05/06 23:10:40 vklimov Exp $";


  public
  MakeDirectories()
/*****************************************************************************/
/* Function name: MakeDirectories                                            */
/* File name: MakeDirectories.java                                           */
/* Purpose: constructor for the MakeDirectories object                       */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 01.11.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                    /* MakeDirectories */
/*---------------------------------------------------------------------------*/

    }
/*end of MakeDirectories*/


  public
  static
  void
  printForMkdir( String pathname, int length,
                 Header tarHeader,
                 BufferRead readBuffer,
                 io.TextDisplayingDialog headerListDialog )
/*****************************************************************************/
/* Function name: printForMkdir                                              */
/* File name: MakeDirectories.java                                           */
/* Purpose: to print out a uniform line for each created directory           */
/* Parameters: pathname - the name of the created directory                  */
/*             length - length of the name (number of chars)                 */
/*             tarHeader                                                     */
/*             readBuffer                                                    */
/*             headerListDialog                                              */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author of the Java translation: Victor Klimov, 1999                       */
/*****************************************************************************/
    {
      int i;
      int totalPrefixStatementStringLength;
      int emptyPrefixLentgth;

      String name;
      String prefixStatementString;
      DecimalFormat NumberFormat;
      StringBuffer emptySpaces;
                                                       /* printForMkdir */
/*---------------------------------------------------------------------------*/


      if (AllActions.blockNumberOption)
        {
          tarHeader.printBlockNumber( (Buffer) readBuffer,
                                      headerListDialog     );
        }
      else
        ;
    /*end of if on blockNumberOption*/

      name =
        util.QuoteString.quoteCopyString( pathname );

      prefixStatementString = new
        String( "Creating directory:" );

      totalPrefixStatementStringLength =
        tarHeader.ugswidth + tarHeader.DATEWIDTH;

      emptyPrefixLentgth =
        totalPrefixStatementStringLength -
        prefixStatementString.length();

      emptySpaces = new StringBuffer( emptyPrefixLentgth );
      for (i=0;i<emptyPrefixLentgth;i++)
        emptySpaces.append( ' ' );
    /*end of for-loop*/

      headerListDialog.append( emptySpaces.toString() +
                               prefixStatementString    );
                          
      emptyPrefixLentgth =
        length - name.length();
      if (emptyPrefixLentgth < 0)
        emptyPrefixLentgth = 0;
      else
        ;
    /*end of if*/

      emptySpaces = new StringBuffer( emptyPrefixLentgth );
      for (i=0;i<emptyPrefixLentgth;i++)
        emptySpaces.append( ' ' );
    /*end of for-loop*/

      headerListDialog.append( emptySpaces.toString() +
                               name                     );
      headerListDialog.append( "\n" );
    }
/*end of printForMkdir*/


  public
  static
  boolean

  makeDirectories( String fileName,
                   Header tarHeader,
                   BufferRead readBuffer,
                   io.TextDisplayingDialog headerListDialog )
/*****************************************************************************/
/* Function name: makeDirectories                                            */
/* File name: MakeDirectories.java                                           */
/* Purpose: to check if there is a need to create intermediate directories   */
/*          and, if yes, to create them                                      */
/* Parameters: fileName                                                      */
/*             tarHeader                                                     */
/*             readBuffer                                                    */
/*             headerListDialog                                              */
/* Returns: true - if intermediate directories were created                  */
/*          false - otherwise                                                */
/* Last modified: 06.05.99                                                   */
/* Author of the Java translation: Victor Klimov, 1999                       */
/*****************************************************************************/
    {
      int separatorIndex;                       /* points into path */
      boolean createdDirectories = false;        /* did we do anything yet? */
      boolean created;
      int pathSeparatorLength;
      int lengthPrefixTillCursor;
      String prefixTillCursor = null;
      String dirName;
      StringBuffer currentDirAbbrev;
      File dirFile;
                                               /* makeDirectories */
/*---------------------------------------------------------------------------*/

      pathSeparatorLength =
        File.separator.length();

      separatorIndex = fileName.lastIndexOf( File.separator );

                                         /* Avoid mkdir of empty string, */
                                         /* if leading or double '/'     */
      try
        {
          prefixTillCursor =
            fileName.substring( 0, separatorIndex );

          if ( (separatorIndex == 0) ||
               (prefixTillCursor.endsWith(
                 File.separator ) )
             )
            {
               return false;                                  /* return ! */
            }
          else
            ;
        /*end of if*/
        }
      catch( StringIndexOutOfBoundsException e)
        {
          headerListDialog.append( "Should never happen" );

          return false;                                  /* return ! */

        }
    /*end of try-catch*/
                                                   /* Avoid mkdir where */
                                                   /* last part of path */
                                                   /* is '.'            */
      if (prefixTillCursor == null)
        {
          return false;                                /* return ! */
        }
      else
        ;
    /*end of if on null*/

      lengthPrefixTillCursor =
        prefixTillCursor.length();

      currentDirAbbrev = new StringBuffer();
      currentDirAbbrev.append(
        CURRENT_DIRECTORY_ABBREVIATION );

      if ( (prefixTillCursor.                      /* last char */
            endsWith( currentDirAbbrev.toString() ) )  &&       /* . */
           (separatorIndex == 1)
         )
        {
           return false;                                  /* return ! */
        }
      else
        ;
    /*end of if on . */

      dirName = prefixTillCursor;
      dirFile = new File( dirName );

      created = dirFile.mkdirs();

      if (created)
        {
          if (AllActions.verbose.flag)
            printForMkdir( dirName, dirName.length(),
                           tarHeader, readBuffer,
                           headerListDialog           );
          else
            ;
        /*end of if on verbose*/

          createdDirectories = true;

        }
      else /*nothing created*/
        ;
    /*end of if on created*/

      return createdDirectories;

    }
/*end of makeDirectories*/


  public
  static
  void

  main( String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: MakeDirectories.java                                           */
/* Purpose: to test the MakeDirectories class                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 05.11.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* main */
/*---------------------------------------------------------------------------*/


    }
/*end of main*/

} /*end of class MakeDirectories */

/*****************************************************************************/
/* End of file: MakeDirectories.java                                         */
/*****************************************************************************/
