/*****************************************************************************/
/* File name: AllActions.java                                                */
/* Purpose: to keep flags and options for Jtar                               */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import c.Stat;
import general.*;

final

class

AllActions

     implements jtar.Constants, general.Constants

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/AllActions.java,v 1.5 1999/05/04 17:01:04 vklimov Exp $";

  static ActionTable table  = new
                              ActionTable(
                                 COMMAND_LINE_OPTION_TABLE,false );
  static ActionCreate create  = new
                              ActionCreate(
                                 COMMAND_LINE_OPTION_CREATE,false );
  static ActionExtract extract = new
                              ActionExtract(
                                 COMMAND_LINE_OPTION_EXTRACT,false );
  static Action file = new
                              Action(
                                 COMMAND_LINE_OPTION_FILE,false );
  static Action gzip = new
                              Action(
                                 COMMAND_LINE_OPTION_GZIP,false );
  static Action verbose = new
                              Action(
                                 COMMAND_LINE_OPTION_VERBOSE,false );

  static Action incremental = new
                              Action(
                                 COMMAND_LINE_OPTION_INCREMENTAL,false );


                                            /* for the time being */

  static boolean numericOwner = false;
  static boolean blockNumberOption = false;
  static long newerMtime = Long.MIN_VALUE;
  static boolean exclude = false;
  static boolean multiVolume = false;
  static boolean showOmittedDirs = true;
  static boolean interactive = false;
  static boolean absoluteNames = false;
  static boolean backup = false;
  static boolean toStdout = false;
  static boolean keepOldFiles = true;


  static
  Action[]
    flagOptionsArray   = { (Action) table,
                           (Action) create,
                           (Action) extract
                         };

  static String archiveName = null;
  static String currentFileName = null;
  static String currentLinkName = null;

  static Action whatToActUpon = null;

  static int archiveFormat = DEFAULT_FORMAT;
  static int recordSize = DEFAULT_BLOCKING * BLOCKSIZE;

  static c.Stat currentStat = new c.Stat();

  /* never instantiate this class, all methods and variables are */
  /* class variables and and class methods                       */

 private
  AllActions()  /* no arguments */
   {                  /* no content   */
   }
/*end of AllActions*/


} /*end of AllActions */

/*****************************************************************************/
/* End of file: AllActions.java                                              */
/*****************************************************************************/

