/*****************************************************************************/
/* File name: Action.java                                                    */
/* Purpose: to keep an option and a corresponding flag for Jtar              */
/* Last modified: 11.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import java.util.*;

class

Action

{

  private final static String RCSID = "$Header: /d/JTAR03/jtar/RCS/Action.java,v 1.2 1998/12/13 17:19:09 vklimov Exp $";


  boolean flag;
  char    option;


  Action()   /* empty constructor for inheritance */
  {
  }


  Action( char    option,
          boolean flag     )
/*****************************************************************************/
/* Function name: Action                                                     */
/* File name: Action.java                                                    */
/* Purpose: constructor for the Action object                                */
/* Parameters: option - 't', 'x', 'c' etc                                    */
/*             flag - corresponding flag                                     */
/* Returns:                                                                  */
/* Last modified: 09.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                            /* Action */
/*---------------------------------------------------------------------------*/

      this.option = option;
      this.flag = flag;

    }
/*end of Action*/


  boolean
  action( Vector commandLineOptionsVector,
          Header dummyTarHeader,
          BufferRead dummyReadBuffer )
/*****************************************************************************/
/* Function name: action                                                     */
/* File name: Action.java                                                    */
/* Purpose: to perform the action, corresponding to this particular option   */
/* Parameters: commandLineOptionsVector - vector, containig strings          */
/*                                 of command line arguments to Jtar         */
/* Returns: true - if everything is all right, false - otherwise             */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                            /* action */
/*---------------------------------------------------------------------------*/
      /* this is intentionally empty */
      /* the descendants have to implement the method */

      return true;

    }
/*end of action*/


} /*end of class Action */

/*****************************************************************************/
/* End of file: Action.java                                                  */
/*****************************************************************************/

