/*****************************************************************************/
/* File name: AboutButton.java                                               */
/* Purpose: to provide a button to inform about the Jtar application         */
/*                                                                           */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


import java.awt.*;
import java.awt.event.*;
import general.*;
import io.*;


class

AboutButton extends Button

                           implements ActionListener

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/AboutButton.java,v 1.4 1999/05/04 17:01:10 vklimov Exp $";

  final private static String TITLE_FOR_DIALOG_ABOUT =
				"About Jtar";
  final private static String VERSION_NUMBER_STRING = "Version 1.2";

  private final static String ABOUT_TEXT =
    "Jtar " + VERSION_NUMBER_STRING +
"\ntar (GNU) translated into the Java language\n\nAuthor: Victor Klimov, 1999\n\nFor the list of authors and contributors of the original C version\nof the GNU tar see files AUTHORS and THANKS\n\nThis program is distributed in the hope that it will be useful, but\nWITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General\nPublic License for more details.\n\nThis software is distributed under the terms\nof the GNU General Public License as published\nby the Free Software Foundation; either version 2, or (at your option)\nany later version.\nSee file COPYING for your rights (GNU GPL)";

  Frame parentWindow = null;


  public
  AboutButton( String label,
               Frame parentWindow      )
/*****************************************************************************/
/* Function name: AboutButton                                                */
/* File name: AboutButton.java                                               */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 07.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* AboutButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.parentWindow = parentWindow;

    }
/*end of AboutButton*/


  public
  AboutButton( String label )
/*****************************************************************************/
/* Function name: AboutButton                                                */
/* File name: AboutButton.java                                               */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/* Returns:                                                                  */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* AboutButton */
/*---------------------------------------------------------------------------*/

      super( label );

    }
/*end of AboutButton*/


  public
  AboutButton()
/*****************************************************************************/
/* Function name: AboutButton                                                */
/* File name: AboutButton.java                                               */
/* Purpose: constructor to create the button                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                           /* AboutButton */
/*---------------------------------------------------------------------------*/

      super();

    }
/*end of AboutButton*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: AboutButton.java                                               */
/* Purpose: to process user initiated events                                 */
/* Parameters: event - incoming event object                                 */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      io.TextDisplayingDialog aboutDialog;
                                                      /* actionPerformed */
/*---------------------------------------------------------------------------*/

      if (parentWindow != null)
        {
          aboutDialog = new
            io.TextDisplayingDialog( parentWindow,
                                     TITLE_FOR_DIALOG_ABOUT,
                                     ABOUT_TEXT              );
          aboutDialog.show();
        }
      else
        ;
    /*end of if on id*/

  } /* end of actionPerformed */

} /*end of AboutButton */

/*****************************************************************************/
/* End of file: AboutButton.java                                             */
/*****************************************************************************/
