/*****************************************************************************/
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: to provide a dialog to display a text                            */
/*                                                                           */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.awt.*;
import java.awt.event.*;

public
class

TextDisplayingDialog extends Dialog

                            implements ActionListener

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/io/RCS/TextDisplayingDialog.java,v 1.4 1999/05/20 16:38:28 vklimov Exp $";

  private final static int DEFAULT_ROWS_NUMBER    = 13;
  private final static int DEFAULT_COLUMNS_NUMBER = 77;

  private final static java.lang.String UPPER_PANEL_LOCATION_STRING = "Center";
  private final static java.lang.String LOWER_PANEL_LOCATION_STRING = "South";

  private final static java.lang.String OK_BUTTON_LABEL_STRING = "OK";

  Button okButton;
  TextArea textArea;


  public
  TextDisplayingDialog( Frame parentWindow,
                        java.lang.String title,
                        java.lang.String textToDisplay )
/*****************************************************************************/
/* Function name: TextDisplayingDialog                                       */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: constructor for the TextDisplayingDialog class                   */
/* Parameters: parentWindow                                                  */
/*             title                                                         */
/*             textToDisplay                                                 */
/* Returns:                                                                  */
/* Last modified: 29.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* TextDisplayingDialog */
/*---------------------------------------------------------------------------*/


      super( parentWindow, title, true );

      Panel upperPanel = new Panel();
      Panel lowerPanel = new Panel();

      textArea = new
        TextArea( textToDisplay,
                  DEFAULT_ROWS_NUMBER,
                  DEFAULT_COLUMNS_NUMBER );
      textArea.setEditable( false );
      upperPanel.add( textArea );
      add( UPPER_PANEL_LOCATION_STRING, upperPanel );

      okButton = new Button( OK_BUTTON_LABEL_STRING );
      okButton.addActionListener( this );
      lowerPanel.add(okButton);
      add( LOWER_PANEL_LOCATION_STRING, lowerPanel );

      pack();

    }
/*end of TextDisplayingDialog*/


  public
  TextDisplayingDialog( Frame parentWindow,
                        java.lang.String title,
                        java.lang.String textToDisplay,
                        int rows,
                        int columns )
/*****************************************************************************/
/* Function name: TextDisplayingDialog                                       */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: constructor for the TextDisplayingDialog class                   */
/* Parameters: parentWindow                                                  */
/*             title                                                         */
/*             textToDisplay                                                 */
/*             rows                                                          */
/*             columns                                                       */
/* Returns:                                                                  */
/* Last modified: 29.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* TextDisplayingDialog */
/*---------------------------------------------------------------------------*/

      super( parentWindow, title, true );

      Panel upperPanel = new Panel();
      Panel lowerPanel = new Panel();

      textArea = new
        TextArea( textToDisplay,
                  rows,
                  columns         );
      textArea.setEditable( false );
      upperPanel.add( textArea );
      add( UPPER_PANEL_LOCATION_STRING, upperPanel );

      okButton = new Button( OK_BUTTON_LABEL_STRING );
      okButton.addActionListener( this );
      lowerPanel.add(okButton);
      add( LOWER_PANEL_LOCATION_STRING, lowerPanel );

      pack();

    }
/*end of TextDisplayingDialog*/


  public
  TextDisplayingDialog( Frame parentWindow,
                        java.lang.String title,
                        java.lang.String textToDisplay,
                        int rows,
                        int columns,
                        boolean modal         )
/*****************************************************************************/
/* Function name: TextDisplayingDialog                                       */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: constructor for the TextDisplayingDialog class                   */
/* Parameters: parentWindow                                                  */
/*             title                                                         */
/*             textToDisplay                                                 */
/*             rows                                                          */
/*             columns                                                       */
/*             modal                                                         */
/* Returns:                                                                  */
/* Last modified: 29.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* TextDisplayingDialog */
/*---------------------------------------------------------------------------*/

      super( parentWindow, title, modal );

      Panel upperPanel = new Panel();
      Panel lowerPanel = new Panel();

      textArea = new
        TextArea( textToDisplay,
                  rows,
                  columns         );
      textArea.setEditable( false );
      upperPanel.add( textArea );
      add( UPPER_PANEL_LOCATION_STRING, upperPanel );

      okButton = new Button( OK_BUTTON_LABEL_STRING );
      okButton.addActionListener( this );
      lowerPanel.add(okButton);
      add( LOWER_PANEL_LOCATION_STRING, lowerPanel );

      pack();

    }
/*end of TextDisplayingDialog*/



  public
  void
  append( java.lang.String textToDisplay )
/*****************************************************************************/
/* Function name: append                                                     */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: to append text to the text area of the dialog                    */
/* Parameters: textToDisplay                                                 */
/* Returns:                                                                  */
/* Last modified: 29.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                             /* append */
/*---------------------------------------------------------------------------*/

      textArea.append( textToDisplay );

    }
/*end of append*/


  public
  TextDisplayingDialog( Frame parentWindow )
/*****************************************************************************/
/* Function name: TextDisplayingDialog                                       */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: constructor for the TextDisplayingDialog class                   */
/* Parameters: parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 08.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* TextDisplayingDialog */
/*---------------------------------------------------------------------------*/

      super( parentWindow );

    }
/*end of TextDisplayingDialog*/


  public
  TextDisplayingDialog( Frame parentWindow, boolean modal )
/*****************************************************************************/
/* Function name: TextDisplayingDialog                                       */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: constructor for the TextDisplayingDialog class                   */
/* Parameters: parentWindow                                                  */
/*             modal                                                         */
/* Returns:                                                                  */
/* Last modified: 08.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* TextDisplayingDialog */
/*---------------------------------------------------------------------------*/

      super( parentWindow, modal );

    }
/*end of TextDisplayingDialog*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 29.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      java.lang.String command;
                                                  /* actionPerformed */
/*---------------------------------------------------------------------------*/

      command = event.getActionCommand();

      if ( command.equals( OK_BUTTON_LABEL_STRING ) )
        {
          dispose();
        }
      else
        ;
    /*end of if on OK_BUTTON_LABEL_STRING*/

    }
/*end of actionPerformed*/


  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: TextDisplayingDialog.java                                      */
/* Purpose: to test the text dialog class                                    */
/* Parameters: args                                                          */
/* Returns:                                                                  */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Frame window = new Frame();
                                                   /* main */
/*---------------------------------------------------------------------------*/

      TextDisplayingDialog dialog = new
        TextDisplayingDialog( window,
                              "Test",
                              "Test text displayed",
                              1, 55                   );
      dialog.show();

      System.exit( 0 );

    }
/*end of main*/

} /* end of TextDisplayingDialog */

/*****************************************************************************/
/* End of file: TextDisplayingDialog.java                                    */
/*****************************************************************************/
