/*****************************************************************************/
/* File name: TarWriteResource.java                                          */
/* Purpose: Output object to write to a generic tar stream                   */
/*                                                                           */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;


public
class
TarWriteResource
{
  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/TarWriteResource.java,v 1.2 1999/05/14 22:18:19 vklimov Exp $";


  private TarWritable archiveStreamToUse;


  public
  TarWriteResource( TarWritable archiveStreamToUse ) 
/*****************************************************************************/
/* Function name: TarWriteResource                                           */
/* File name: TarWriteResource.java                                          */
/* Purpose: constructor object to provide resources to write to a generic tar*/
/* Parameters: archiveStreamToUse                                            */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* TarWriteResource */
/*---------------------------------------------------------------------------*/

      this.archiveStreamToUse = archiveStreamToUse;

    }
/*end of TarWriteResource*/



  public
  void
  write( byte b[],
         int off,
         int len    ) throws java.io.IOException
/*****************************************************************************/
/* Function name: write                                                      */
/* File name: TarWriteResource.java                                          */
/* Purpose: to write bytes from a bytes array                                */
/* Parameters: b - byte array to write the data from                         */
/*             off - offset in the byte array to begin to write from         */
/*             len - maximum number of bytes to write                        */
/* Returns:                                                                  */
/* Last modified: 14.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* write */
/*---------------------------------------------------------------------------*/

      archiveStreamToUse.write( b, off, len );
    }
/*end of write*/


  public
  void
  close() throws java.io.IOException
/*****************************************************************************/
/* Function name: close                                                      */
/* File name: TarWriteResource.java                                          */
/* Purpose: to close generic tar stream                                      */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 14.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* close */
/*---------------------------------------------------------------------------*/

      archiveStreamToUse.close();
    }
/*end of close*/




}/*end of TarWriteResource class*/

/*****************************************************************************/
/* End of file: TarWriteResource.java                                        */
/*****************************************************************************/
