/*****************************************************************************/
/* File name: TarRegularInputStream.java                                     */
/* Purpose: input stream to read from a regular tar file                     */
/*                                                                           */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.io.*;


public
class
TarRegularInputStream
                              extends    FileInputStream

                              implements TarReadable
{

  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/TarRegularInputStream.java,v 1.1 1999/05/09 22:24:16 vklimov Exp $";


  public
  TarRegularInputStream( File file ) throws FileNotFoundException
/*****************************************************************************/
/* Function name: TarRegularInputStream                                      */
/* File name: TarRegularInputStream.java                                     */
/* Purpose: constructor object to read a regular tar file                    */
/* Parameters: file                                                          */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                /* TarRegularInputStream */
/*---------------------------------------------------------------------------*/

      super( file );

    }
/*end of TarRegularInputStream*/

} /*end of TarRegularInputStream*/

/*****************************************************************************/
/* End of file: TarRegularInputStream.java                                   */
/*****************************************************************************/
