/*****************************************************************************/
/* File name: TarReadResource.java                                           */
/* Purpose: input object to read from a generic tar stream                   */
/*                                                                           */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

public
class
TarReadResource
{
  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/TarReadResource.java,v 1.1 1999/05/09 22:24:36 vklimov Exp $";


  private TarReadable archiveStreamToUse;


  public
  TarReadResource( TarReadable archiveStreamToUse ) 
/*****************************************************************************/
/* Function name: TarReadResource                                            */
/* File name: TarReadResource.java                                           */
/* Purpose: constructor object to provide resources to read a generic tar    */
/* Parameters: archiveStreamToUse                                            */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                    /* TarReadResource */
/*---------------------------------------------------------------------------*/

      this.archiveStreamToUse = archiveStreamToUse;

    }
/*end of TarReadResource*/


  public
  int
  read( byte b[],
        int off,
        int len    ) throws java.io.IOException
/*****************************************************************************/
/* Function name: read                                                       */
/* File name: TarReadResource.java                                           */
/* Purpose: to read data into a byte array                                   */
/* Parameters: b - byte array to read the data into                          */
/*             off - offset to begin to fill up the byte array               */
/*             len - maximum number of bytes to read                         */
/* Returns: total number of bytes read or -1 in case of an end of file       */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* read */
/*---------------------------------------------------------------------------*/

      return archiveStreamToUse.read( b, off, len );
    }
/*end of read*/


  public
  void
  close() throws java.io.IOException
/*****************************************************************************/
/* Function name: close                                                      */
/* File name: TarReadResource.java                                           */
/* Purpose: to close generic tar stream                                      */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* close */
/*---------------------------------------------------------------------------*/

      archiveStreamToUse.close();
    }
/*end of close*/



} /*end of TarReadResource*/

/*****************************************************************************/
/* End of file: TarReadResource.java                                         */
/*****************************************************************************/
