/*****************************************************************************/
/* File name: TarGzippedOutputStream.java                                    */
/* Purpose: output stream to write a gzipped tar file                        */
/*                                                                           */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.io.*;
import java.util.zip.*;


public
class
TarGzippedOutputStream
                              extends    GZIPOutputStream

                              implements TarWritable
{

  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/TarGzippedOutputStream.java,v 1.1 1999/05/09 22:22:12 vklimov Exp $";

  private OutputStream outputStream;


  public
  TarGzippedOutputStream( OutputStream outputStream )
                                                  throws java.io.IOException
/*****************************************************************************/
/* Function name: TarGzippedOutputStream                                     */
/* File name: TarGzippedOutputStream.java                                    */
/* Purpose: constructor object to write a gzipped tar                        */
/* Parameters: outputStream                                                  */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                               /* TarGzippedOutputStream */
/*---------------------------------------------------------------------------*/

      super( outputStream );
      this.outputStream = outputStream;

    }
/*end of TarGzippedOutputStream*/



  public
  void
  close()  throws java.io.IOException
/*****************************************************************************/
/* Function name: close                                                      */
/* File name: TarGzippedOutputStream.java                                    */
/* Purpose: to close the stream and the overlaying stream too                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                             /* close */
/*---------------------------------------------------------------------------*/

      super.close();
      this.outputStream.close();

    }
/*end of close*/


}/* end of TarGzippedOutputStream class*/

/*****************************************************************************/
/* End of file: TarGzippedOutputStream.java                                  */
/*****************************************************************************/
