/*****************************************************************************/
/* File name: ResizedList.java                                               */
/* Purpose: to present a List component with variable size                   */
/*                                                                           */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.awt.*;

public
class

ResizedList extends List
{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/io/RCS/ResizedList.java,v 1.2 1999/05/05 18:36:27 vklimov Exp $";

  private static int DEFAULT_WIDTH  = 55;
  private static int DEFAULT_HEIGTH = 100;

  private int width  = DEFAULT_WIDTH;
  private int height = DEFAULT_HEIGTH;


  public
  ResizedList( int rows,
               boolean multipleMode,
               int preferredWidth,
               int preferredHeight   )
/*****************************************************************************/
/* Function name: ResizedList                                                */
/* File name: ResizedList.java                                               */
/* Purpose: constructor for the ResizedList class                            */
/* Parameters: rows                                                          */
/*             multipleMode                                                  */
/*             preferredWidth                                                */
/*             preferredHeight                                               */
/* Returns:                                                                  */
/* Last modified: 26.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      super(rows, multipleMode);
                                                       /* ResizedList */
/*---------------------------------------------------------------------------*/

      width = preferredWidth;
      height = preferredHeight;

    }
/*end of ResizedList*/


  public
  Dimension
  getMinimumSize()
/*****************************************************************************/
/* Function name: getMinimumSize                                             */
/* File name: ResizedList.java                                               */
/* Purpose: to get the minimum size of the List component                    */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 26.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                    /* getMinimumSize */
/*---------------------------------------------------------------------------*/

      return new Dimension( width, height );
    }
/*end of getMinimumSize*/


  public
  Dimension

  getPreferredSize()
/*****************************************************************************/
/* Function name: getPreferredSize                                           */
/* File name: ResizedList.java                                               */
/* Purpose: to get preferred size of the list component                      */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 26.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                   /* getPreferredSize */
/*---------------------------------------------------------------------------*/

      return new Dimension( width, height );
    }
/*end of getPreferredSize*/


  public
  void

  deselectAll()
/*****************************************************************************/
/* Function name: deselectAll                                                */
/* File name: ResizedList.java                                               */
/* Purpose: to deselect all Items on the List                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      int[] selectedIndexes;
                                                    /* deselectAll */
/*---------------------------------------------------------------------------*/

      selectedIndexes = getSelectedIndexes();
      for (i=0;i<selectedIndexes.length;i++)
        deselect( selectedIndexes[i] );
    /*end of for-loop*/

    }
/*end of deselectAll*/


} /* end of ResizedList */

/*****************************************************************************/
/* End of file: ResizedList.java                                             */
/*****************************************************************************/
