/*
 * TinyText.exf  by Aaron J. Miller
 * millera@stanford.edu
 * Copyright (c) 1999
 * Released to public domain for any non-commercial use.
 * **********************************************************
 *
 * Modifications:
 *      20001017 dario@softhome.net
 *                Show page numbers.
 *      20001115 dario@softhome.net
 *                Implement automatic bookmarks (saved in bookmark.txt).
 *      20001116 dario@softhome.net
 *                Show book name (and page) when the bookmark is saved.
 *                Make the bookmark scroll invisible.
 */

#include "psdos.h"
#include "lcdbios.h"
#include "wbios.h"
#include "rupsys.h"
#include <string.h>

#define MAXSIZE 16384
#define MAXLN MAXSIZE/10
char font[128*8+4];
char dbuff[102 * 8];  /* double buffer for fast screen updates */
char mod8[]={0,6,4,2,0,6,4,2,0,6};  /* lookup table for shifts */
unsigned int offset[]={0,0,102,204,306,306,408,510,612,612};   /*lookup table to avoid mulitplications */
char filebuff[MAXSIZE]; /* buffer to hold the file */
unsigned int scroll[MAXLN+1]; /* nonelegant way to store page lengths */

int dbuffstr(char *str,int show)
{

        char y=0,y2,x,wrapped;

        char *tmp,*strtmp;

  int idx;

  char *tempint;

  unsigned int lkup,retval;


  strtmp=str;  /* keep track of original string pointer */
  if(show)
        memset(dbuff,0x00,102*8); /* clear the screen memory */

  if(show) {
    do {
      x=0;
      wrapped=1;
      do { /* max of 25 characters wide */
        if(!*str) {    /* end of string? */
          goto out;     /* I like gotos... so bite me. */
        }
        preproc:
          switch (*str) {
            case 0x0D:
              if (*(str+1) == 0x0A) str++;
            case 0x0A:
              str++;
              if (!(wrapped && (x==0))) {
                x=0;
                wrapped=0;
                if (++y >9) goto out;
              }
              goto preproc;
            case '\t':
              str++;
              if (x==0) x=12;
              goto preproc;
            default:
              break;
          }
          y2=*(mod8+y);
          tmp=dbuff+ *(offset+y) +x;
          idx= (*str)<<2;
          tempint=font+idx;
        /* the following used to be a for loop that I unrolled */

          lkup= *(tempint++)<<y2;
          *tmp |= (char)lkup;
          tmp+=102;
          *tmp |= (char)((lkup&0xFF00)>>8);
          tmp-=101;

          lkup= *(tempint++)<<y2;
          *tmp |= (char)lkup;
          tmp+=102;
          *tmp |= (char)((lkup&0xFF00)>>8);
          tmp-=101;

          lkup= *(tempint++)<<y2;
          *tmp |= (char)lkup;
          tmp+=102;
          *tmp |= (char)((lkup&0xFF00)>>8);
          tmp-=101;

          lkup= *(tempint)<<y2;
          *tmp |= (char)lkup;
          tmp+=102;
          *tmp |= (char)((lkup&0xFF00)>>8);
          tmp-=101;

        str++;
        x+=4;
      } while (x<100);  /* 25 columns */
      y++;
    } while (y<=9);    /* max of 10 lines per screen */
  } else {
    do {
      x=0;
      wrapped=1;
      do { /* max of 25 characters wide */
        if(!*str) {    /* end of string? */
          goto out;     /* I like gotos... so bite me. */
        }
        preprocshow:
          switch (*str) {
            case 0x0D:
              if (*(str+1) == 0x0A) str++;
            case 0x0A:
              str++;
              if (!(wrapped && (x==0))) {
                x=0;
                wrapped=0;
                if (++y >9) goto out;
              }
              goto preprocshow;
            case '\t':
              str++;
              if (x==0) x=12;
              goto preprocshow;
            default:
              break;
          }
        str++;
        x+=4;
      } while (x<100);  /* 25 columns */
      y++;
    } while (y<=9);    /* max of 10 lines per screen */

  }
  out:
  if(show)
    gv_aput(0,0,102,64,(unsigned long) dbuff,0);
  retval = (str-strtmp);


  return retval;

}

char *
int2ascii(int num,int *Len)
{
        int i,c,n;
        static char ascii[6];
        for(i=0,n=1;(num/n)>0;i++,n*=10)
                ;
        if(i==0) {
                ascii[0]='\0';
                if(Len!=(int *)0)
                        *Len=0;
                return(ascii);
        }
        ascii[i]='\0';
        for(n/=10,c=0;c<i;c++,n/=10) {
                ascii[c]=((num/n)%10)+'0';
        }
        if(Len!=(int *)0)
                *Len=i;
        return(ascii);
}

void
WritePageNum(int PageNum)
{
  /* A smaller font than font8(3x5) could be the following
   *
   * 0:###  1: #  2:###  3:###  4:# #  5:###  6:#    7:###  8:###  9:###
   *   # #     #      #     ##    # #    #      ###      #    ###    # #
   *   # #     #    #        #    ###      #    # #      #    # #    ###
   *   ###     #    ###    ###      #    ###    ###      #    ###      #
   *
   * For now font8(3x5) is enough
   */
  int PageNumLen=0;
  char *PageNumPtr;

  PageNumPtr=int2ascii(PageNum,&PageNumLen);
  gv_kput(102-4*PageNumLen+1,64-5,PageNumPtr,8,1,0);
}

void
save_bookmark(char *bookmark,char *book,int PageNum)
{
  int f,i;
  char *a;
  f=dos_fcreate(bookmark);
  if(f<0) {
          gv_place(0,0);
          cls(4);
          gv_kput(0,30,"can't bookmark",2,0,0);
          while(!bi_getbtn());
          dos_exit(0);
  }
  dos_fwrite(f,"<BOOK=",6);
  dos_fwrite(f,book,strlen(book));
  dos_fwrite(f,"><PAGE=",7);
  dos_fwrite(f,(a=int2ascii(PageNum,&i)),i);
  dos_fwrite(f,">\r\n",3);
  dos_fclose(f);
  bi_vwrflush();
  gv_place(0,0);
  cls(4);
  gv_kput(0,10,"Bookmark saved",2,0,0);
  gv_kput(0,30,"Book=",2,0,0);
  for(i=strlen(book);i>0 && book[i-1]!='\\';i--);
  gv_kput(6*5,30,book+i,2,0,0);
  gv_kput(0,40,"Page=",2,0,0);
  gv_kput(6*5,40,a,2,0,0);
  while(!bi_getbtn());
}

int main()

{
        int bt,ret,err=0;
        int line;
        int i,f;
  long maxlen;
  unsigned int maxline=MAXLN;
  char *buffp=NULL;
  char *argv;
  char fontname[50];
  char bookmark[50];
  char book[50];
  int PageNum=1;
  int ReqPageNum=1;
  int Repetir,Vez=0;
  char Final=0;
  char Mover;

  argv=getArg();
        screen(1);
  strcpy(book,argv);
  do {
     Vez++;
     Repetir=0;
           gv_place(0,0);
           cls(4);
     f=dos_fopen(book,0);
     if (f<0) {
       gv_kput(0,30,"can't open file",2,0,0);
       err=1;
     }
     else {
       gv_kput(0,30,"wait...",2,0,0);
       maxlen=dos_fseek(f,2,0);   /* seek to eof */
       dos_fseek(f, 0, 0);
       if (maxlen<MAXSIZE) {
         dos_fread(f,filebuff,maxlen);
       }
       else {
         gv_kput(0,10,"file too big.",2,0,0);
         err=1;
       }
       dos_fclose(f);
       buffp=filebuff;
       i=0;
       if (filebuff[0]==0)  {
         gv_kput(0,30,"Not a text file.",2,0,0);
         err=1;
       } else
       {
         if ((buffp[0]=='<') && (buffp[1]=='T')) {
           buffp+=6;                 // just skip the TFNT= part right now
           while (*buffp!='>') fontname[i++]=*(buffp++);  //copy the filename
           fontname[i]=0;
           buffp++;
         } else strcpy(fontname,"\\system\\mmp\\tinyfont.mmp");
         if(Vez==1) {
            if((buffp[0]=='<') && (buffp[1]=='B')) {
              buffp+=6;                 // just skip the BOOK= part right now
              while (*buffp!='>') book[i++]=*(buffp++);  //copy the filename
              book[i]=0;
              buffp++;
              strcpy(bookmark,argv);
              Repetir=1;
              if((buffp[0]=='<') && (buffp[1]=='P')) {
                 buffp+=6;                 // just skip the PAGE= part right now
                 ReqPageNum=0;
                 while (*buffp!='>') {
                        ReqPageNum*=10;
                        ReqPageNum+=*(buffp++)-'0';
                 }
                 buffp++;
                 Mover=1;
              }
            } else {
              strcpy(bookmark,argv);
              for(i=strlen(bookmark);i>0 && bookmark[i-1]!='\\';i--)
                      ;
              strcpy(bookmark+i,"bookmark.txt");
            }
         }
       }
     }
  } while(Repetir);
  if ((!err) && (mpread(font,fontname))) {
    gv_kput(0, 22,fontname,2,0,0);
    gv_kput(0, 30, "font not found", 2, 0, 0);
    err=1;
  }
  else {
    /* show the first page */
    scroll[0]=0;
    line=1;
    scroll[line]=dbuffstr(buffp,!Mover);
    if (!*(buffp+scroll[line])) {
      scroll[line]=0;
      maxline=line;
    }
    WritePageNum(PageNum);
    /* now wait for key press */
    while(1) {
      if(Mover==1) {
        if(PageNum<ReqPageNum && Final!=1) {
                bt=Bkey_dw;
        } else {
                Mover=0;
                dbuffstr(buffp,!Mover);  //redraw
                WritePageNum(PageNum);
                continue;
        }
      } else {
        bt = Keyin((Bkey_up|Bkey_dw), -1);
        ret = EventCall(bt);
        if(ret==-1) {
                // Save position into bookmark file
                save_bookmark(bookmark,book,PageNum);
                dos_exit(0); //return;   // application termination request
        } else if(ret==1) {
          ret = EventExec();   // application timeout?
          if(ret==-1) {
                // Save position into bookmark file
                save_bookmark(bookmark,book,PageNum);
                dos_exit(0); //return; // application termination request
          }
        }
      }
      if(bt & Bkey_D) {
        // Save position into bookmark file
        save_bookmark(bookmark,book,PageNum);
        // return
        dos_exit(0);
      } else if(bt & Bkey_up) {
        if(line>1) {
          buffp-=scroll[--line];
          dbuffstr(buffp,!Mover);
          if(PageNum>1) {
                  PageNum--;
                  Final=0;
          }
          WritePageNum(PageNum);
        }
      } else if( bt & Bkey_dw) {
        if (line < maxline) {
          buffp+=scroll[line++];
          scroll[line]=dbuffstr(buffp,!Mover);
          if (!*(buffp+scroll[line])) {
            scroll[line]=0;
            maxline=line;
          }
          PageNum++;
          WritePageNum(PageNum);
        } else
                Final=1;
      } else if(bt) {
        dbuffstr(buffp,!Mover);  //redraw
        WritePageNum(PageNum);
      }
    }
  }
  if (err) while(!bi_getbtn());
  cls(4);
  return(0);
}
