/*
 * Texto2ruputer
 *
 *  Coge un texto y lo "maqueta" a lo que necesita el tinytext
 * (trozos<16KB y lineas <=25 car.).
 *
 * Historia:
 *   16/06/00 Creacin. Primera versin funcional.
 *   17/06/00 Hago que no ponga los espacios en blanco de principio de
 *           lnea. Empiezo a hacer que antes de procesar el fichero haga
 *           que los parrafos estn en una sla lnea.
 *   19/06/00 Termino con el cdigo que hace que los parrafos estn en una
 *           sla lnea. Dejo que escriba en un fichero el texto en prrafos
 *           pero sin "procesar" para el ruputer.
 *   31/12/00 Implemento la banderadoblesp y hago que por defecto quite dobles
 *           espacios
 *   02/01/01 Pongo en la ayuda una nota sobre el fromdos.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAXTAMFICH    15*1024
#define NCOL 25
#define TAMSUFIJOFICH 7

int
main(int argc, char *argv[])
{
        FILE *entrada=NULL;
        FILE *salida=NULL;
        char *texto;
        char *buffernombrefich;
        long tambuffernombrefich;
        unsigned long tamtexto,leidos,escritos;
        long posicion=0,posreltemp=0,posrelnuevalinea=0,posrelultimoespacio=0;
        unsigned long escribir=0;
        long numfich=0;
        long escritofich=0;
        char letra=0;
        char banderaponernuevalinea=0;
        unsigned long maxtamfich=MAXTAMFICH;
        unsigned long ncol=NCOL;
        unsigned int banderaromper=0,banderanojuntar=0,banderadoblesp=0;
        /* La ayuda (algo escueta y slo en condiciones de error */
        if(argc<3) {
                printf("text2ruputer - programa que maqueta los textos de forma asequible al tinytext\n\n");
                printf("Sintaxis:\n\t%s nombfich.txt nombre \n\t\t[maxtamfich [numcol [banderaromper [banderanojuntar [banderadoblesp]]]]\n",argv[0]);
                printf("Siendo:\n\tnombfich.txt - el fichero a maquetar\n\tnombre       - el prefijo de los nombre_nn.txt que crea el programa\n");
                printf("\tmaxtamfich   - el tamao mximo de fichero a crear (p.ej.%lu)\n\tnumcol       - el nmero de columnas disponibles en pantalla (p.ej.%lu)\n\tbanderaromper - (se activa poniendo un 1) por si se quiere poner\n\t\t un enter aunque la lnea acabe justo en la ltima columna\n",maxtamfich,ncol);
                printf("\tbanderanojuntar - (se activa poniendo un 1) por si no se quiere que\n\t\t junte las lneas para rellenar la mayor cantidad de pantalla\n");
                printf("\tbanderadoblesp - (se activa poniendo un 1) por si no se quiere que\n\t\t cuando hay ms de un espacio seguido slo ponga uno\n");
                printf("NOTA: los textos deben estar en formato UN*X, no en formato DOS, ya que el\n      programa quita los \\n pero no los \\r(^M). Para ello se pueden usar\n      las utilidades fromdos, recode o dos2unix.\n");
                return(1);
        }
        if(argc>=4)
                sscanf(argv[3],"%lu",&maxtamfich);
        if(argc>=5)
                sscanf(argv[4],"%lu",&ncol);
        if(argc>=6)
                sscanf(argv[5],"%li",&banderaromper);
        if(argc>=7)
                sscanf(argv[6],"%li",&banderanojuntar);
        if(argc>=8)
                sscanf(argv[7],"%li",&banderadoblesp);
        if(argc>=4)
                printf("Usando:\n\tmaxtamfich=%lu\n\tncol=%lu\n\tbanderaromper=%s\n\tbanderanojuntar=%s\n\tbanderadoblesp=%s\n",maxtamfich,ncol,(banderaromper!=0)?"S":"No",(banderanojuntar!=0)?"S":"No",(banderadoblesp!=0)?"S":"No");
        /* Preparamos un pequeo buffer para poner los nombres de los ficheros a escribir */
        tambuffernombrefich=strlen(argv[2])+TAMSUFIJOFICH+1;
        buffernombrefich=malloc(tambuffernombrefich);
        if(buffernombrefich==NULL) {
                printf("ERROR: No se ha localizado memoria suficiente (req: %lu bytes)\n",tambuffernombrefich);
                return(2);
        }
        /* Leemos el fichero en memoria (ya que la tenemos...) */
        entrada=fopen(argv[1],"r");
        if(entrada==NULL) {
                free(buffernombrefich);
                printf("ERROR: No se pudo leer de %s\n",argv[1]);
                return(2);
        }
        fseek(entrada,0,SEEK_END);
        tamtexto=ftell(entrada);
        fseek(entrada,0,SEEK_SET);
        texto=malloc(tamtexto);
        if(texto==NULL) {
                fclose(entrada);
                free(buffernombrefich);
                printf("ERROR: No se ha localizado memoria suficiente (req: %lu bytes)\n",tamtexto);
                return(2);
        }
        leidos=fread(texto,1,tamtexto,entrada);
        if(leidos!=tamtexto) {
                fclose(entrada);
                free(texto);
                free(buffernombrefich);
                printf("ERROR: No se ha podido leer todo el fichero (req: %lu bytes, leidos: %lu bytes)\n",tamtexto,leidos);
                return(2);
        }
        fclose(entrada);
        /* Intentamos quitar los "nueva linea" que estn de ms... */
        if(!banderanojuntar) {
                unsigned long pos,posabsanterior,saltados,lin1;
                char banderablanco,banderaunomenos,banderablancoanterior;
                for(posabsanterior=0,pos=0,saltados=0,banderaunomenos=0,banderablanco=1;(pos+saltados)<tamtexto;pos=pos+1-banderaunomenos,banderaunomenos=0) {
                        if(texto[pos+saltados]=='\n') {
                                for(lin1=1,banderablancoanterior=banderablanco,banderablanco=1;(pos+saltados+lin1)<tamtexto && texto[pos+saltados+lin1]!='\n';lin1++) {
                                        if(!isspace(texto[pos+saltados+lin1])) {
                                                banderablanco=0;
                                                break;
                                        }
                                }
                                if(!banderablancoanterior) {
                                        if(!banderablanco) {
                                                if(texto[pos+saltados+1]==' ' || (pos+saltados-posabsanterior)<=1) {
                                                        posabsanterior=pos+saltados;
                                                        saltados++;
                                                        banderaunomenos=1;
                                                        continue;
                                                } else
                                                        texto[pos+saltados]=' ';
                                        }
                                }
                                posabsanterior=pos+saltados;
                        }
                        if(saltados>0)
                                texto[pos]=texto[pos+saltados];
                }
                tamtexto-=saltados;
                {
                        FILE *temp;
                        sprintf(buffernombrefich,"%s_xx.txt",argv[2]);
                        temp=fopen(buffernombrefich,"w");
                        if(temp) {
                                fwrite(texto,1,tamtexto,temp);
                                fclose(temp);
                        }
                }
        }
        if(!banderadoblesp) {
                unsigned long pos,saltados;
                for(pos=1,saltados=0;pos<tamtexto;pos++) {
                        if(texto[pos-1]==' ' && texto[pos]==' ')
                                saltados++;
                        if(saltados>0)
                                texto[pos-saltados]=texto[pos];
                }
                tamtexto-=saltados;
        }
        /* Hacemos el trabajo duro */
        for(posicion=0;posicion<tamtexto;escribir=0,banderaponernuevalinea=0) {
                /* Abrimos un nuevo fichero de salida si no lo hay */
                if(salida==NULL) {
                        escritofich=0;
                        sprintf(buffernombrefich,"%s_%2.2lu.txt",argv[2],numfich++);
                        salida=fopen(buffernombrefich,"w");
                        if(entrada==NULL) {
                                free(texto);
                                free(buffernombrefich);
                                printf("ERROR: No se pudo abrir para escritura %s\n",buffernombrefich);
                                return(2);
                        }
                }
                /* Nos saltamos los espacios en blanco */
                if(!banderanojuntar) {
                        for(;posicion<tamtexto && (texto[posicion]==' ' || texto[posicion]=='\t');posicion++)
                                ;
                }
                /* miramos cuanto tenemos que escribir */
                for(posrelnuevalinea=0;(posrelnuevalinea+posicion)<tamtexto && texto[posicion+posrelnuevalinea]!='\n';posrelnuevalinea++)
                        ;
                if(posrelnuevalinea<ncol) {
                        escribir=posrelnuevalinea+1;
                } else {
                        escribir=ncol;
                        if((posicion+escribir)>tamtexto)
                                escribir=tamtexto-posicion;
                        else {
                                for(posrelultimoespacio=0,posreltemp=0;posreltemp<=ncol;posreltemp++) {
                                        if(isspace(texto[posicion+posreltemp]))
                                                posrelultimoespacio=posreltemp;
                                }
                                if(posrelultimoespacio!=0 && (banderaromper || posrelultimoespacio<ncol)) {
                                        escribir=posrelultimoespacio+1;
                                        banderaponernuevalinea=1;
                                }
                        }
                }
                /* lo escribimos si ha lugar */
                if(escritofich+escribir+banderaponernuevalinea>maxtamfich) {
                        fclose(salida);
                        salida=NULL;
                        continue;
                }
                escritos=fwrite(texto+posicion,1,escribir,salida);
                if(escritos!=escribir) {
                        printf("AVISO: parece que no se ha escrito todo lo que debiera (req: %lu bytes, escritos: %lu bytes)\n",escribir,escritos);
                }
                posicion+=escritos;
                escritofich+=escritos;
                if(banderaponernuevalinea) {
                        escritos=fwrite("\x0a",1,1,salida);
                        if(escritos!=1)
                                printf("AVISO: parece que no se ha escrito todo lo que debiera (req: %lu bytes, escritos: %lu bytes)\n",1,escritos);
                        escritofich+=escritos;
                }
        }
        /* Limpiamos y salimos */
        if(salida!=NULL)
                fclose(salida);
        free(texto);
        free(buffernombrefich);
        return(0);
}

