/*
 * wbios.h
 *
 * Simulacin de las funciones de WBIOS del onHand/Ruputer.
 * Slo las que necesito por ahora y hecho como un hack.
 *
 * Historia:
 *      29/12/00 Hago bi_getbtn() como un hack usando stdio.h
 *      07/01/01 Rehago bi_getbtn() usando libgii, pero de manera burda.
 *      08/01/01 Rehago bi_getbtn(), ya implementndola con bffer de teclas.
 *      09/01/01 Pongo stubs del resto de las funciones de la wbios. Hago
 *               las que quedaban de botones (excepto las de chattering).
 *      01/02/01 Relleno bi_tmread() y bi_dtread().
 *      19/02/01 Cambio bi_tmread()/bi_dtread para que guarden los valores
 *               en BCD.
 *      22/04/01 Implemento los sucesos del tipo EVENT_SEC/MIN/HOUR, por
 *               medio de la tecla espacio.
 *       4/10/01 Modifico input_procesa() para que acepte teclas fake de
 *               repeticin, y que cuando le llega una nueva tecla reinicialice
 *               el contador de no repeticin.
 *       5/12/01 Arreglos cosmticos para que no de ningn warning cuando se
 *               compila con -Wall.
 *       4/01/02 Pongo en input_buffer() la bandera NoAhora, para poderla llamar
 *               en la rutina de timer (s ya s que esto no es serio en
 *               entornos de multitarea preemptiva o con interrupciones, pero
 *               no me merece la pena hacerlo con semforos...).
 *       6/01/02 Lo he cambiado un poco. Usa un bit dentro de la estructura
 *               de teclado para que *FUERA* comprueben si se puede llamar o no.
 *               No es peligroso as ya que el programa es "single-threaded".
 *
 */

#ifndef _WBIOS_H
#define _WBIOS_H

#include <string.h>
#include <time.h>
#include "lcdbios.h"

/* #define DEBUG_TECLAS_WBIOS */

/* Prototipos de funciones de WBIOS: entrada de botones*/
int bi_getbtn(void);
int bi_sensbtn(int *code);
int bi_scanbtn(void);
void bi_clrbtn();
void bi_chatpsbtn(int clk);
void bi_chatjkbtn(int clk);

/* Prototipos de funciones de WBIOS: control de discos */
int bi_secread(int drive,int head,int cyl,int secno,int snum,void *rbuf);
int bi_secwrite(int drive,int head,int cyl,int secno,int snum,void *wbuf);
int bi_format(int drive,int level);
int bi_getdrform(int drive,int *inf);
int bi_setdrform(int drive,int cyl,int hed,int secnt,int secsize);
int bi_wrflush(int drive);

/* Prototipos de funciones de WBIOS: RS-232c/IR */
int bi_cominit(int comdev,int baud,int pulse,int timeout);
int bi_comopen(void);
int bi_comclose(void);
int bi_comwrite(char cdat);
int bi_complwrite(char *cdat,int clen,int *num);
int bi_comread(char *cdat);
int bi_complread(char *cdat,int clen);
int bi_complreadn(char *cdat,int clen,int *num);
int bi_comclr(void);
int bi_comrnum(void);

/* Prototipos de funciones de WBIOS: RTC */
int bi_tmread(char *hour,char *minute,char *second);
int bi_tmwrite(char hour,char minute,char second);
int bi_dtread(char *year,char *month,char *day);
int bi_dtwrite(char year,char month,char day);

/* Prototipos de funciones de WBIOS: timer */
int *bi_tmset(int kind,int prio,int cnt,void (*func)());
int bi_tmdel(int *timerid);

/* Prototipos de funciones de WBIOS: sonido */
void bi_buzzinit(int volume,int tempo);
int bi_buzzer(unsigned char tone,unsigned char length);
void bi_melody(unsigned int *melody);
void bi_canmelody(void);

/* Prototipos de funciones de WBIOS: control del sistema */
void bi_reboot(void);
void bi_cpususp(void);
int bi_powerread(void);
int bi_powerread2(void);
int bi_current(void);
unsigned long bi_getpower(void);
void bi_setpower(unsigned long count);
void bi_el(int sec);
int bi_27Verror(void);
void bi_setvect(int ino,void (*func)());
void (*bi_getvect(int ino))();
int bi_sysread(void *rbuf);
int bi_syswrite(void *wbuf);

/* Fake de las funciones */
unsigned short
input_procesa(gii_event *ev)
{
#ifdef DEBUG_TECLAS_WBIOS
        static char *Literales[]={"<FILER>","<MENU>","<EL>","<ENTER>",
                                    "<IZQ>","<ARR>","<DER>","<ABJ>"};
#endif
        char Letra;
        char *Ptr;
        char BanderaFake,LetraFake;
        int Num;
        BanderaFake=0;
        if(ev->any.type==evKeyPress) {
                LetraFake=ev->key.sym^0x80;
                if((LetraFake>='a' && LetraFake<='z') || (LetraFake>='A' && LetraFake<='Z'))
                        Letra=LetraFake,BanderaFake=1;
                else
                        Letra=ev->key.sym;
                if(Letra>='a' && Letra<='z')
                       Letra=Letra-'a'+'A';
                if(Letra==' ') {
#if defined(ESCRIBIR_PLANTILLA_GII_EVENT) && defined(DEBUG_TECLAS_WBIOS)
                        for(Num=0,printf("char Plantilla_gii_event[]={"),fflush(stdout);Num<sizeof(gii_event);Num++) {
                                if((Num%16)==0)
                                        printf("\n");
                                printf("%s0x%2.2x",((Num==0)?"":","),((char *)ev)[Num]);
                                fflush(stdout);
                        }
                        printf("};\n");
                        fflush(stdout);
#endif
                        if(SimTeclado.NumEvSec) {
                                SimTeclado.NumEvSec--;
                                return(0x8000);
                        }
                        if(SimTeclado.NumEvMin) {
                                SimTeclado.NumEvMin--;
                                return(0x8000);
                        }
                        if(SimTeclado.NumEvHour) {
                                SimTeclado.NumEvHour--;
                                return(0x8000);
                        }
                        return(0xffff);
                }
                Ptr=strchr(SimTeclado.TeclasBits,Letra);
                if(Ptr==NULL || !(Ptr>=SimTeclado.TeclasBits && Ptr<=(SimTeclado.TeclasBits+7)))
                        return(0xffff);
                Num=Ptr-SimTeclado.TeclasBits;
#ifdef DEBUG_TECLAS_WBIOS
                printf("Llegada de una tecla: %s\n",Literales[Num]);
                fflush(stdout);
#endif
                if(!BanderaFake) {
                        SimTeclado.BotonesActivos|=(0x1<<Num);
                        SimTeclado.ContadorNoRepeticion=4;
                }
                return(SimTeclado.PalabraEstado | (0x1<<Num));
        } else if(ev->any.type==evKeyRelease) {
                LetraFake=ev->key.sym^0x80;
                if((LetraFake>='a' && LetraFake<='z') || (LetraFake>='A' && LetraFake<='Z'))
                        Letra=LetraFake,BanderaFake=1;
                else
                        Letra=ev->key.sym;
                if(Letra>='a' && Letra<='z')
                       Letra=Letra-'a'+'A';
                Ptr=strchr(SimTeclado.TeclasBits,Letra);
                if(Ptr==NULL || !(Ptr>=SimTeclado.TeclasBits && Ptr<=(SimTeclado.TeclasBits+7)))
                        return(-1);
                Num=Ptr-SimTeclado.TeclasBits;
#ifdef DEBUG_TECLAS_WBIOS
                printf("Llegada de una tecla: %s (soltar)\n",Literales[Num]);
                fflush(stdout);
#endif
                if(!BanderaFake)
                        SimTeclado.BotonesActivos&=~(0x1<<Num);

                return(0xffff);
        } else
        return(0xffff);
}

void
input_buffer(char BanderaEsperarTecla)
{
        int n;
        gii_event ev;
        unsigned short Tecla;
        struct timeval tv = {0,0};
        SimTeclado.BanderaInputBuffer=1;
        ggiEventPoll(SimTeclado.Entrada,emAll,&tv);
        n = ggiEventsQueued(SimTeclado.Entrada,emAll);
        while (n && SimTeclado.NumBuffer<MAX_NUM_TECLAS) {
                ggiEventRead(SimTeclado.Entrada,&ev,emAll);
                /*DESACTIVA_TIMER();*/
                if((Tecla=input_procesa(&ev))!=0xffff)
                        SimTeclado.Buffer[SimTeclado.NumBuffer++]=Tecla;
                /*ACTIVA_TIMER();*/
                n--;
        }
        while(BanderaEsperarTecla && SimTeclado.NumBuffer==0) {
                ggiEventRead(SimTeclado.Entrada,&ev,emAll);
                /*DESACTIVA_TIMER();*/
                if((Tecla=input_procesa(&ev))!=0xffff)
                        SimTeclado.Buffer[SimTeclado.NumBuffer++]=Tecla;
                /*ACTIVA_TIMER();*/
        }
        SimTeclado.BanderaInputBuffer=0;
}

unsigned short
input_extraetecla(void)
{
        unsigned short Tecla;
        if(SimTeclado.NumBuffer==0)
                return(SimTeclado.PalabraEstado);
        Tecla=SimTeclado.Buffer[0];
        memmove(SimTeclado.Buffer,SimTeclado.Buffer+1,--SimTeclado.NumBuffer);
        return(Tecla);
}

int
bi_getbtn(void)
{
        /* Reads a button from the button data buffer encoded in a word */
        /* (b7...Down/Right/Up/Left/Enter/El/Menu/Filer...b0; b15: Event) */
        input_buffer(1);
        return(input_extraetecla());
}

int
bi_sensbtn(int *code)
{
        /* If true, returns into code the next word waiting in the button data buffer */
        if(SimTeclado.NumBuffer>0) {
                *code=SimTeclado.Buffer[0];
                return(1);
        }
        return(0);
}

int
bi_scanbtn(void)
{
        /* Read the button I/O ports and return actual status of the buttons encoded as in bi_getbtn() but b15:Event always 0 */
        return(SimTeclado.BotonesActivos | SimTeclado.PalabraEstado);
}

void
bi_clrbtn()
{
        /* Clears the button data buffer, discarding any ramaining keys */
        SimTeclado.NumBuffer=0;
        return;
}

void
bi_chatpsbtn(int clk)
{
        /* Sets the clock to (clk*16)Hz (default: clk=1) to prevent misunderstanding of Filer/Menu/EL/Enter buttons because of chattering */
        printf("bi_chatpsbtn(): STUB\n");
        return;
}

void
bi_chatjkbtn(int clk)
{
        /* Sets the clock to (clk*16)Hz (default: clk=1) to prevent misunderstanding of cursor buttons because of chattering */
        printf("bi_chatjkbtn(): STUB\n");
        return;
}


/* funciones de control de discos */

int
bi_secread(int drive,int head,int cyl,int secno,int snum,void *rbuf)
{
        /* Reads snum sectors into rbuf, returning the number of sectors actually read */
        printf("bi_secread(): STUB\n");
        return(0);
}

int
bi_secwrite(int drive,int head,int cyl,int secno,int snum,void *wbuf)
{
        /* Writes snum sectors from wbuf, returning the number of sectors actually written */
        printf("bi_secwrite(): STUB\n");
        return(0);
}

int
bi_format(int drive,int level)
{
        /* Formats drive (1=Flash) using the specified level (1=deletion only;2=write check and deletion;3=write check,deletion and read check) */
        printf("bi_format(): STUB\n");
        return(0);
}

int
bi_getdrform(int drive,int *inf)
{
        /* Returns drive information into inf (8bytes: maxCyl/maxHead/maxSect/SectorSize, being sector size 0=128/1=256/2=512bytes) */
        printf("bi_getdrform(): STUB\n");
        return(0);
}

int
bi_setdrform(int drive,int cyl,int hed,int secnt,int secsize)
{
        /* Sets format information of the specified drive, useful only as preamble of formatting a drive */
        printf("bi_setdrform(): STUB\n");
        return(0);
}

int
bi_wrflush(int drive)
{
        /* Flush the write buffer of the specified drive (1=Flash). Must be called after using dos_write()/dos_fwrite() */
        printf("bi_wrflush(): STUB\n");
        return(0);
}

/* funciones de RS-232c/IR */

int
bi_cominit(int comdev,int baud,int pulse,int timeout)
{
        /* Init the comm port (comdev: 0=none,1=SIR,2=RS-232,3=ASK,4=RC,5=SIRad,7=RC2) */
        printf("bi_cominit(): STUB\n");
        return(0);
}

int
bi_comopen(void)
{
        /* Opens the communication device (powers it up) */
        printf("bi_comopen(): STUB\n");
        return(0);
}

int
bi_comclose(void)
{
        /* Closes the communication device (powers it down) */
        printf("bi_comclose(): STUB\n");
        return(0);
}

int
bi_comwrite(char cdat)
{
        /* Transmits the character in cdat */
        printf("bi_comwrite(): STUB\n");
        return(0);
}

int
bi_complwrite(char *cdat,int clen,int *num)
{
        /* Transmits clen characters from cdat; on failure puts into num the number of characters not transmitted */
        printf("bi_complwrite(): STUB\n");
        return(0);
}

int
bi_comread(char *cdat)
{
        /* Receives a character and saves it into cdat. Drawing in the LCD during reception is discouraged as its stops the receive interrupt */
        printf("bi_comread(): STUB\n");
        return(0);
}

int
bi_complread(char *cdat,int clen)
{
        /* Receives clen characters from cdat returning the number of characters received */
        printf("bi_complread(): STUB\n");
        return(0);
}

int
bi_complreadn(char *cdat,int clen,int *num)
{
        /* Receives clen characters from cdat; on failure puts into num the number of characters received */
        printf("bi_complreadn(): STUB\n");
        return(0);
}

int
bi_comclr(void)
{
        /* Clears the communication receive buffer of 150bytes */
        printf("bi_comclr(): STUB\n");
        return(0);
}

int
bi_comrnum(void)
{
        /* Returns the number of characters waiting in the receive buffer */
        printf("bi_comrnum(): STUB\n");
        return(0);
}

/* funciones del RTC */

int
bi_tmread(char *hour,char *minute,char *second)
{
        /* Reads the time from the RTC circuit */
        time_t HoraSegundos;
        struct tm *Hora;
        HoraSegundos=time(NULL);
        Hora=localtime(&HoraSegundos);
        *hour=((Hora->tm_hour/10) << 4) | (Hora->tm_hour%10);
        *minute=((Hora->tm_min/10) << 4) | (Hora->tm_min%10);
        *second=((Hora->tm_sec/10) << 4) | (Hora->tm_sec%10);
        return(0);
}

int
bi_tmwrite(char hour,char minute,char second)
{
        /* Writes the time into the RTC circuit */
        printf("bi_tmwrite(): STUB\n");
        return(0);
}

int
bi_dtread(char *year,char *month,char *day)
{
        /* Reads the date from the RTC circuit */
        time_t HoraSegundos;
        struct tm *Hora;
        HoraSegundos=time(NULL);
        Hora=localtime(&HoraSegundos);
        *year=Hora->tm_year % 100;
        *year=(((*year)/10) << 4) | ((*year)%10);
        *month=((Hora->tm_mon/10) << 4) | (Hora->tm_mon%10);
        *day=((Hora->tm_mday/10) << 4) | (Hora->tm_mday%10);
        return(0);
}

int
bi_dtwrite(char year,char month,char day)
{
        /* Writes the date into the RTC circuit */
        printf("bi_dtwrite(): STUB\n");
        return(0);
}

/* funciones del timer */

int *
bi_tmset(int kind,int prio,int cnt,void (*func)())
{
        /* Grab a timer (kind:0=1Hz,1=4Hz,2=64Hz) of the specified prio (0-255; 0=greatest) to be called every cnt times and
        return a timer_id pointer (-1=error) */
        printf("bi_tmset(): STUB\n");
        return(0);
}

int
bi_tmdel(int *timerid)
{
        /* Release the specified timer (NOTE: a timer int *timerid can be temporarily stopped by *timerid=0, and restarted by
        *timerid=cnt). */
        printf("bi_tmdel(): STUB\n");
        return(0);
}

/* funciones de sonido */

void
bi_buzzinit(int volume,int tempo)
{
        /* Inits buzzer with the specified volume (2=low,9=high) and the specified tempo (NOTE: note_length=tempo*length/64 secs) */
        printf("bi_buzzinit(): STUB\n");
        return;
}

int
bi_buzzer(unsigned char tone,unsigned char length)
{
        /* Plays a note with the specified tone (0=A1#,89=C9) and length (b3..b0: length w/ 0=16; b7..b4 envelope) */
        printf("bi_buzzer(): STUB\n");
        return(0);
}

void
bi_melody(unsigned int *melody)
{
        /* Plays a melody in background, being each word a note (b0-b7:tone,b8-b15:length) and 0xffff the terminating word (progress info at *(0xf27c)) */
        printf("bi_melody(): STUB\n");
        return;
}

void
bi_canmelody(void)
{
        /* Stops the current playing melody (if any) */
        printf("bi_canmelody(): STUB\n");
        return;
}

/* funciones de control del sistema */

void
bi_reboot(void)
{
        /* Reboots the system */
        printf("bi_reboot(): STUB\n");
        return;
}

void
bi_cpususp(void)
{
        /* Stops the CPU */
        printf("bi_cpususp(): STUB\n");
        return;
}

int
bi_powerread(void)
{
        /* Returns the supply voltage (0-255) as read from the A/D converter */
        printf("bi_powerread(): STUB\n");
        return(0);
}

int
bi_powerread2(void)
{
        /* Returns the supply voltage (0-255) calculated under heavy load */
        printf("bi_powerread2(): STUB\n");
        return(0);
}

int
bi_current(void)
{
        /* Returns the charging/discharging current (0-255). (NOTE: in the manuals its use is discouraged) */
        printf("bi_current(): STUB\n");
        return(0);
}

unsigned long
bi_getpower(void)
{
        /* Returns the charge count value (160000000d=100%, 32000000d=0%) */
        return(160000000L);
}

void
bi_setpower(unsigned long count)
{
        /* Sets the charge count value to the specified one */
        printf("bi_setpower(): STUB\n");
        return;
}

void
bi_el(int sec)
{
        /* Lights the EL for the specified amount of seconds (sec=0 turns it off) */
        printf("bi_el(): STUB\n");
        return;
}

int
bi_27Verror(void)
{
        /* Returns true if low voltage is detected */
        printf("bi_27Verror(): STUB\n");
        return(0);
}

void
bi_setvect(int ino,void (*func)())
{
        /* Sets the specified interrupt vector (ino: 0-16=hardware ints, 20-31=software ints) */
        printf("bi_setvect(): STUB\n");
        return;
}


void (*bi_getvect(int ino))()
{
        /* Returns the currect handler for the specified interrupt vector */
        printf("bi_getvect(): STUB\n");
        return(NULL);
}

int
bi_sysread(void *rbuf)
{
        /* Copies the contents of the Flash's system area (512bytes) into rbuf */
        printf("bi_sysread(): STUB\n");
        return(0);
}

int
bi_syswrite(void *wbuf)
{
        /* Writes the contents of the system area (copies 512bytes from wbuf into the Flash's system area) and does some fixups */
        printf("bi_syswrite(): STUB\n");
        return(0);
}


#endif

