/*
 * rupsys.h
 *
 * Simulacin de las funciones de RUPSYS del onHand/Ruputer.
 * Slo las que necesito por ahora y hecho como un hack.
 *
 * Historia:
 *      25/12/00 Hago unos cuantas macros que las mapeen a las del sistema
 *       4/01/01 Cambio las macros por funciones. Empiezo con los fakes;
 *              pongo las dos primeras de rupsys y todas las de extensin del
 *              wpsdos y de extensin de la wbios. Slo completo las de
 *              E/S de ficheros (por ahora). NOTA: pasar el E/S a las
 *              funciones de streams.
 *       5/01/01 He pasado las funciones de E/S a ficheros a streams y sigue
 *              funcionando igual, por lo que el problema no estaba aqu. De
 *              todas formas lo dejo as que me gusta ms ;-). NOTA: un bug
 *              que me sala en el programa es porque en el PC el tipo de
 *              llamadas es C y en el reloj es tipo PASCAL. Se arregla con
 *              wrappers como macros... (ver dos_fwrite).
 *      01/02/01 Hago los stubs de EventCall() y EventExec().
 *       1/10/01 Pongo las constantes Bkey_*
 *       4/10/01 Hago que Keyin() use la mscara de botones con repeticin.
 *       8/11/01 Hago las modificaciones pertinentes para que la funcin
 *               de abrir un fichero use mi_dos_transformapath(). Aprovecho
 *               para que las funciones de E/S a ficheros actualicen el valor
 *               de DOSerr.
 *       9/11/01 Corrijo un bug; la definicin de la macro dos_fwrite()
 *               terminaba en ";".
 */

#ifndef _RUPSYS_H
#define _RUPSYS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include "lcdbios.h"
#include "wbios.h"
#include "psdos.h"

#define Bkey_A     (1)
#define Bkey_D     (1<<1)
#define Bkey_C     (1<<2)
#define Bkey_B     (1<<3)
#define Bkey_lf    (1<<4)
#define Bkey_up    (1<<5)
#define Bkey_rg    (1<<6)
#define Bkey_dw    (1<<7)
#define Bkey_T     (1<<8)
#define Bkey_BD    (1<<9)
#define Bkey_SH    (1<<11)
#define Bkey_CK    (1<<12)

/* Definicin de las funciones de RUPSYS */
char *getArg(void);
int Keyin(int repeat,int blink);
int EventCall(int bt);
int EventExec(void);

/* Definicin de las funciones de extensin de wPsDOS */
int dos_fcrnew(char *filepath);
int dos_fcreate(char *filepath);
int dos_fopen(char *filepath,unsigned int mode);
int dos_fclose(int handle);
int dos_fread(int handle,char *buf,unsigned int size);
#define dos_fwrite(a,b,c) mi_dos_fwrite(a,c,b)
int mi_dos_fwrite(int handle,unsigned int size,char *buf);
int dos_fdelete(char *filepath);
unsigned long dos_fseek(int handle,int mode,long offset);
int dos_freespace(long size);
int dos_freesect(int size);

/* Definicin de las funciones de extensin a la wbios */
int bi_vwrflush(void);
int bi_vsecread(int drv,int head,int cyl,int secno,int snum,void *rbuf);
int bi_vsecwrite(int drv,int head,int cyl,int secno,int snum,void *wbuf);

/* fake de las funciones de onHand/Ruputer */
char *
getArg(void)
{
        /* Returns the filer association (file name) that originated the program loading. */
        printf("getArg(): STUB\n");
        return("PROGRAM.EXF");
}

int
Keyin(int repeat,int blink)
{
        /*Waits for button and returns the button status (b7...Down/Right/Up/Left/Enter/El/Menu/Filer...b0; b15:Event,
        b11...SerCon/SerIdle/CellMounted...b9), with the specified RepeatDetectMask; blink should be -1. Uses bi_getbtn() to
        perform its task.*/
        int Res;
        SimTeclado.MascaraBotonesRepeticion=repeat;
        Res=bi_getbtn();
        SimTeclado.MascaraBotonesRepeticion=0;
        return(Res);
}

int
EventCall(int bt)
{
        /*Handles the alarm sound event. Must be called after Keyin using the returned value of Keyin as parameter. If it returns
        -1 it's an application termination request, if it returns 1 you have to call EventExec(); otherwise all is ok.*/
        /* printf("EventCall(): STUB\n"); */
        return(0);
}

int
EventExec(void)
{
        /*Handles the mini-filer call, time check display, power off and docking warning message events. After this call you have
        to redraw the screen. If it returns -1 it's an application termination request.*/
        printf("EventExec(): STUB\n");
        return(0);
}

#define MIOPEN_FAIL_IF_EXISTS       0x1
int
mi_dos_open(char *nombre,char *modo,char Banderas)
{
        int i;
        char BufNombre[256];
        DOSerr=0;
        if((SimFicheros.NumAbiertos+1)>=MAX_NUM_FICHEROS || mi_dos_transformapath(nombre,BufNombre)!=0) {
                DOSerr=5;
                return(-1);
        }
        if(Banderas & MIOPEN_FAIL_IF_EXISTS) {
                struct stat buf;
                if(stat(BufNombre,&buf)==0) {
                        DOSerr=5;
                        return(-1);
                }
        }
        for(i=0;i<MAX_NUM_FICHEROS;i++) {
                if(!SimFicheros.BanderaEnUso[i]) {
                        if((SimFicheros.Manejadores[i]=fopen(BufNombre,modo))==NULL) {
                                DOSerr=5;
                                return(-1);
                        }
                        SimFicheros.BanderaEnUso[i]=1;
                        SimFicheros.NumAbiertos++;
                        return(i);
                }
        }
        DOSerr=5;
        return(-1);
}


/* fake de las funciones de extensin al wPsDOS */
int
dos_fcrnew(char *filepath)
{
        /* Open a new file, failing if the file already exists and return a file handle */
        int f;
        f=mi_dos_open(filepath,"w+",MIOPEN_FAIL_IF_EXISTS);
        return(f);
}

int
dos_fcreate(char *filepath)
{
        /* Open a file or create it if it doesn't exist and return a file handle */
        int f;
        f=mi_dos_open(filepath,"w+",0);
        return(f);
}

int
dos_fopen(char *filepath,unsigned int mode)
{
        /* Open a existing file and return a file handle */
        int f;
        char * modo;
        modo=(mode==0)?"r":(mode==1)?"a":"r+";
        f=mi_dos_open(filepath,modo,0);
        return(f);
}

int
dos_fclose(int handle)
{
        if(handle>=0 && handle<MAX_NUM_FICHEROS && SimFicheros.BanderaEnUso[handle]) {
                fclose(SimFicheros.Manejadores[handle]);
                SimFicheros.BanderaEnUso[handle]--;
                SimFicheros.NumAbiertos--;
                DOSerr=0;
        } else
                DOSerr=6;
        return(-1);
}

int
dos_fread(int handle,char *buf,unsigned int size)
{
        /* Read size bytes into buf from the file with the specified file handle */
        int res;
        if(!(handle>=0 && handle<MAX_NUM_FICHEROS && SimFicheros.BanderaEnUso[handle])) {
                DOSerr=6;
                return(0);
        }
        res=fread(buf,1,size,SimFicheros.Manejadores[handle]);
        DOSerr=0;
        return(res);
}

int
mi_dos_fwrite(int handle,unsigned int size,char *buf)
{
        /* Write size bytes from buf into a file with the specified file handle. Requires a call to bi_vwrflush() next to the close of
        the file to actually write the data into flash memory. */
        int res;
        if(!(handle>=0 && handle<MAX_NUM_FICHEROS && SimFicheros.BanderaEnUso[handle])) {
                DOSerr=6;
                return(0);
        }
        res=fwrite(buf,1,size,SimFicheros.Manejadores[handle]);
        DOSerr=0;
        return(res);
}

int
dos_fdelete(char *filepath)
{
        /* Delete the specified file */
        int res;
        if((res=unlink(filepath))!=0)
                DOSerr=5;
        else
                DOSerr=0;
        return(res);
}

unsigned long
dos_fseek(int handle,int mode,long offset)
{
        /* Reposition read/write file offset from the position specified in mode (0:top;1:cur,2:end) */
        int res,donde;
        if(!(handle>=0 && handle<MAX_NUM_FICHEROS && SimFicheros.BanderaEnUso[handle])) {
                DOSerr=6;
                return(0);
        }
        donde=(mode==0)?SEEK_SET:(mode==1)?SEEK_CUR:SEEK_END;
        res=fseek(SimFicheros.Manejadores[handle],offset,donde);
        return(res);
}

int
dos_freespace(long size)
{
        /* Returns true if there is enough space in flash memory to store a file of size bytes */
        printf("dos_freespace(): STUB\n");
        return(1);
}

int
dos_freesect(int size)
{
        /* Returns true if there is enough space in flash memory to store a file of size sectors (a sector contains 512bytes) */
        printf("dos_freesect(): STUB\n");
        return(1);
}

/* fake de las funciones de extensin a la wbios */
int
bi_vwrflush(void)
{
        /* Flush data write buffers into flash memory. Must be called after file close if there has been file write operation */
        printf("bi_vwrflush(): STUB\n");
        return(0);
}

int
bi_vsecread(int drv,int head,int cyl,int secno,int snum,void *rbuf)
{
        /* Reads snum sectors into rbuf from the specified drive, head, cylinder and secno */
        printf("bi_vsecread(): STUB\n");
        return(0);
}

int
bi_vsecwrite(int drv,int head,int cyl,int secno,int snum,void *wbuf)
{
        /* Writes snum sectors into rbuf from the specified drive, head, cylinder and secno */
        printf("bi_vsecwrite(): STUB\n");
        return(0);
}

#endif
