/*
 * psdos.h
 *
 * Simulacin de las funciones de W-PsDOS del onHand/Ruputer.
 * Slo las que necesito por ahora y hecho como un hack.
 *
 * Historia:
 *      01/02/01 Hago dos_exit()
 *      26/10/01 Pongo los stubs de las funciones de "Disk and directory".
 *               Hago los cuerpos de las funciones de "Disk and directory"
 *               excepto dos_dfspace(), dos_gettdrive() y dos_getcdrive().
 *               En dos_fnd_next() falta que compruebe la mscara que se
 *               le pas a dos_fnd_first().
 *      27/10/01 Corrijo un bug en dos_fnd_first/next() por el que usaban
 *               el atributo guardado en el DTA tanto como atributo de bsqueda
 *               como de resultados, pisndose y dando como resultado que
 *               ignorase los directorios despus del fichero fichero.
 *               Arreglo un bug en dos_fnd_next(), que interpretaba mal
 *               los datos de la "struct tm" y otro en el desplazamiento
 *               del ao para almacenarlo en la estructura DTA (movia 10 bits
 *               y eran 9).
 *      28/10/01 Hago que los nombres de fichero que devuelve dos_fnd_next()
 *               sean en maysculas, ya que as los devuelve el onhand/ruputer.
 */

#ifndef _PSDOS_H
#define _PSDOS_H

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "lcdbios.h"

/* Variables globales */
int DOSerr=0;

/* Process management */
void dos_exit(int retcode);

/* RTC */
void dos_gettime(char *phour,char *pmin,char *psec,char *phund);
int dos_settime(char hour,char min,char sec,char hund);
void dos_getdate(char *pweekday,char *pmonth,char *pday,int *pyear);
int dos_setdate(char month,char day,int year);

/* Disk and Directory */
int dos_getcdrvno(void);
int dos_seldrv(int drv);
int dos_getcdir(int drv,char *buffer);
int dos_chdir(char *dname);
int dos_mkdir(char *dname);
int dos_rmdir(char *dname);
int dos_rename(char *oldpath,char *newpath);
int dos_delete(char *pfilepath);
int dos_fnd_first(char *path,int attr);
int dos_fnd_next(void);
void *dos_getdta(void);
void dos_setdta(void *dtap);
int dos_dfspace(int dno,int *dfdata);
void dos_gettdrive(int drv,void *drvp);
void dos_getcdrive(void *drvp);

/* Process management */
void
dos_exit(int retcode)
{
        /* Exits the program with errorlevel retcode [int 21,4c] */
        exit(retcode);
}

/* RTC */
void
dos_gettime(char *phour,char *pmin,char *psec,char *phund)
{
        /* Returns the current hour, minute and second (normal binary number, not BCD as in BIOS), phund is ignored (set to 0) [int 21,2c] */
        printf("dos_gettime(): STUB\n");
        DOSerr=0;
}

int
dos_settime(char hour,char min,char sec,char hund)
{
        /* Sets the hour, minute and second (in decimal, not BCD as in BIOS), phund is ignored [int 21,2d] */
        printf("dos_settime(): STUB\n");
        DOSerr=0;
        return(0);
}

void
dos_getdate(char *pweekday,char *pmonth,char *pday,int *pyear)
{
        /* Returns the current weekday (1: Monday), day of the month, month number and year number (normal binary number, not BCD as in BIOS) [int 21,2a] */
        printf("dos_getdate(): STUB\n");
        DOSerr=0;
}

int
dos_setdate(char month,char day,int year)
{
        /* Sets the current day of the month, month number and year number (normal binary number, not BCD as in BIOS) [int 21,2b] */
        printf("dos_setdate(): STUB\n");
        DOSerr=0;
        return(0);
}

/* Disk and Directory */
int
dos_getcdrvno(void)
{
        /* Returns the current drive (0=A/MROM,1=B/Flash) [int 21,19] */
        DOSerr=0;
        return(1);
}

int
dos_seldrv(int drv)
{
        /* Sets the current drive (0=A/MROM,1=B/Flash) [int 21,0e] */
        DOSerr=0;
        return(1);
}

int
dos_getcdir(int drv,char *buffer)
{
        /* Returns the current directory in the specified drive (drv:0=current,1=A/MROM,2=B/Flash) into buffer [int 21,47] */
        int i;
        char Letra;
        buffer[0]='B';
        buffer[1]=':';
        buffer[2]='\\';
        for(i=0;(Letra=SimFicheros.SubdirectorioActual[i])!='\0';i++)
                buffer[3+i]=((Letra=='/')?'\\':Letra);
        buffer[3+i]='\0';
        printf("dos_getcdir(): STUB\n");
        DOSerr=0;
        return(0);
}

/*
int
prueba_dos_transformapath(int argc, char *argv)
{
        char Destino[256];
        strcpy(SimFicheros.DirectorioRaiz,"/home/dario/Programacion");
        strcpy(SimFicheros.SubdirectorioActual,"src");
        printf("DirectorioRaiz: %s\n",SimFicheros.DirectorioRaiz);
        printf("SubdirectorioActual: %s\n",SimFicheros.SubdirectorioActual);
        if(mi_dos_transformapath( "SYSTEM\\..\\..\\..\\ECHO\\.\\OTRO\\.\\SIEMPRE\\.", Destino)==0) {
                printf("Resultado: %s\n",Destino);
        } else
                printf("ERROR.\n");
        return(0);
}
*/

int
mi_dos_transformapath(char *dname, char *bufdir)
{
        char *Ptr,*PtrIni;
        int i,j;
        long Tam;
        /* Preparamos el directorio al que nos vamos */
        if(dname[1]==':') {
                if(dname[0]!='b' && dname[0]!='B')
                        return(-1);
                dname+=2;
        }
        bufdir[0]='\0';
        if(dname[0]=='\\') {
                dname++;
                strcpy(bufdir,SimFicheros.DirectorioRaiz);
        } else {
                strcpy(bufdir,SimFicheros.DirectorioRaiz);
                if((Tam=strlen(bufdir))>0 && bufdir[Tam-1]!='/')
                        strcat(bufdir,"/");
                strcat(bufdir, ((SimFicheros.SubdirectorioActual[0]=='/')? (SimFicheros.SubdirectorioActual+1): (SimFicheros.SubdirectorioActual)));
        }
        if((Tam=strlen(bufdir))>0 && bufdir[Tam-1]!='/')
                strcat(bufdir,"/");
        for(i=0,j=strlen(bufdir);dname[i]!='\0';i++,j++) {
                if(dname[i]!='\\')
                        bufdir[j]=((dname[i]>='A' && dname[i]<='Z')?(dname[i]-'A'+'a'):dname[i]);
                else
                        bufdir[j]='/';
        }
        if(j>0 && bufdir[j-1]!='/')
                bufdir[j++]='/';
        bufdir[j]='\0';
        /* Quitamos los "/../", ya que sobran en un path absoluto */
        while((Ptr=strstr(bufdir,"/../"))!=NULL) {
                for(PtrIni=Ptr-1;PtrIni>=bufdir && *PtrIni!='/';PtrIni--)
                        ;
                if(PtrIni<bufdir)
                        return(-1);
                for(i=(PtrIni-bufdir), j=(Ptr-bufdir)+3;bufdir[j]!='\0';i++,j++)
                        bufdir[i]=bufdir[j];
                bufdir[i]='\0';
        }
        /* Quitamos los "/./", ya que sobran *SIEMPRE* */
        while((Ptr=strstr(bufdir,"/./"))!=NULL) {
                for(i=(Ptr-bufdir),j=(Ptr-bufdir)+2;bufdir[j]!='\0';i++,j++)
                        bufdir[i]=bufdir[j];
                bufdir[i]='\0';
        }
        /* Quitamos los .*\/ ya que en UN*X no se usan (ignoramos los dems casos) */
        while((Ptr=strstr(bufdir,".*/"))!=NULL) {
                for(i=(Ptr-bufdir),j=(Ptr-bufdir)+2;bufdir[j]!='\0';i++,j++)
                        bufdir[i]=bufdir[j];
                bufdir[i]='\0';
        }
        if((Tam=strlen(bufdir))>1 && bufdir[Tam-1]=='/'
#if 0
        /* para que no se vaya al directotio anterior... (aunque esto es un error en el onhand) */
         && !((Tam=strlen(dname))>1 && dname[Tam-1]=='\\')
#endif
         )
                bufdir[Tam-1]='\0';
        return(0);
}

int
dos_chdir(char *dname)
{
        /* Change the working directory to the specified one [int 21,3b] */
        long Tam;
        char bufdir[256];
        char bufdirant[256];
        /* Transformamos el nombre y guardamos el directorio actual por si el nuevo no es vlido */
        if(mi_dos_transformapath(dname,bufdir)!=0 || getcwd(bufdirant,sizeof(bufdirant))==NULL) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles) */
        if(memcmp(bufdir,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Cambiamos de directorio */
        if(chdir(bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        if((getcwd(bufdir,sizeof(bufdir)))==NULL) {
                chdir(bufdirant);
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos de nuevo que el nuevo directorio es vlido (que no hemos subido niveles) */
        if(memcmp(bufdir,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0) {
                chdir(bufdirant);
                DOSerr=3;
                return(-1);
        } else
                strcpy(SimFicheros.SubdirectorioActual,bufdir+Tam);
        DOSerr=0;
        return(0);
}

int
dos_mkdir(char *dname)
{
        /* Change the working directory to the specified one [int 21,3b] */
        long Tam;
        char bufdir[256];
        /* Transformamos el nombre */
        if(mi_dos_transformapath(dname,bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles ni estemos intentando crear el directorio raiz) */
        if(memcmp(bufdir,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0 || strlen(bufdir)==Tam) {
                DOSerr=3;
                return(-1);
        }
        /* Creamos el directorio */
        if(mkdir(bufdir,0755)!=0) {
                DOSerr=3;
                return(-1);
        }
        DOSerr=0;
        return(0);
}

int
dos_rmdir(char *dname)
{
        /* Remove the specified directory [int 21,3a] */
        long Tam;
        char bufdir[256];
        /* Transformamos el nombre */
        if(mi_dos_transformapath(dname,bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles ni estemos intentando borrar el directorio raiz) */
        if(memcmp(bufdir,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0 || strlen(bufdir)==Tam) {
                DOSerr=3;
                return(-1);
        }
        /* Borramos el directorio */
        if(rmdir(bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        DOSerr=0;
        return(0);
}

int
dos_rename(char *oldpath,char *newpath)
{
        /* Rename or move the file specified from oldpath to newpath (error:11=cannot move) [int 21,56] */
        long Tam;
        char bufdirant[256];
        char bufdirnue[256];
        /* Transformamos el nombre */
        if(mi_dos_transformapath(oldpath,bufdirant)!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles ni estemos intentando renombrar el directorio raiz) */
        if(memcmp(bufdirant,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0 || strlen(bufdirant)==Tam) {
                DOSerr=3;
                return(-1);
        }
        /* Transformamos el nombre y guardamos el directorio actual por si el nuevo no es vlido */
        if(mi_dos_transformapath(newpath,bufdirnue)!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles ni estemos intentando renombrar el directorio raiz) */
        if(memcmp(bufdirnue,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0 || strlen(bufdirnue)==Tam) {
                DOSerr=3;
                return(-1);
        }
        /* Renombramos el fichero/directorio (NOTA: en UN*X esto borra/reemplaza el fichero de destino si lo hubiera) */
        if(rename(bufdirant,bufdirnue)!=0) {
                DOSerr=3;
                return(-1);
        }
        DOSerr=0;
        return(0);
}

int
dos_delete(char *pfilepath)
{
        /* Delete the specified file (WARNING: it's recommended to use dos_fdelete() of rupsys.h instead) [int 21,41] */
        long Tam;
        char bufdir[256];
        if(mi_dos_transformapath(pfilepath,bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles ni estemos intentando borrar el directorio raiz) */
        if(memcmp(bufdir,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0 || strlen(bufdir)==Tam) {
                DOSerr=3;
                return(-1);
        }
        /* Borramos el ficehro */
        if(remove(bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        DOSerr=0;
        return(0);
}

int
dos_fnd_first(char *path,int attr)
{
        /* Fills the DTA (see dos_setdta()) with the first matching entry with the specified attributes (attr:b5...advshr...b0); normal files are always returned (exception: attr=v). Returns 0 on success [int 21,4e] */
        long Tam;
        char bufdir[256];
        char *Ptr;
        /* Transformamos el nombre */
        if(mi_dos_transformapath(path,bufdir)!=0) {
                DOSerr=3;
                return(-1);
        }
        /* Comprobamos que el nuevo directorio es vlido (que no hemos subido niveles ni estemos intentando borrar el directorio raiz) */
        if(memcmp(bufdir,SimFicheros.DirectorioRaiz, (Tam=strlen(SimFicheros.DirectorioRaiz)))!=0) {
                DOSerr=3;
                return(-1);
        }
        if((Ptr=strrchr(bufdir,'/'))!=NULL) {
#ifdef LINUX
                /***************************/
                printf("Truncando con bufdir:\"%s\"\n",bufdir);
                /***************************/
#endif
                Ptr[1]='\0';
                Ptr+=2;
#ifdef LINUX
                /***************************/
                printf("Nuevo bufdir:\"%s\"\n",bufdir);
                /***************************/
#endif
        } else {
                DOSerr=3;
                return(-1);
        }
        if((SIMDTADIR(SimFicheros.DtaActual)=opendir(bufdir))!=NULL) {
                if((SIMDTAPATH(SimFicheros.DtaActual)= malloc(strlen(bufdir)+256))==NULL) {
                        closedir(SIMDTADIR(SimFicheros.DtaActual));
                        SIMDTADIR(SimFicheros.DtaActual)=NULL;
                        DOSerr=3;
                        return(-1);
                }
                strcpy(SIMDTAPATH(SimFicheros.DtaActual),bufdir);
                SIMDTAMASK(SimFicheros.DtaActual)=Ptr;
                SIMDTASEARCHATRIB(SimFicheros.DtaActual)=attr;
#if 0
                if(strstr(path,"\\PRUEBA\\")!=NULL)
                        SIMDTASEARCHATRIB(SimFicheros.DtaActual)|=0x80;
#endif
        }
        return(dos_fnd_next());
}

int
mi_dos_esfichvalido(char *fich)
{
        /* No son ficheros vlidos para el simulador los que tienen letras maysculas y los que no son del tipo 8+3 */
        int i;
        int n,m;
        char BanderaExt;
        char Letra;
        if(fich==NULL)
                return(0);
        if(fich[0]=='.' && (fich[1]=='\0' || (fich[1]=='.' && fich[2]=='\0')))
                return(1);
        for(i=0,n=0,m=0,BanderaExt=0;(Letra=fich[i])!='\0';i++) {
                if(Letra>='A' && Letra<='Z')
                        return(0);
                if(Letra=='.') {
                        if(!BanderaExt)
                                BanderaExt++;
                        else
                                return(0);
                } else {
                        if(!BanderaExt)
                                n++;
                        else
                                m++;
                }
        }
        if(n>8 || m>3)
                return(0);
        return(1);
}

int
dos_fnd_next(void)
{
        /* Fills the DTA with the next matching entry. Returns 0 on success [int 21,4f] */
        struct dirent *Fich;
        char *Ptr;
        struct stat Info;
        struct tm *Hora;
        int i;
        if(SIMDTADIR(SimFicheros.DtaActual)==NULL) {
                DOSerr=3;
                return(-1);
        }
        while(1) {
                if((Fich=readdir(SIMDTADIR(SimFicheros.DtaActual)))==NULL) {
                        closedir(SIMDTADIR(SimFicheros.DtaActual));
                        SIMDTADIR(SimFicheros.DtaActual)=NULL;
                        if(SIMDTAPATH(SimFicheros.DtaActual)!=NULL) {
                                free(SIMDTAPATH(SimFicheros.DtaActual));
                                SIMDTAPATH(SimFicheros.DtaActual)=NULL;
                        }
                        DOSerr=3;
                        return(-1);
                }
                if(!mi_dos_esfichvalido(Fich->d_name)) {
                        printf("dos_fnd_next(): %s no es nombre de fichero vlido para el DOS, se ignora\n",Fich->d_name);
                        continue;
                }
                Ptr= SIMDTAPATH(SimFicheros.DtaActual)+ strlen(SIMDTAPATH(SimFicheros.DtaActual));
                strcat(SIMDTAPATH(SimFicheros.DtaActual),Fich->d_name);
                if(stat(SIMDTAPATH(SimFicheros.DtaActual),&Info)!=0) {
                        printf("dos_fnd_next(): ERROR: Fichero encontrado (\"%s\"), pero no puedo el stat a \"%s\".\n",Fich->d_name,SIMDTAPATH(SimFicheros.DtaActual));
                        *Ptr='\0';
                        continue;
                }
                *Ptr='\0';
                if(S_ISDIR(Info.st_mode)!=0 && !(SIMDTASEARCHATRIB(SimFicheros.DtaActual) & 0x10))
                        continue;
                Hora=localtime(&(Info.st_atime));
                SIMDTATIME(SimFicheros.DtaActual)=0;
                SIMDTATIME(SimFicheros.DtaActual)|=(Hora->tm_sec/2);
                SIMDTATIME(SimFicheros.DtaActual)|=((Hora->tm_min)<<5);
                SIMDTATIME(SimFicheros.DtaActual)|=((Hora->tm_hour)<<10);
                SIMDTADATE(SimFicheros.DtaActual)=0;
                SIMDTADATE(SimFicheros.DtaActual)|=(Hora->tm_mday);
                SIMDTADATE(SimFicheros.DtaActual)|=((Hora->tm_mon+1)<<5);
                SIMDTADATE(SimFicheros.DtaActual)|=((Hora->tm_year - 80)<<9);
                SIMDTASIZE(SimFicheros.DtaActual)=Info.st_size;
                SIMDTAATRIB(SimFicheros.DtaActual)=(S_ISDIR(Info.st_mode)?0x10:0);
#if 1
                if(SIMDTASEARCHATRIB(SimFicheros.DtaActual)&0x80) {
                        int i,j;
                        if(strcmp(Fich->d_name,".")==0 || strcmp(Fich->d_name,"..")==0)
                                continue;
                        j=strlen(Fich->d_name);
                        for(i=0,j--;Fich->d_name[i]!='\0';i++)
                                SIMDTANAME(SimFicheros.DtaActual)[i]=((Fich->d_name[j-i]>='a' && Fich->d_name[j-i]<='z')?(Fich->d_name[j-i]-'a'+'A'):Fich->d_name[j-i]);
                        SIMDTANAME(SimFicheros.DtaActual)[i]='\0';
                } else {
#endif
                for(i=0;Fich->d_name[i]!='\0';i++)
                        SIMDTANAME(SimFicheros.DtaActual)[i]=((Fich->d_name[i]>='a' && Fich->d_name[i]<='z')?(Fich->d_name[i]-'a'+'A'):Fich->d_name[i]);
                SIMDTANAME(SimFicheros.DtaActual)[i]='\0';
#if 1
                }
#endif
#warning FALTA QUE COMPRUEBE QUE EL FICHERO SE CORRESPONDE CON LA MASCARA
                break;
        }
        DOSerr=0;
        return(0);
}

void *
dos_getdta(void)
{
        /* Returns a pointer to the DTA (a buffer of 44 bytes, see dos_setdta()) [int 21,2f] */
        DOSerr=0;
        return(SimFicheros.DtaActual);
}

void
dos_setdta(void *dtap)
{
        /* Sets the DTA buffer (char ff_reserved[22];short ff_ftime,ff_fdate;long ff_fsize;char ff_atrib;char ff_name[13];). The format of ff_ftime is a bit-field (b0..b4: seconds/2, b5..b10: minutes, b11..b15: hours), as well as ff_date (b0..b4: day, b5..b8: month, b9..b15: years since 1980) [int 21,1a] */
        if(dtap!=SimFicheros.DtaActual) {
                if(SIMDTADIR(SimFicheros.DtaActual)!=NULL) {
                        closedir(SIMDTADIR(SimFicheros.DtaActual));
                        SIMDTADIR(SimFicheros.DtaActual)=NULL;
                }
                if(SIMDTAPATH(SimFicheros.DtaActual)!=NULL) {
                        free(SIMDTAPATH(SimFicheros.DtaActual));
                        SIMDTAPATH(SimFicheros.DtaActual)=NULL;
                }
                SimFicheros.DtaActual=dtap;
                memset(SimFicheros.DtaActual,0,44);
        }
        DOSerr=0;
        return;
}

int
dos_dfspace(int dno,int *dfdata)
{
        /* Returns (short sectorspercluster,freeclustercount,bytespersector,totalclusterindrive) of drive dno (dno: 0=current,1=A,2=B) into dfdata (to calculate freespace: (long)dfdata[1]*(long)dfdata[0]*(long)dfdata[2]))[int 21,36] */
        printf("dos_dfspace(): STUB\n");
        DOSerr=0;
        return(0);
}

void
dos_gettdrive(int drv,void *drvp)
{
        /* Returns info about driver drv in drvp (short sectorspercluster, bytespersector, cluster per drive; long FAT ID) [int 21,1c] */
        printf("dos_gettdrive(): STUB\n");
        DOSerr=0;
        return;
}

void
dos_getcdrive(void *drvp)
{
        /* Issues a dos_gettdrive() on the current drive returning the info about the drive in drvp [int 21,1b] */
        printf("dos_getcdrive(): STUB\n");
        DOSerr=0;
        return;
}


#endif
