/*
 * teclado.h
 *
 * Funciones auxiliares para manejar el teclado (y crear uno virtual)
 *
 * Historia:
 *      15/02/01 Pongo todo lo que es del teclado virtual aqu.
 *      22/02/01 Cambio el panel numrico y pongo un panel de "calculadora".
 *       9/06/01 Corrijo un bug en TecladoInit, que la condicin del while
 *               pona i-- en vez de --i, con lo que se haca vlida para i==-1
 *               e inicializaba mal Teclado->Actual.
 *      23/10/01 Hago que use el espacio de bffer de __Pantalla[] para
 *               cachear el dibujo del panel actual del teclado virtual para
 *               la profundidad inicial.
 *
 * Autor: Dario Rodriguez dario@softhome.net
 * This program is licensed under the terms of the GNU LGPL
 */


#ifndef TECLADO_H
#define TECLADO_H

/* Ficheros de cabecera */

#include "tinyfont.h"
#include "posiciones.h"

/* Definicin de constantes */

#define TECLA_FILER 0x1
#define TECLA_MENU  0x2
#define TECLA_EL    0x4
#define TECLA_ENTER 0x8
#define TECLA_IZQ 0x10
#define TECLA_ARR 0x20
#define TECLA_DER 0x40
#define TECLA_ABJ 0x80

#define NUMPANELES sizeof(__ListaPaneles)
#define PANEL_ALFA 1
#define PANEL_SYM  2
#define PANEL_NUM  4
#define PANEL_CALC 8
#define PANEL_TODOS (PANEL_ALFA|PANEL_SYM|PANEL_NUM|PANEL_CALC)

#define TECLADO_BORRAR  8
#define TECLADO_ENTER  13

/* Definicin de estructuras y datos globales */

static char __Pantalla[8*102+4];
static char *__PantallaPanelPtr=NULL;

static char __ListaPaneles[]={PANEL_ALFA,PANEL_SYM,PANEL_NUM,PANEL_CALC};

typedef struct TipoTeclado {
        int MascaraPaneles;
        int NumPanel;
        int Actual[NUMPANELES];
} sTeclado;

struct {
        int Mascara;
        char *Opciones;
        int Prof;
} __Paneles[]={
        {PANEL_ALFA,"ABCDEFGHIJKLMNOPQRSTUVWXYZ   ^_<   ",2},
        {PANEL_ALFA,"abcdefghijklmnopqrstuvwxyz   ^_<   ",2},
        {PANEL_SYM,":;_=/#$ܪ\"%[\\]{@}___   ^\254<   ",2},
        {PANEL_SYM,".,-+*&|!?`'<^>(~)___   ^\254<   ",2},
        {PANEL_NUM, "1234567890.<",1},
        {PANEL_CALC,"[*](+){/}=-<",1},
        {0,(char *)0,0}};

/* Prototipos de funciones: funciones pblicas */

int EsperaTecla(int Repeat);
void TecladoInit(sTeclado *Teclado, int MascaraPaneles, int PanelInicial);
int TecladoLee(sTeclado *Teclado);

/* Prototipos de funciones: funciones privadas (auxiliares de las anteriores) */

int ProcesaPantalla(int Guardar);
int LeeLetra(char *Opciones, int ProfIni);
void PintaOpciones(char *Opciones, int Tipo, int Desp, int NumOpcionesOmitir);

/* Cuerpos de funciones */

int
EsperaTecla(int Repeat)
{
        int tecla,res;
        tecla=Keyin(Repeat,-1);
        if((res=EventCall(tecla))==-1 ||
            (res==1 && ProcesaPantalla(1) &&
            EventExec()==-1 && ProcesaPantalla(0))) {
                cls(4);
                gv_kput(0,0,"Saliendo...",0,0,COPY_PUT);
                dos_exit(0);
        } else if(res==1)
                ProcesaPantalla(0);
        return(tecla);
}

int
ProcesaPantalla(int Guardar)
{
        if(Guardar) {
                __PantallaPanelPtr=NULL;
                gv_get(0,0,101,63,__Pantalla);
        } else
                gv_put(0,0,__Pantalla,COPY_PUT);
        return(1);
}

int
DirTecla(int c)
{
        int i;
        static char Teclas[4]={TECLA_IZQ,TECLA_ARR,TECLA_DER,TECLA_ABJ};
        for(i=0;i<4;i++) {
                if((c&Teclas[i]))
                        return(i);
        }
        return(-1);
}

int
Mascara2Panel(int Mascara)
{
        int i;
        for(i=0;i<sizeof(__ListaPaneles);i++) {
                if(Mascara & __ListaPaneles[i])
                        return(i);
        }
        return(0);
}

void
TecladoInit(sTeclado *Teclado, int MascaraPaneles, int PanelInicial)
{
        int i;
        Teclado->MascaraPaneles=(((MascaraPaneles&PANEL_TODOS)==0)? PANEL_TODOS:MascaraPaneles);
        Teclado->NumPanel=Mascara2Panel((PanelInicial&MascaraPaneles)==0? MascaraPaneles:PanelInicial);
        /* Como *MAXIMO* hay dos posiciones por panel y queremos la primera; */
        /* Nos ponemos al final de los paneles y los recorremos hacia atrs */
        for(i=0;__Paneles[i].Mascara!=0;i++)
                ;
        while((--i)>=0)
                Teclado->Actual[Mascara2Panel(__Paneles[i].Mascara)]=i;
}

int
TecladoLee(sTeclado *Teclado)
{
        int i,n;
        while(1) {
                i=Teclado->Actual[Teclado->NumPanel];
                n=LeeLetra(__Paneles[i].Opciones,__Paneles[i].Prof);
                if(n==(TECLA_MENU<<8)) {
                        do {
                                Teclado->NumPanel++,Teclado->NumPanel%= sizeof(__ListaPaneles);
                        } while((__ListaPaneles[Teclado->NumPanel] & Teclado->MascaraPaneles)==0);
                        continue;
                }
                if((n & 0xff00)!=0)
                        return(n);
                if((__Paneles[i].Prof==2 && n==(9*4-4)) ||
                   (__Paneles[i].Prof==1 && n==(3*4-1))) {
                        return(TECLADO_BORRAR);
                } else if((__Paneles[i].Prof==2 && n==(9*4-5)) ||
                   (__Paneles[i].Prof==1 && n==(3*4-2))) {
                        if((__Paneles[i].Opciones)[n]=='_')
                                return(' ');
                        else if((__Paneles[i].Opciones)[n]=='\254')
                                return(TECLADO_ENTER);
                        else
                                return((__Paneles[i].Opciones)[n]);
                } else if(((__Paneles[i].Prof==2 && n==(9*4-6)) ||
                   (__Paneles[i].Prof==1 && n==(3*4-3))) &&
                   (__Paneles[i].Opciones)[n]=='^') {
                        if(__Paneles[i+1].Mascara==__Paneles[i].Mascara)
                                Teclado->Actual[Teclado->NumPanel]++;
                        else
                                Teclado->Actual[Teclado->NumPanel]--;
                        continue;
                }
                return((__Paneles[i].Opciones)[n]);
        }
}



int
LeeLetra(char *Opciones, int ProfIni)
{
        static int PosProf[3]={1,3,9};
        int Cuadrante;
        int Dir;
        int Tecla;
        int Pos;
        int Prof;
        int HayRetorno;
        int CuadranteAnt[3];
        int PosAnt[3];
        int Saltado;
        for(Prof=ProfIni,Pos=0,Cuadrante=0,Saltado=0;Prof>=0;) {
                /* Pinta las opciones */
                HayRetorno=((Prof<ProfIni)?1:0);
                if(Prof==ProfIni) {
                        if(__PantallaPanelPtr!=Opciones) {
                                __PantallaPanelPtr=Opciones;
                                PintaOpciones(Opciones+Pos,Prof,Cuadrante,HayRetorno);
                                gv_get(0,32,101,63,__Pantalla);
                        } else
                                gv_put(0,32,__Pantalla,COPY_PUT);
                } else
                        PintaOpciones(Opciones+Pos,Prof,Cuadrante,HayRetorno);
                /* Espera una tecla */
                do {
                        Tecla=(EsperaTecla(0) & 0xff);
                } while(Tecla==0);
                /* Transformo la tecla en una posicin */
                if((Dir=DirTecla(Tecla))==-1)
                        return(Tecla<<8);
                /* Compruebo si hay que retoceder */
                if(HayRetorno && Dir==((Cuadrante+3)%4)) {
                        Prof++;
                        Prof+=Saltado;
                        Cuadrante=CuadranteAnt[Prof];
                      Pos=PosAnt[Prof];
                        continue;
                }
                /* Guardo las posiciones y cuadrantes */
                CuadranteAnt[Prof]=Cuadrante;
                PosAnt[Prof]=Pos;
                /* Prxima posicin de las letras */
                Pos+=((4+Dir-Cuadrante)%4)*PosProf[Prof];
                Cuadrante=(Dir+3)%4;
                Prof--;
                /* Caso particular: en Prof==2 hacia abajo se salta un nivel */
                if(Prof==1 && Pos==(9*3)) {
                        Cuadrante=2;
                        Pos+=PosProf[1];
                        Prof--;
                        Saltado=1;
                } else
                        Saltado=0;
        }
        return(Pos);
}

void
PintaOpciones(char *Opciones, int Tipo, int Desp, int NumOpcionesOmitir)
{
        static SQUARE_DRAW Cuadrado={{0,32,101,63},COPY_PUT,0xff};
        static struct {
                char *Pos[4];
                int Lim;
        } Datos[3] = {
         {{posiciones1,posiciones1+2,posiciones1+4,posiciones1+6},1},
         {{posiciones3,posiciones3+2*3,posiciones3+4*3,posiciones3+6*3},3},
         {{posiciones9,posiciones9+2*9,posiciones9+4*9,posiciones9+6*9},9}};
        int i;
        char *Pos;
        int Lim,Lim2;
        pv_clear(&(Cuadrado.rect));
        pv_square(&Cuadrado);
        Lim2=4-NumOpcionesOmitir;
        for(i=0;i<Lim2;i++) {
                Pos=Datos[Tipo].Pos[((Desp+i)%4)];
                Lim=Datos[Tipo].Lim;
                while(Lim--)
                        PonLetraPeq(*Pos++,*Pos++,*Opciones++);
        }
}

#endif
