/*
 * teclado.c
 *
 *  Pequeo editor de textos para el onhand/ruputer. Usa teclado.h para
 * el sistema de insertar.
 *
 * Historia:
 *       6/06/01 Empiezo a implementar el programa teclado. Empiezo con la
 *               definicin de los nmeros pequeos... terminada.
 *       7/06/01 Hago la definicin de los nmeros hexadecimales enanos (para
 *               el modo hexadecimal).
 *       1/09/01 Defino las estructuras sMemoria y sBloque. Hago MemoriaInit(),
 *               MemoriaLibera(), y MemoriaDato().
 *       2/09/01 Empiezo MemoriaInserta(). Corrijo un error en MemoriaInit(),
 *               que no inicalizaba bien NumBloques. Paso la parte de moverse
 *               de MemoriaDato() a MemoriaBuscaPos() y hago que tambin
 *               reconozca el final del bffer, que es lo que necesito para
 *               MemoriaInserta(). Hago la parte de empaquetar el bffer antes
 *               del punto de insercin para obtener espacio suficiente.
 *       3/09/01 Contino con MemoriaInserta(). a est terminada. Me pongo a
 *               depurarla. MemoriaBuscaPos() funciona bien. MemoriaInserta()
 *               falla en la parte de comprimir el texto del principio pero
 *               funciona el comprimir el del final y el rellenar. Corrijo
 *               un error en muevemem(). Empiezo a depurar MemoriaInserta().
 *       4/09/01 Termino de depurar MemoriaInserta(). Ya funciona como debiera.
 *               Hago MemoriaBorra(). Contino depurando poniendo nuevas
 *               condiciones. Hay un error en MemoriaBuscaPos() que sale cuando
 *               hay bloques vacios antes de la pos pedida.
 *      27/09/01 Corrijo el bug de MemoriaBuscaPos(), por el que si se peda la
 *               ltima posicin posible buscando hacia adelante devolva
 *               errneamente el bloque anterior al que deba devolver. Corrijo
 *               un bug en MemoriaInserta() por el que no mova bien los datos
 *               al agrupar espacio detrs (por espacio insuficiente detrs).
 *               De paso pongo bonita la funcin de MemoriaVuelca() y arreglo
 *               las llamadas a ella para que usen el nuevo formato y sea ms
 *               fcil ver el proceso de la funcin. Parece que todo lo que
 *               llevo hasta ahora funciona bien :-).
 *      29/09/01 Empiezo con el interfaz de editor. Hago LineaEstado().
 *      30/09/01 Hago PintaPantalla(). Empiezo Editor().
 *       1/10/01 Corrijo PintaPantalla(), ya que al compilar para el mn10200 no
 *               coga bien los parmetros de la macro PonLetraPeq(). Cambio
 *               PonLetraPeq() por la escritura en un bffer intermedio, para
 *               que la velocidad de hacer un pantallazo sea razonable como
 *               para hacer uno por cada letra que se inserte/borre. Hago que
 *               calcule el nmero de carcteres suplidos para una lnea dada
 *               (los que le faltan para llegar a la columna deseada). Hago el
 *               movimiento der/izq y el movimiento abajo (falta poner bien la
 *               condicin de fin de posibilidad de mover hacia abajo).
 *       4/10/01 Hago el movimiento hacia arriba (falta corregir el que la
 *               posicin dentro de la primera lnea si hay carcteres
 *               supletorios no est bien calculada). Corrijo la condicin de
 *               fin del movimiento hacia abajo.
 *       5/10/01 Hay un bug con las lneas partidas. Para corregirlo implemento
 *               LineaReal y ColumnaReal... (antes Linea Se comportaba como
 *               LineaReal, con lo que la rutina de movimiento se haca un lo
 *               cuando haba scroll con "lneaslargas"). Dejo la conversin a
 *               mitad de hacer...
 *      20/10/01 Reescribo CalculaLineaAnterior(). Con esto ya hace bien el
 *               scroll hacia arriba y hacia abajo. Corrijo un bug en
 *               PintaPantalla() por el que la longitud de las lneas cuando
 *               "Columna!=0" poda contar ms de MAXLINEA. Empiezo con lo de
 *               desplazar la parte visible para que sea el cursos aunque est
 *               en las ltimas lneas estando en modo insercin.
 *      21/10/01 Termino lo de la visibilidad cuando se est en modo insercin.
 *               Empiezo el que pueda insertar carcteres. Hago que cuando est
 *               insertando no pinte la lnea de estado. Hago que cuando llega
 *               al final de una lineaLarga, pase al principio de la siguiente y
 *               viceversa. Implemento la funcionalidad de insertar. Hay un bug
 *               en muevemem() por el cual no mueve bien los datos al borrar
 *               un carcter en MemoriaBorra() si es el primero de un bloque
 *               lleno. Corrijo un bug en MemoriaInserta() por el cual si el
 *               texto a insertar caba en el bloque actual, no actualizaba
 *               UltimoFinBloque. Falta que sea capaz de borrar los fin de
 *               lnea.
 *      22/10/01 Corrijo un bug en MemoriaInserta() por el que si caba el texto
 *               en el bloque actual, slo mova un nmero de bytes igual al
 *               tamao del texto a insertar, no a los ocupados posteriores a
 *               MiPos. Hago que el nmero de lneas que dibuja PintaPantalla()
 *               sea un parmetro para evitar parpadeos en el rea de ayuda del
 *               "teclado".
 *      23/10/01 Corrijo un bug por el cual MemoriaInserta() no trasladaba bien
 *               los datos si se estaba insertando a mitad de un bloque lleno,
 *               dando como efecto que se insertaba al principio del bloque el
 *               mismo contenido que el principio del bloque, lo cual resultaba
 *               asombroso O:-). Hago en el switch de proceso del cursor un
 *               caso "default" que ponga n a cero, lo cual arregla el bug de
 *               que se bloqueaba al pulsar la tecla MENU (entraba en un bucle
 *               infinito).
 *      24/10/01 Reno todos los datos concernientes a la posicin del cursor
 *               dentro de Editor en una estructura (sPosicion). Paso a una
 *               funcin independiente llamada ProcesaTecla() el cdigo
 *               correspondiente de procesado del movimiento por cursores y
 *               de paso intento simplificarlo un poco. Empiezo a poner en
 *               uso (sPosicion).LinMostradas
 *      25/10/01 Termino de poner en uso (sPosicion).LinMostradas. Hago que se
 *               use en la parte de teclado la funcin ProcesaTecla() en vez de
 *               pasar teclas al bucle de cursores. Hago que ProcesaTecla()
 *               tenga includo el bucle de procesado de teclas que requieren
 *               ms de una accin. Corrijo un bug; que no actualizaba
 *               Info[..DespCursor] cuando haca un desplazamieto de lneas,
 *               con lo que si insertabas em la lnea del final del documento,
 *               no se iba a una lnea ms abajo cuando el cursor se "iba" de
 *               la lnea actual. Arreglo el que al insertar el ltimo carcter
 *               de la lnea acabe detrs del siguiente que se escribe
 *               (simplemente: si estamos insertando al final de una lnea,
 *               al entrar en modo insercin mete un espacio detrs del cursor,
 *               y cuando salimos de l lo quita). Hago que pueda borrar el
 *               carcter de fin de lnea. Con esto creo que ya tiene la
 *               funcionalidad bsica de edicin, y me puedo poner con los
 *               mens.
 *      26/10/01 He probado en otro programa los NumHexa y cambio un poco el
 *               aspecto del ocho, ya que era confuso.
 *       7/11/01 Empiezo a integrar el dilogo de "salvar como..." y los mens.
 *               Ya los usa para la funcin de salir y llama a los FileSel(),
 *               pero no est hecha todava la lgica de cargar/salvar/etc.
 *       8/11/01 Empiezo con el acceso a ficheros; empiezo MemoriaInsertaFich()
 *               y pongo el prototipo de MemoriaVuelcaFich().
 *       9/11/01 Termino MemoriaInsertaFich() y hago MemoriaVuelcaFich().
 *               Hago la macro MemoriaOcupados(). Hago la parte de salvar/cargar
 *               y la de nuevo, pero falta lo de avisar al usuario si hay
 *               errores (y adems no detecta que el fichero es demasiado
 *               grande, lo cual podra hacer intentando leer un byte ms del
 *               fichero; si lo lee, es que es ms grande, y podra preguntar
 *               si descarta el primer trozo y carga el segundo o qu).
 *       1/12/01 Hay un error que sale al insertar al final del prrafo primero
 *               de "Erase una [...]garcito.", hacindose que el punto quede
 *               "como" duplicado.
 *       2/12/01 Pongo ms trazas y hago una forma de activar las trazas del
 *               motor de edicin sin que use las pruebas del motor; activando
 *               tanto PRUEBAS_ACTIVADAS como PRUEBAS_REALES).Vale. Simplemente
 *               ha insertado mal :-/. Arreglado el bug de insercin (Resulta
 *               que al mover para hacer espacio detrs mova ms de la cuenta
 *               (por eso de hacer todo el espacio posible)... ahora comprueba
 *               si se va a pasar de mover, y en su caso corrije la cantidad
 *               de datos a mover). Arreglo el cargar/salvar fichero. Hago que
 *               use la funcin DialogBox() para avisar al usuario de todo lo
 *               que pase que le pueda afectar. Hago el dilogo de "Acerca de".
 *               Slo falta el arregar el bug de lnea de tamao igual a
 *               la pantalla cuando se hace scroll hacia arriba :-).
 *       3/12/01 Arreglo el error de que no reinicializaba Info[] al hacer
 *               menuNuevo o menuCargar. Corrijo el bug de scroll con lneas de
 *               tamao MAXLINEA (en CalculaLineaAnterior() haba una condicin
 *               de >=MAXLINEA mientras que deba ser >MAXLINEA). Modifico
 *               MemoriaInsertaFich() para que tenga un parmetro ms que
 *               indique al retornar si se ha podido cargar el fichero completo
 *               o no y hago que menuCargar lo compruebe y en su caso ponga
 *               un mensaje de aviso.
 *       4/12/01 Traslado lo de hacer espacio desde MemoriaInserta() a una
 *               funcin independiente denominada MemoriaReserva(). Hago lo de
 *               que el cursor parpadee. Implemento "de mala manera" lo de
 *               marcar.
 *       5/12/01 Arreglo lo de "Marcar". Implemento lo de "Cortar". Empiezo a
 *               implementar IrAPos(). Pongo los mens de "Ir" y de "Modo", as
 *               como la opcin de buscar (aunque de estos aadidos el nico
 *               que funciona es el de ir a inicio). Hago CalculaPantalla() a
 *               partir de PintaPantalla() (un poco de duplicidad de cdigo es
 *               inevitable si quiero evitar poner muchos "if"s dentro de los
 *               bucles. Termino IrAPos(). Arreglo un bug en PintaPatalla() y
 *               en CalculaPantalla() por el cual no inicializaba Suplidos si
 *               la columna era 0. Ya funciona lo de IrAPos() y con ello
 *               tambin menuIrFinal... con esto ya puedo empezar a implementar
 *               "Buscar" (y que no se me olvide hacer "Copiar", que para eso
 *               prepar MemoriaReserva()).
 *       9/10/01 Arreglo un bug que no s cuando introduje; al escribir enter
 *               en el teclado virtual (TECLADO_ENTER) no haca el TECLA_ABJ
 *               para ponerse en la siguiente lnea. Lo siguiente debera ser
 *               pasar la parte de mens a una funcin independiente para poder
 *               implementar la caracterstica de carga directa de un nombre
 *               de archivo.
 *      24/12/01 Reorganizo los mens un poco (slo los que todava no estn
 *               activados).
 *      25/12/01 Pongo en los elementos terminadores de las estructuras de los
 *               mens el nmero de la primera opcin de dicho men (tal y como
 *               espera ahora la librera de mens para permitir subsubmens).
 *               Me pongo con lo de que funcionen las asociaciones de ficheros
 *               (rupsys.h:getArg()). Asume que si termina en .EXF no es por
 *               asociacin, mientras que si termina en cualquier otra cosa
 *               es el nombre del fichero a cargar. Quito el que ponga un texto
 *               por defecto (Quizs debera poner ah el (c)?).
 *      30/12/01 Comprobado que funciona el cargar por asociacin :-). Arreglo
 *               el que ahora no se puede hace un sizeof(NombreFich) en Editor()
 *               debido a que es un puntero en vez de una matriz (el tamao
 *               ahora est definido en la macro TAMNOMBREFICH). Hay un error
 *               por el cual si el contenido de la memoria termina en "\n", no
 *               funciona el "IraPos(FINAL)".
 *      31/12/01 Finalmente pongo las opciones de convertir en el men de "Modo"
 *               y me pongo a implementar la funcionalidad de copiar y de mover.
 *               Hecho copiar/mover. Les sucede algo parcedido a IraPos(FINAL),
 *               no copian/mueven si resulta que lo queremos hacer al final
 *               del fichero.
 *
 * Autor: Dario Rodriguez dario@softhome.net
 * (L) Copyleft 2001 Dario Rodriguez (Antartica) dario@softhome.net
 * This program is licensed under the terms of the GNU GPL.
 */

/* #define NO_SIGALRM */

/*  #define SPANISH */

#include <lcdbios.h>
#include <rupsys.h>
#include <wbios.h>
#include <ruptool.h>
#include <psdos.h>
#include "tinyfont.h"
#include "teclado.h"
#include "filesel.c"
#include "menus.c"

#define TAMNOMBREFICH 128

/*
#ifdef LINUX
#define PRUEBAS_ACTIVADAS
#define PRUEBAS_REALES
#endif
*/

/* Definicin de grficos */
static char NumEstado[10][8]={
        {4,0,4,0,6,9,9,6},     /* 0 */
        {4,0,4,0,0,2,15,0},    /* 1 */
        {4,0,4,0,9,13,13,10},  /* 2 */
        {4,0,4,0,9,11,15,5},   /* 3 */
        {4,0,4,0,4,6,5,12},    /* 4 */
        {4,0,4,0,11,11,11,5},  /* 5 */
        {4,0,4,0,6,11,11,5},   /* 6 */
        {4,0,4,0,1,9,5,3},     /* 7 */
        {4,0,4,0,13,15,15,13}, /* 8 */
        {4,0,4,0,10,13,13,6},  /* 9 */
};

static char SepEstado[8]={4,0,4,0,0,10,0,0}; /* : */

static char CarExtra[2][6]={
        {2,0,6,0,0,0}, /*   */
        {2,0,6,0,5,2}, /* > */
};

static char NumHexa[16][6]={
        {2,0,5,0,14,14}, /* 0 */
        {2,0,5,0,2,31},  /* 1 */
        {2,0,5,0,25,22}, /* 2 */
        {2,0,5,0,21,31}, /* 3 */
        {2,0,5,0,7,28},  /* 4 */
        {2,0,5,0,23,29}, /* 5 */
        {2,0,5,0,31,28}, /* 6 */
        {2,0,5,0,1,31},  /* 7 */
        {2,0,5,0,29,29}, /* 8 */
        {2,0,5,0,7,31},  /* 9 */
        {2,0,5,0,26,28}, /* A */
        {2,0,5,0,31,10}, /* B */
        {2,0,5,0,14,17}, /* C */
        {2,0,5,0,31,14}, /* D */
        {2,0,5,0,31,21}, /* E */
        {2,0,5,0,31,5},  /* F */
};

#define PonNumEstado(x,y,Num) gv_put(x,y,&(NumEstado[Num][0]),COPY_PUT)
#define PonSepEstado(x,y) gv_put(x,y,SepEstado,COPY_PUT)
#define PonCarExtra(x,y,Bandera) gv_put(x,y,&(CarExtra[Bandera][0]),COPY_PUT)
#define PonNumHexa(x,y,Num) gv_put(x,y,&(NumHexa[Num][0]),COPY_PUT)
#define ESPERA(Tecla) while((EsperaTecla(0)&0xff)!=Tecla)


typedef enum TipoPosEncontrada { posLetra=0,
                                 posFin,
                                 posNoEncontrada=-1} ePosEncontrada;

typedef struct TipoBloque {
        unsigned short Ocupados;
        char *Ptr;
} sBloque;

typedef struct TipoMemoria {
        unsigned long TamBuffer;
        char *Buffer;
        unsigned short NumBloques;
        unsigned short TamBloque;
        sBloque *Bloque;
        unsigned long TotalOcupados;
        unsigned short UltimoBloque;
        unsigned long UltimoIniBloque;
        unsigned long UltimoFinBloque;
} sMemoria;

/* Prototipos de funciones del motor de edicin */

void MemoriaInit(sMemoria *Mem);
void MemoriaLibera(sMemoria *Mem);
ePosEncontrada MemoriaBuscaPos(sMemoria *Mem,unsigned long Pos);
char *MemoriaDato(sMemoria *Mem,unsigned long Pos);
void muevemem(char *Dest, char *Orig, int Cantidad);
void copiamem(char *Dest, char *Orig, int Cantidad);
void inicializamem(char *Dest, char c, int n);
unsigned long MemoriaInserta(sMemoria *Mem,unsigned long Pos,char *Texto,unsigned long TamTexto);
unsigned long MemoriaReserva(sMemoria *Mem,unsigned long Pos,unsigned long TamHueco);
unsigned long MemoriaBorra(sMemoria *Mem, unsigned long Pos, unsigned long Tam);
unsigned long MemoriaInsertaFich(sMemoria *Mem, unsigned long Pos, int Fich, unsigned long TamDatos,unsigned char *ResFichDemasiadoGrande);
unsigned long MemoriaVuelcaFich(sMemoria *Mem, unsigned long Pos, int Fich, unsigned long TamDatos);
#define MemoriaOcupados(Mem) ((Mem)->TotalOcupados)
unsigned long MemoriaCopiaMueve(sMemoria *Mem,unsigned long PosDest, unsigned long PosOrig, unsigned long TamTexto,char BanderaMover);
#define MemoriaCopia(Mem,PosDest,PosOrig,TamDatos) MemoriaCopiaMueve(Mem,PosDest,PosOrig,TamDatos,0)
#define MemoriaMueve(Mem,PosDest,PosOrig,TamDatos) MemoriaCopiaMueve(Mem,PosDest,PosOrig,TamDatos,1)

/* Prototipos de funciones del front-end de edicin */

int CargaFichero(sMemoria *Mem,char *NombreFich);
void Editor(sMemoria *Mem, sTeclado *Teclado,char *NombreFich);
void LineaEstado(int Linea, int Columna,int Pagina);

/* Punto de entrada del prograna */
int
main(void)
{
        sTeclado Teclado;
        sMemoria Mem;
        char NombreFich[TAMNOMBREFICH];
        /* Preparamos el entorno */
        screen(1);
        cls(4);
        TinyfontInit();
        TecladoInit(&Teclado,PANEL_ALFA|PANEL_SYM|PANEL_NUM,PANEL_ALFA);
        MemoriaInit(&Mem);
        NombreFich[0]='\0';
#if defined(PRUEBAS_ACTIVADAS) && !defined(PRUEBAS_REALES)
        MemoriaInserta(&Mem,0,"Hola Amigos!",13);
        MemoriaInserta(&Mem,5,",",1);
        MemoriaInserta(&Mem,13," MIOS",5);
        MemoriaBorra(&Mem,1,17);
        MemoriaInserta(&Mem,2," Me dije asombrado.",19);
#endif
        /* Comprobamos si tenemos que cargar un fichero antes de empezar */
        if(getArg()!=NULL){
                char *Ptr,*PtrPunto;
                for(Ptr=getArg(),PtrPunto=NULL;*Ptr!='\0';Ptr++) {
                        if(*Ptr=='.')
                                PtrPunto=Ptr;
                }
                if(PtrPunto==NULL || !(PtrPunto[1]=='E' && PtrPunto[2]=='X' && PtrPunto[3]=='F')) {
                        fs_copiacad(NombreFich,getArg(),TAMNOMBREFICH);
                        if(CargaFichero(&Mem,NombreFich)!=0)
                                NombreFich[0]='\0';
                }
        }
        /* Bucle infinito por si no quiere salir */
        do {
                /* Arrancamos el editor */
                Editor(&Mem,&Teclado,NombreFich);
                /* Limpieza y salida */
                gv_clear(4*2,64/2-5,100-4*2,64/2+1);
#ifdef SPANISH
                PonCadPeq(1+4*2,64/2-4,"Pulse MENU para salir");
#else
                PonCadPeq(1+4*2+2*3,64/2-4,"Press MENU to exit");
#endif
                gv_square(4*2-1,64/2-6,101-4*2,64/2+2,COPY_PUT,0xffffffff);
        } while((EsperaTecla(0)&0xff)!=TECLA_MENU);
        MemoriaLibera(&Mem);
        return(0);
}

/* Funciones para el manejo de las estructuras de memoria (motor de edicin) */
#if !defined(PRUEBAS_ACTIVADAS) || defined(PRUEBAS_REALES)
static char MemoriaBuffer[16*1024];
#define TAMBLOQUE 256
#else
static char MemoriaBuffer[5*12];
#define TAMBLOQUE 4
#endif

void
MemoriaInit(sMemoria *Mem)
{
        int i;
        for(i=0;i<sizeof(sMemoria);i+=2)
                *((short *)(((char *)Mem)+i))=0;
        Mem->TamBuffer=sizeof(MemoriaBuffer);
        Mem->Buffer=MemoriaBuffer;
        Mem->TamBloque=TAMBLOQUE;
        Mem->NumBloques=Mem->TamBuffer/(Mem->TamBloque+sizeof(sBloque));
        Mem->Bloque=((sBloque *) (Mem->Buffer+Mem->TamBuffer))-Mem->NumBloques;
        for(i=0;i<Mem->NumBloques;i++) {
                Mem->Bloque[i].Ocupados=0;
                Mem->Bloque[i].Ptr=Mem->Buffer+(Mem->TamBloque)*i;
        }
        Mem->TotalOcupados=0;
        Mem->UltimoBloque=0;
        Mem->UltimoIniBloque=0;
        Mem->UltimoFinBloque=0;
}

void
MemoriaLibera(sMemoria *Mem)
{
        int i;
        for(i=0;i<sizeof(sMemoria);i+=2)
                *((short *)(((char *)Mem)+i))=0;
}

#ifdef PRUEBAS_ACTIVADAS
#include <stdio.h>
#include <stdarg.h>
void
MemoriaVuelca(sMemoria *Mem, char *Formato, ...)
{
        char Letra;
        unsigned long Bloque,i;
        printf("\r");
        for(Bloque=0;Bloque<Mem->NumBloques;Bloque++) {
                printf("[%lu]",Mem->Bloque[Bloque].Ocupados);
                fflush(stdout);
                for(i=0;i<Mem->Bloque[Bloque].Ocupados;i++)
                        printf("%c", (((Letra=Mem->Bloque[Bloque ].Ptr[i])=='\n')?'$':Letra));
#ifndef PRUEBAS_REALES
                for(;i<Mem->TamBloque;i++) {
                        printf("#");
                        Mem->Bloque[Bloque].Ptr[i]='_';
                }
#endif
        }
        printf( " Ult=%lu[%lu:%lu],Tot=%lu ", (unsigned long) Mem->UltimoBloque,(unsigned long) Mem->UltimoIniBloque,(unsigned long) Mem->UltimoFinBloque,(unsigned long) Mem->TotalOcupados);
        if(Formato!=NULL) {
                va_list lista;
                va_start(lista,Formato);
                vprintf(Formato,lista);
                va_end(lista);
        }
        printf("\n");
        fflush(stdout);
}
#endif


ePosEncontrada
MemoriaBuscaPos(sMemoria *Mem, unsigned long Pos)
{
        long i;
        unsigned short l;
        unsigned long n;
        if(Pos>=Mem->UltimoIniBloque && Pos<Mem->UltimoFinBloque)
                return(posLetra);
        if(Pos>Mem->TotalOcupados)
                return(posNoEncontrada);
        if(Pos<Mem->UltimoIniBloque) {
                /* Buscamos hacia atrs */
                for(i=Mem->UltimoBloque-1,n=Mem->UltimoIniBloque;i>=0;i--) {
                        n-=Mem->Bloque[i].Ocupados;
                        if(Pos>=n) {
                                Mem->UltimoBloque=i;
                                Mem->UltimoIniBloque=n;
                                Mem->UltimoFinBloque=n+Mem->Bloque[i].Ocupados;
                                return(posLetra);
                        }
                }
        } else {
                if(Pos==Mem->TotalOcupados && Pos==Mem->UltimoFinBloque) {
                        if((Mem->UltimoBloque+1)<Mem->NumBloques && Mem->Bloque[Mem->UltimoBloque].Ocupados==Mem->TamBloque) {
                                Mem->UltimoBloque++;
                                Mem->UltimoIniBloque=Mem->UltimoFinBloque;
                        }
                        return(posFin);
                }
                /* Buscamos hacia adelante */
                for(l=Mem->NumBloques, i=Mem->UltimoBloque+1, n=Mem->UltimoFinBloque; i<l; i++) {
                        n+=Mem->Bloque[i].Ocupados;
                        if(Pos<n) {
                                Mem->UltimoBloque=i;
                                Mem->UltimoIniBloque= n- Mem->Bloque[ i].Ocupados;
                                Mem->UltimoFinBloque=n;
                                return(posLetra);
                        }
                        if(n==Mem->TotalOcupados) {
                                i++;
                                break;
                        }
                }
                if(Pos==Mem->TotalOcupados && Pos==n) {
                        i--;
                        Mem->UltimoBloque=i;
                        Mem->UltimoIniBloque=n-Mem->Bloque[i].Ocupados;
                        Mem->UltimoFinBloque=n;
                        if((Mem->UltimoBloque+1)<Mem->NumBloques && Mem->Bloque[Mem->UltimoBloque].Ocupados==Mem->TamBloque) {
                                Mem->UltimoBloque++;
                                Mem->UltimoIniBloque=Mem->UltimoFinBloque;
                        }
                        return(posFin);
                }
        }
        return(posNoEncontrada);
}

char *
MemoriaDato(sMemoria *Mem,unsigned long Pos)
{
        if(Pos>=Mem->UltimoIniBloque && Pos<Mem->UltimoFinBloque) {
                return( Mem->Bloque[Mem->UltimoBloque].Ptr+ Pos-Mem->UltimoIniBloque);
        }
        if(MemoriaBuscaPos(Mem,Pos)==posLetra)
                return( Mem->Bloque[Mem->UltimoBloque].Ptr+ Pos-Mem->UltimoIniBloque);
        return(NULL);
}

void
muevemem(char *Dest, char *Orig, int Cantidad)
{
        int i;
        if(Dest==Orig)
                return;
        if(Orig<Dest && (Orig+Cantidad)>Dest) {
                for(Cantidad--;Cantidad>=0;Cantidad--)
                        Dest[Cantidad]=Orig[Cantidad];
        }
        for(i=0;i<Cantidad;i++)
                Dest[i]=Orig[i];
}

void
copiamem(char *Dest, char *Orig, int Cantidad)
{
        int i;
        for(i=0;i<Cantidad;i++)
                Dest[i]=Orig[i];
}

void
inicializamem(char *Dest, char c, int n)
{
        while(n--)
                Dest[n]=c;

}

unsigned long
MemoriaInserta(sMemoria *Mem,unsigned long Pos,char *Texto,unsigned long TamTexto)
{
        unsigned long Espacio,Hechos;
        Espacio=(Mem->NumBloques*Mem->TamBloque-Mem->TotalOcupados);
        if(TamTexto>Espacio)
                TamTexto=Espacio;
        /* Primero buscamos la posicin de insercin */
#ifdef PRUEBAS_ACTIVADAS
        printf("---MemoriaInserta(Mem,Pos=%lu,Texto=\"%s\",TamTexto=%lu)\n", (unsigned long) Pos,(char *) Texto,(unsigned long) TamTexto), fflush(stdout);
        MemoriaVuelca(Mem,"En el momento de llamada");
#endif
        if(MemoriaBuscaPos(Mem,Pos)==posNoEncontrada)
                return(0);
#ifdef PRUEBAS_ACTIVADAS
        MemoriaVuelca(Mem, "post-MemoriaBuscaPos(Mem,Pos=%lu)",Pos);
#endif
        /* Si cabe directamente en el bloque lo insertamos y salimos, si no, continuamos */
        if((Mem->TamBloque- Mem->Bloque[ Mem->UltimoBloque].Ocupados)>= TamTexto) {
                char *Ptr;
                short MiPos;
                Ptr=Mem->Bloque[Mem->UltimoBloque].Ptr;
                MiPos=Pos-Mem->UltimoIniBloque;
                muevemem(Ptr+MiPos+TamTexto,Ptr+MiPos, Mem->Bloque[Mem->UltimoBloque].Ocupados-MiPos);
                copiamem(Ptr+MiPos,Texto,TamTexto);
                Mem->Bloque[Mem->UltimoBloque].Ocupados+=TamTexto;
                Mem->UltimoFinBloque+=TamTexto;
                Mem->TotalOcupados+=TamTexto;
#ifdef PRUEBAS_ACTIVADAS
                MemoriaVuelca(Mem,"Despues de todo");
#endif
                return(TamTexto);
        }
        /* No cabe directamente, hacemos hueco para que quepa */
        TamTexto=MemoriaReserva(Mem,Pos,TamTexto);
        /* Copiamos el texto en el hueco que hemos hecho */
        {
                long i;
                unsigned long n;
                unsigned short MiPos;
                unsigned long NumVictimas,Faltan;
                char *Ptr;
                n=Mem->UltimoIniBloque;
                for( Hechos=0, Faltan=TamTexto, i=Mem->UltimoBloque, MiPos= Pos- Mem->UltimoIniBloque; Hechos< TamTexto; Hechos+= NumVictimas, Faltan-= NumVictimas, i++, MiPos=0) {
                        Ptr=Mem->Bloque[i].Ptr+MiPos;
                        NumVictimas=Mem->TamBloque-Mem->Bloque[i].Ocupados;
                        if(NumVictimas>Faltan)
                                NumVictimas=Faltan;
                        muevemem( Ptr+ NumVictimas, Ptr, Mem->Bloque[ i].Ocupados- MiPos);
                        copiamem(Ptr,Texto+Hechos,NumVictimas);
                        Mem->Bloque[i].Ocupados+=NumVictimas;
                        Mem->TotalOcupados+=NumVictimas;
                        n+=Mem->Bloque[i].Ocupados;
#ifdef PRUEBAS_ACTIVADAS
                        MemoriaVuelca( Mem, "Copia:Hechos=%li,Faltan=%li,NumVictimas=%li,i=%li,MiPos=%li", (long) Hechos, (long) Faltan, (long) NumVictimas,(long) i, (long) MiPos);
#endif
                }
                i--;
                /* Dejamos el puntero en el ltimo bloque que tiene texto insertado */
                Mem->UltimoBloque=i;
                Mem->UltimoFinBloque=n;
                Mem->UltimoIniBloque=n-Mem->Bloque[i].Ocupados;
        }
        /* Limpiamos y salimos */
#ifdef PRUEBAS_ACTIVADAS
        MemoriaVuelca(Mem,"Despues de todo");
#endif
        return(Hechos);
}

unsigned long
MemoriaReserva(sMemoria *Mem,unsigned long Pos,unsigned long TamHueco)
{
        unsigned long Espacio,EspacioDelante,EspacioDetras;
        Espacio=(Mem->NumBloques*Mem->TamBloque-Mem->TotalOcupados);
        if(TamHueco>Espacio)
                TamHueco=Espacio;
        if(MemoriaBuscaPos(Mem,Pos)==posNoEncontrada)
                return(0);
        /* Contamos cuanto espacio hay delante y detrs */
        EspacioDelante= Mem->TamBloque* Mem->UltimoBloque- Mem->UltimoIniBloque;
        EspacioDetras=Espacio-EspacioDelante;
        /* Si detrs no hay suficiente espacio */
        if(EspacioDetras<TamHueco) {
                long i,j;
                unsigned long Trasladar, Vacios, Falta;
                char *Ptr;
                unsigned long NumAqui,PosAqui,HabiaAqui,NumVictimas;
                /* Vamos bloques hacia el ppio contando espacio */
                Falta=TamHueco-EspacioDetras;
                Trasladar=Vacios=0;
                /* - Para el bloque actual */
                Trasladar= (Pos- Mem->UltimoIniBloque);
                Vacios= 0;
                /* - Para los siguientes */
                for(i=Mem->UltimoBloque-1;Vacios<Falta;i--) {
                        Mem->UltimoIniBloque-=Mem->Bloque[i].Ocupados;
                        Vacios+=Mem->TamBloque-Mem->Bloque[i].Ocupados;
                        if(Vacios<Falta)
                                Trasladar+=Mem->Bloque[i].Ocupados;
                }
                i++;
                /* Movemos los datos */
#ifdef PRUEBAS_ACTIVADAS
                MemoriaVuelca( Mem, "Movemos los datos (Trasladar=%lu)", Trasladar);
#endif
                for(j=i+1;i<Mem->UltimoBloque && Trasladar>0;i++) {
                        if(i==j)
                                j++;
                        Ptr=Mem->Bloque[i].Ptr;
                        NumAqui=Mem->TamBloque-Mem->Bloque[i].Ocupados;
                        if(NumAqui>Trasladar)
                                NumAqui=Trasladar;
                        HabiaAqui=Mem->Bloque[i].Ocupados;
                        PosAqui=HabiaAqui;
                        Mem->Bloque[i].Ocupados+=NumAqui;
                        NumAqui+=PosAqui;
                        for(; PosAqui<NumAqui; PosAqui+=NumVictimas) {
                                NumVictimas=Mem->Bloque[j].Ocupados;
                                if(NumVictimas==0) {
                                        j++;
                                        continue;
                                }
                                if(NumVictimas>(NumAqui-PosAqui))
                                        NumVictimas=(NumAqui-PosAqui);
                                copiamem( Ptr+ PosAqui, Mem->Bloque[j].Ptr, NumVictimas);
                                Mem->Bloque[j].Ocupados-=NumVictimas;
                                muevemem( Mem->Bloque[ j].Ptr, Mem->Bloque[ j].Ptr+ NumVictimas,Mem->Bloque[j].Ocupados);
                        }
                        Mem->UltimoIniBloque+=Mem->Bloque[i].Ocupados;
                        Trasladar-=(PosAqui-HabiaAqui);
#ifdef PRUEBAS_ACTIVADAS
                        MemoriaVuelca( Mem, "Mover:PosAqui=%li,NumAqui=%li,Trasladar=%li", PosAqui, NumAqui, Trasladar);
#endif
                }
                Mem->UltimoBloque=i;
                Mem->UltimoFinBloque= Mem->UltimoIniBloque+ Mem->Bloque[ i].Ocupados;
                /* Nos ponemos al principio del espacio en blanco */
                /* - Para el bloque actual */
                if(Mem->UltimoIniBloque==Pos && i>0 && Mem->Bloque[Mem->UltimoBloque-1].Ocupados<Mem->TamBloque) {
                        Mem->UltimoBloque--;
                        Mem->UltimoFinBloque=Mem->UltimoIniBloque;
                        Mem->UltimoIniBloque-= Mem->Bloque[ Mem->UltimoBloque].Ocupados;
                        /* - Para el resto */
                        while(i>0 && Mem->Bloque[Mem->UltimoBloque].Ocupados==0 && Mem->Bloque[Mem->UltimoBloque-1].Ocupados<Mem->TamBloque) {
                                Mem->UltimoBloque--;
                                Mem->UltimoFinBloque=Mem->UltimoIniBloque;
                                Mem->UltimoIniBloque-= Mem->Bloque[ Mem->UltimoBloque].Ocupados;
                        }
                }
#ifdef PRUEBAS_ACTIVADAS
                MemoriaVuelca(Mem,"Despues del hueco anterior");
#endif
        }
        /* Nos aseguramos el hueco hacia adelante */
        if(( Mem->TamBloque- Mem->Bloque[ Mem->UltimoBloque].Ocupados)< TamHueco) {
                long i,j;
                unsigned long Trasladar, Vacios, Dejar;
                char *Ptr;
                unsigned long NumAqui,PosAqui,NumVictimas;
                /* Vamos bloques hacia el final contando espacio */
                Trasladar=Vacios=0;
                /* - Para el bloque actual */
                Dejar=(Pos- Mem->UltimoIniBloque);
                Trasladar= Mem->Bloque[ Mem->UltimoBloque].Ocupados- Dejar;
                Vacios= Mem->TamBloque- Mem->Bloque[ Mem->UltimoBloque].Ocupados;
                /* - Para los siguientes */
                for(i=Mem->UltimoBloque+1;Vacios<TamHueco;i++) {
                        Trasladar+=Mem->Bloque[i].Ocupados;
                        Vacios+=Mem->TamBloque-Mem->Bloque[i].Ocupados;
                }
                i--;
                /* Movemos los datos */
                for(j=i-1;i>Mem->UltimoBloque;i--) {
                        if(i==j)
                                j--;
                        Ptr=Mem->Bloque[i].Ptr;
                        NumAqui=Mem->TamBloque-Mem->Bloque[i].Ocupados;
                        if(NumAqui>Trasladar)
                                NumAqui=Trasladar;
                        if(j==Mem->UltimoBloque && Dejar>(Mem->Bloque[j].Ocupados-NumAqui)) {
                                NumAqui=Mem->Bloque[j].Ocupados-Dejar;
                        }
                        muevemem(Ptr+NumAqui,Ptr,Mem->Bloque[i].Ocupados);
                        Mem->Bloque[i].Ocupados+=NumAqui;
                        for(PosAqui=0;PosAqui<NumAqui;PosAqui+=NumVictimas) {
                                NumVictimas=Mem->Bloque[j].Ocupados;
                                if(NumVictimas==0) {
                                        j--;
                                        continue;
                                }
                                if(NumVictimas>(NumAqui-PosAqui))
                                        NumVictimas=(NumAqui-PosAqui);
                                copiamem( Ptr+ PosAqui, Mem->Bloque[j].Ptr+ Mem->Bloque[ j].Ocupados- NumVictimas, NumVictimas);
                                Mem->Bloque[j].Ocupados-=NumVictimas;
                                Trasladar-=NumVictimas;
#ifdef PRUEBAS_ACTIVADAS
                        MemoriaVuelca( Mem, "Mover:i=%li,j=%li,PosAqui=%li,NumAqui=%li,Dejar=%li", (long) i, (long) j, (long) PosAqui, (long) NumAqui, (long) Dejar);
#endif
                        }
                }
                /* (Ya tenemos el hueco servido, continuamos) */
#ifdef PRUEBAS_ACTIVADAS
                MemoriaVuelca(Mem,"Despues del hueco posterior");
#endif
        }
        return(TamHueco);
}


unsigned long
MemoriaBorra(sMemoria *Mem, unsigned long Pos, unsigned long Tam)
{
        long i;
        unsigned short MiPos;
        unsigned long NumVictimas,Hechos;
        if(MemoriaBuscaPos(Mem,Pos)!=posLetra)
                return(0);
        if(Tam>(Mem->TotalOcupados-Pos))
                Tam=Mem->TotalOcupados-Pos;
#ifdef PRUEBAS_ACTIVADAS
        printf("---MemoriaBorra(Mem,Pos=%lu,Tam=%lu)\n", Pos,Tam),fflush(stdout);
        MemoriaVuelca(Mem,"En el momento de llamada");
#endif
        /* Procesamos el primer bloque */
        NumVictimas=Tam;
        MiPos=Pos-Mem->UltimoIniBloque;
        i=Mem->UltimoBloque;
        if(NumVictimas>(Mem->Bloque[i].Ocupados-MiPos))
                NumVictimas=Mem->Bloque[i].Ocupados-MiPos;
        muevemem( Mem->Bloque[ i].Ptr+ MiPos, Mem->Bloque[ i].Ptr+ MiPos+ NumVictimas, Mem->Bloque[ i].Ocupados- MiPos- NumVictimas);
        Mem->Bloque[i].Ocupados-=NumVictimas;
        Mem->TotalOcupados-=NumVictimas;
        Mem->UltimoFinBloque= Mem->UltimoIniBloque+ Mem->Bloque[ i].Ocupados;
        /* Procesamos el resto de los bloques */
        for(Hechos=NumVictimas,i++;Hechos<Tam;Hechos+=NumVictimas,i++) {
                NumVictimas=Mem->Bloque[i].Ocupados;
                if(!NumVictimas)
                        continue;
                if(NumVictimas>(Tam-Hechos))
                        NumVictimas=Tam-Hechos;
                muevemem( Mem->Bloque[ i].Ptr, Mem->Bloque[ i].Ptr+ NumVictimas, Mem->Bloque[ i].Ocupados- NumVictimas);
                Mem->Bloque[i].Ocupados-=NumVictimas;
                Mem->TotalOcupados-=NumVictimas;
        }
        /* Limpiamos y salimos */
#ifdef PRUEBAS_ACTIVADAS
        MemoriaVuelca(Mem,"Despues de borrar");
#endif
        return(Hechos);
}

unsigned long
MemoriaInsertaFich(sMemoria *Mem, unsigned long Pos, int Fich, unsigned long TamDatos,unsigned char *ResFichDemasiadoGrande)
{
        char BufferTemp[256];
        long Disponibles,Espacio,Hechos,Insertados;
        if(MemoriaBuscaPos(Mem,Pos)==posNoEncontrada)
                return(0);
        Espacio=(Mem->NumBloques*Mem->TamBloque-Mem->TotalOcupados);
        if(ResFichDemasiadoGrande!=NULL)
                *ResFichDemasiadoGrande=0;
        if(TamDatos<0)
                TamDatos=Espacio;
        else if(TamDatos>Espacio)
                TamDatos=Espacio;
        for(Hechos=0;TamDatos>0; TamDatos-=Disponibles,Hechos+=Insertados,Pos+=Insertados) {
                Disponibles= ((TamDatos>sizeof(BufferTemp))?sizeof(BufferTemp):TamDatos);
                if((Disponibles= dos_fread(Fich,BufferTemp,Disponibles))<=0)
                        return(Hechos);
                if((Insertados= MemoriaInserta(Mem,Pos,BufferTemp,Disponibles))<Disponibles) {
                        if(ResFichDemasiadoGrande!=NULL)
                                *ResFichDemasiadoGrande=1;
                        return(Hechos+Insertados);
                }
        }
        if((dos_fread(Fich,BufferTemp,1))==1)
                *ResFichDemasiadoGrande=1;
        return(Hechos);
}

unsigned long
MemoriaVuelcaFich(sMemoria *Mem, unsigned long Pos, int Fich, unsigned long TamDatos)
{
        long i;
        unsigned short MiPos;
        unsigned long NumVictimas,Hechos,Escritos;
        if(MemoriaBuscaPos(Mem,Pos)!=posLetra)
                return(0);
        if(TamDatos<0 || TamDatos>(Mem->TotalOcupados-Pos))
                TamDatos=Mem->TotalOcupados-Pos;
        /* Procesamos el primer bloque */
        NumVictimas=TamDatos;
        MiPos=Pos-Mem->UltimoIniBloque;
        i=Mem->UltimoBloque;
        if(NumVictimas>(Mem->Bloque[i].Ocupados-MiPos))
                NumVictimas=Mem->Bloque[i].Ocupados-MiPos;
        if((Escritos=dos_fwrite(Fich, Mem->Bloque[ i].Ptr+MiPos, NumVictimas))<0 || Escritos<NumVictimas)
                return(((Escritos>0)?Escritos:0));
        Pos+=NumVictimas;
        /* Procesamos el resto de los bloques */
        for(Hechos=Escritos,i++;Hechos<TamDatos;Hechos+=NumVictimas,i++) {
                NumVictimas=Mem->Bloque[i].Ocupados;
                if(!NumVictimas)
                        continue;
                if(NumVictimas>(TamDatos-Hechos))
                        NumVictimas=TamDatos-Hechos;
                if((Escritos=dos_fwrite(Fich, Mem->Bloque[ i].Ptr, NumVictimas))<0 || Escritos<NumVictimas)
                        return(Hechos+((Escritos>0)?Escritos:0));
        }
        /* Salimos informando del nmero de carcteres escritos */
        return(Hechos);
}

unsigned long
MemoriaCopiaMueve(sMemoria *Mem,unsigned long PosDest, unsigned long PosOrig, unsigned long TamDatos,char BanderaMover)
{
        long Espacio,Hechos;
        if(TamDatos<=0 || MemoriaBuscaPos(Mem,PosDest)==posNoEncontrada || MemoriaBuscaPos(Mem,PosDest)!=posLetra)
                return(0);
        Espacio=(Mem->NumBloques*Mem->TamBloque-Mem->TotalOcupados);
        if(!BanderaMover && TamDatos>Espacio)
                TamDatos=Espacio;
        if((PosOrig+TamDatos)>Mem->TotalOcupados)
                TamDatos=Mem->TotalOcupados-PosOrig;
        if(BanderaMover && PosDest==PosOrig)
                return(TamDatos);
        if(PosDest>PosOrig && PosDest<(PosOrig+TamDatos)) {
                if(BanderaMover)
                        return(TamDatos);
                Hechos=MemoriaCopia(Mem,PosDest,PosOrig,PosDest-PosOrig);
                PosDest+=Hechos;
                PosOrig+=Hechos*2;
                TamDatos-=Hechos;
                Hechos+=MemoriaCopia(Mem,PosDest,PosOrig,TamDatos);
        } else {
                char BufferTemp[256];
                long Insertados,Trasladables,Disponibles;
                for(Hechos=0;TamDatos>0; TamDatos-=Disponibles,Hechos+=Insertados,PosDest+=Insertados) {
                        Disponibles= ((TamDatos>sizeof(BufferTemp))?sizeof(BufferTemp):TamDatos);
                        for(Trasladables=0;Trasladables<Disponibles;Trasladables++)
                                BufferTemp[Trasladables]=*MemoriaDato(Mem,PosOrig++);
                        if(BanderaMover) {
                                if(PosDest>=PosOrig)
                                        PosDest-=Trasladables;
                                PosOrig-=Trasladables;
                                MemoriaBorra(Mem,PosOrig,Trasladables);
                        }
                        if((Insertados= MemoriaInserta(Mem,PosDest,BufferTemp,Disponibles))<Disponibles) {
                                return(Hechos+Insertados);
                        }
                        if(PosDest<PosOrig)
                                PosOrig+=Insertados;
                }
        }
        return(Hechos);
}

/* Carga de ficheros sin front-end pero con notificacin de errores al usuario */
int
CargaFichero(sMemoria *Mem,char *NombreFich)
{
        int Fich=0;
        if((Fich=dos_fopen(NombreFich,0))>=0) {
                char BanderaFichGrande;
                MemoriaBorra(Mem,0,MemoriaOcupados(Mem));
                MemoriaInsertaFich(Mem,0,Fich,-1,&BanderaFichGrande);
                dos_fclose(Fich);
                if(BanderaFichGrande) {
                        /* ERROR: No se pudo cargar el fichero completo */
#ifdef SPANISH
                        DialogBox("Aviso","Fichero demasiado grande. Se ha truncado el contenido.",boxOk);
#else
                        DialogBox("Warning","File too large. Contents has been truncated.",boxOk);
#endif
                }
                return(0);
        }
        /* ERROR, hay que avisar al usuario */
#ifdef SPANISH
        DialogBox("Error","Error al abrir el fichero (nombre correcto?).",boxOk);
#else
        DialogBox("Error","Error while openning file (correct name?).",boxOk);
#endif
        return(1);
}


/* Funciones para el front-end de edicin */

typedef enum TipoBanderasLinea { lineaLarga=1, lineaFin=2 } eBanderasLinea;
typedef struct TipoLineaPantalla {
        long PosIni;
        long LineaReal;
        long ColumnaReal;
        long Linea;
        long Columna;
        long Suplidos;
        long Longitud;
        char Banderas;
} sLineaPantalla;

/* Explicacin del contenido de la estructura:
 *
 * PosIni.....: Posicion en el Buffer del primer caracter pintado en la pantalla
 * LineaReal..: Nmero de lnea real de esa PosIni (sin contar las "lineaLarga"s
 *              como varias lneas). Puramente informativo.
 * ColumnaReal: Nmero de columna real de esa PosIni (es decir, contando desde
 *              el principio fsico de la lnea, no desde la ltima particin
 *              por "lineaLarga"). Puramente informativo (salvo para ir a la
 *              izq en un wrapping y que suba de lnea).
 * Linea......: Nmero de lnea visual de esa PosIni (si contamos en la
 *              pantalla, llevamos ese nmero de lneas).
 * Columna....: Nmero de columna visual de esa PosIni (es lo que nos hemos
 *              desplazado desde esa ultima particin por lineaLarga o desde
 *              el principio de la linea si no ha habido particin por
 *              lineaLarga.
 * Suplidos...: Si PosIni est al final de la lnea (nos hemos pasado de dar
 *              hacia la derecha), esta es la cantidad en que nos hemos pasado.
 * Longitud...: Siempre menor o igual que el mximo tamao lineaLarga. Es la
 *              longitud de esta nea desde la ltima particin (o desde el ppio
 *              si no la hubo).
 * Banderas...: lineaFin:- Esta lnea termina en NULL (A.K.A. EOF)
 *              lineaLarga:- Esta linea est partida
 *
 */
 #define USARBUFFER

#define NUMLINEASPAGINA 10

#ifdef USARBUFFER
/* Hago 8 lneas de 4x8 por cuestiones de velocidad (escribo directamente) */
#define NUMLINEAS 8
#define NUMLINEASVIS 7
#define LETRAY 8
#define NUMLINEASVISEDIT 4
#else
/* Caso normal: 10 lneas de 6 pxels (uso PonLetraPeq()) */
#define NUMLINEAS 10
#define NUMLINEASVIS 10
#define LETRAY 6
#define NUMLINEASVISEDIT 6
#endif
#define NUMCOLUMNAS 25
#define LETRAX 4
#define MAXLINEA 25

typedef struct TipoPosicion {
        int ManejadorBlink;
        long Linea;
        long Columna;
        long NumLinea;
        long NumColumna;
        long MarcadoIni;
        long MarcadoFin;
        int DespCursor;
        int LinMostradas;
        char BanderaEditando;
        char BanderaMarcando;
        char BanderaCursor;
        char BanderaActualizar;
        char BanderaEspacioInsertado;
} sPosicion;

void CalculaLineaAnterior(sMemoria *Mem, sLineaPantalla *Info);
void PintaPantalla(sMemoria *Mem, sLineaPantalla *Info, int NumLin, sPosicion *Pos);
void ProcesaTecla(int Tecla,sMemoria *Mem, sLineaPantalla *Info, sPosicion *Pos);
void IrAPrincipio(sLineaPantalla *Info,sPosicion *Pos);
void IrAPos(long PosPedida,sMemoria *Mem,sLineaPantalla *Info,sPosicion *Pos);
long LinCol2Pos(sLineaPantalla *Info, sPosicion *Pos);
void AjustaMarcado(int NumInsertados,sLineaPantalla *Info, sPosicion *Pos);



enum EnumMenus { menuNuevo=(1<<8), menuCargar, menuSalvar, menuSalvarcomo, menuDummy1, menuSalir,
                 menuMarcar=(2<<8), menuDummy2, menuCopiar, menuMover, menuCortar,menuDummy3,menuBuscar,menuDummy4,
                 menuIrInicio=(3<<8),menuIrFinal,
                 menuHex=(4<<8),menuDOS,
                 menuDos2unix=(5<<8),menuUnix2dos,
                 menuDummy5=(6<<8),
                 menuAcercade=(7<<8)};

#if defined(PRUEBAS_ACTIVADAS) && defined(PRUEBAS_REALES)
#undef PRUEBAS_ACTIVADAS
#endif

void
Editor(sMemoria *Mem, sTeclado *Teclado,char *NombreFich)
{
#ifdef SPANISH
        sMenu MenuFicheros[]={{"Nuevo",5,NULL,NULL},
                              {"Cargar...",9,NULL,NULL},
                              {"Salvar",-6,NULL,NULL},
                              {"Salvar como...",14,NULL,NULL},
                              {"--------------",-14,NULL,NULL},
                              {"Salir",5,NULL,NULL},
                              {NULL,menuNuevo,NULL,NULL}};
        sMenu MenuConvertir[]={{"dos2unix",-8,NULL,NULL},
                               {"unix2dos",-8,NULL,NULL},
                               {NULL,menuDos2unix,NULL,NULL}};
        sMenu MenuEdit[]={{"Marcar",6,NULL,NULL},
                          {"---------",-9,NULL,NULL},
                          {"Copiar",-6,NULL,NULL},
                          {"Mover",-5,NULL,NULL},
                          {"Cortar",-6,NULL,NULL},
                          {"---------",-9,NULL,NULL},
                          {"Buscar...",-9,NULL,NULL},
                          {NULL,menuMarcar,NULL,NULL}};
        sMenu MenuIr[]={{"Inicio",6,NULL,NULL},
                        {"Final",5,NULL,NULL},
                        {NULL,menuIrInicio,NULL,NULL}};
        sMenu MenuModo[]={{"Hex",-3,NULL,NULL},
                          {"DOS",-3,NULL,NULL},
                          {"-----------",-11,NULL,NULL},
                          {"Convertir >",-11,fnSubMenu,MenuConvertir},
                          {NULL,menuHex,NULL,NULL}};
        sMenu MenuAyuda[]={{"Acerca de...",12,NULL,NULL},
                           {NULL,menuAcercade,NULL,NULL}};
        sMenu MenuPrincipal[]={{"Fich",4,fnSubMenu,MenuFicheros},
                               {"Edit",4,fnSubMenu,MenuEdit},
                               {"Ir",2,fnSubMenu,MenuIr},
                               {"Modo",4,fnSubMenu,MenuModo},
                               {"",0,NULL,NULL},
                               {"Ayuda",5,fnSubMenu,MenuAyuda},
                               {NULL,0,NULL,NULL}};
#else
        sMenu MenuFicheros[]={{"New",3,NULL,NULL},
                              {"Load...",7,NULL,NULL},
                              {"Save",-4,NULL,NULL},
                              {"Save as...",10,NULL,NULL},
                              {"----------",-10,NULL,NULL},
                              {"Exit",4,NULL,NULL},
                              {NULL,menuNuevo,NULL,NULL}};
        sMenu MenuConvertir[]={{"dos2unix",-8,NULL,NULL},
                               {"unix2dos",-8,NULL,NULL},
                               {NULL,menuDos2unix,NULL,NULL}};
        sMenu MenuEdit[]={{"Select",6,NULL,NULL},
                          {"-------",-7,NULL,NULL},
                          {"Copy",-4,NULL,NULL},
                          {"Move",-4,NULL,NULL},
                          {"Cut",-3,NULL,NULL},
                          {"-------",-7,NULL,NULL},
                          {"Find...",-7,NULL,NULL},
                          {NULL,menuMarcar,NULL,NULL}};
        sMenu MenuIr[]={{"Top",3,NULL,NULL},
                        {"Bottom",6,NULL,NULL},
                        {NULL,menuIrInicio,NULL,NULL}};
        sMenu MenuModo[]={{"Hex",-3,NULL,NULL},
                          {"DOS",-3,NULL,NULL},
                          {"---------",-9,NULL,NULL},
                          {"Convert >",-9,fnSubMenu,MenuConvertir},
                          {NULL,menuHex,NULL,NULL}};
        sMenu MenuAyuda[]={{"About...",8,NULL,NULL},
                           {NULL,menuAcercade,NULL,NULL}};
        sMenu MenuPrincipal[]={{"File",4,fnSubMenu,MenuFicheros},
                               {"Edit",4,fnSubMenu,MenuEdit},
                               {"Go",2,fnSubMenu,MenuIr},
                               {"Mode",4,fnSubMenu,MenuModo},
                               {" ",-1,NULL,NULL},
                               {"Help",4,fnSubMenu,MenuAyuda},
                               {NULL,0,NULL,NULL}};
#endif
#if 0
#ifndef PRUEBAS_ACTIVADAS
        long TamTextoPrueba;
        static char TextoPrueba[]={"Erase una vez un pequeo mundo en el que viva Pulgarcito.\nComo este mundo no se conoca bien, nadie se extra cuando Pulgarcito desapareci.\nUno.\nDos.\nTres.\nEse fue el conjuro que hizo que Pulgarcito desapareciera.\nEra demasiado sencillo, claro, pero su mundo era ms sencillo...\nSin embargo, los problemas no hicieron ms que empezar.\nYa poda oir a su inseparable compaero buscarle, y cada vez se alejaba ms de la zona protegida...\nUna vez estuvo a punto de meterse en unas zarzas venenosas.\nOtra vez a punto de caerse en un fangoso lago repleto de asquerosos y reluctantes criaturas.\nPero la vez peor de todas fue cuando se adentr en el bosque tenebroso. Pulgarcito ya no saba qu hacer para que se contuviera... no se contuvo y sucedi lo inevitable:\n\nLe capturaron unos malvados trolls que acampaban en el bosque!"};
/*        static char TextoPrueba[]={"Erase una vez un pequeo mundo en el que viva Pulgarcito.\n"};*/
#endif
#endif
        static char Cursor[4+LETRAX];
        int x,y;
        int i,n,t;
        sLineaPantalla Info[NUMLINEAS+NUMLINEASVISEDIT];
        sPosicion Pos;
        for(i=0;i<(sizeof(Info)/sizeof(Info[0]));i++) {
                Info[i].PosIni= Info[i].Linea= Info[i].LineaReal= Info[i].Columna= Info[i].ColumnaReal= Info[i].Suplidos= Info[i].Longitud=0;
                Info[i].Banderas=lineaFin;
        }
        Pos.ManejadorBlink=-1;
        Pos.NumLinea=Pos.NumColumna=Pos.Linea=Pos.Columna=0;
        Pos.BanderaEditando=0;
        Pos.BanderaMarcando=0;
        Pos.BanderaActualizar=1;
        Pos.BanderaCursor=0;
        Pos.BanderaEspacioInsertado=0;
        Pos.DespCursor=0;
        Pos.LinMostradas=NUMLINEAS;
        Pos.MarcadoIni=Pos.MarcadoFin=0;
        x=y=0;
#if 0
#ifndef PRUEBAS_ACTIVADAS
/****************/
        for(TamTextoPrueba=0; TextoPrueba[TamTextoPrueba]!='\0'; TamTextoPrueba++)
                ;
        MemoriaInserta(Mem,0,TextoPrueba,TamTextoPrueba);
/****************/
#endif
#endif
        while(1) {
                lcdfreeze(1);
                if(Pos.BanderaActualizar) {
                        PintaPantalla(Mem, Info+Pos.DespCursor, Pos.LinMostradas,&Pos);
                        Pos.BanderaCursor=0;
                }
                if(!Pos.BanderaEditando)
                        LineaEstado( Info[Pos.NumLinea].LineaReal+1, Info[Pos.NumLinea].ColumnaReal+1+Pos.Columna, (Pos.Linea)/NUMLINEASPAGINA+1);
                lcdfreeze(0);
                Pos.BanderaActualizar=0;
                if(Pos.BanderaCursor) {
                        gv_put(x,y,Cursor,COPY_PUT);
                        Pos.BanderaCursor=0;
                }
                if(Pos.ManejadorBlink!=-1) {
                        blend(Pos.ManejadorBlink);
                        Pos.ManejadorBlink=-1;
                }
                x=Pos.NumColumna*LETRAX;
                y=(Pos.NumLinea-Pos.DespCursor)*LETRAY;
                gv_get(x,y,x+LETRAX-1,y+LETRAY-1,Cursor);
                Pos.BanderaCursor=1;
#ifdef USARBUFFER
                gv_square( Pos.NumColumna*LETRAX, y+LETRAY-3, Pos.NumColumna*LETRAX+LETRAX-1, y+LETRAY-2, COPY_PUT, 0xffffffff);
                Pos.ManejadorBlink=blink(Pos.NumColumna*LETRAX, y+LETRAY-3, Pos.NumColumna*LETRAX+LETRAX-1, y+LETRAY-2,0x60);
#else
                gv_square( Pos.NumColumna*LETRAX, y+LETRAY-2, Pos.NumColumna*LETRAX+LETRAX-1, y+LETRAY-1, COPY_PUT, 0xffffffff);
                Pos.ManejadorBlink=blink(Pos.NumColumna*LETRAX, y+LETRAY-2, Pos.NumColumna*LETRAX+LETRAX-1, y+LETRAY-1,0x60);
#endif
                if(Pos.BanderaEditando) {
                        signed char BanderaCarInsertado=0;
#ifdef LINUX
                        printf("---Actual: Lin=%li, Col=%li (NumLin=%li, NumCol=%li); Desp=%li, LinMost=%li\n",Pos.Linea,Pos.Columna,Pos.NumLinea,Pos.NumColumna,(long) Pos.DespCursor,(long) Pos.LinMostradas);
#endif

                        t=TecladoLee(Teclado);
                        if(t==(TECLA_ENTER<<8)) {
                                ProcesaTecla(TECLA_ENTER,Mem,Info,&Pos);
                        } else if(t==TECLADO_BORRAR && (Info[Pos.NumLinea].ColumnaReal>0 || (Pos.NumColumna-Info[Pos.NumLinea].Columna)>0)) {
                                AjustaMarcado(-1,Info,&Pos);
                                 ProcesaTecla(TECLA_IZQ,Mem,Info,&Pos);
                                if(Pos.BanderaActualizar)
                                        PintaPantalla(Mem,Info,0,&Pos);
                                Pos.NumColumna=Pos.Columna-Info[0].Columna;
                                MemoriaBorra(Mem,Info[Pos.NumLinea ].PosIni+Pos.NumColumna,1);
                                Pos.BanderaActualizar++;
                                BanderaCarInsertado=-1;
                        } else if(t==TECLADO_BORRAR && Pos.Columna==0 && Pos.Linea>0) {
                                char *Letra;
                                AjustaMarcado(-1,Info,&Pos);
                                ProcesaTecla(TECLA_ARR,Mem,Info,&Pos);
                                PintaPantalla(Mem,Info,0,&Pos);
                                while(*(Letra= MemoriaDato(Mem,Info[Pos.NumLinea ].PosIni+Pos.NumColumna))!='\n' && Pos.NumColumna<NUMCOLUMNAS)
                                        Pos.NumColumna++;
                                Pos.Columna=Info[0].Columna+Pos.NumColumna;
                                if(*Letra!='\n') {
                                        while(*(Letra= MemoriaDato(Mem,Info[Pos.NumLinea ].PosIni+Pos.NumColumna))!='\n') {
                                                if(Info[0 ].Longitud>Info[0 ].Columna)
                                                        Info[0 ].PosIni++;
                                                else
                                                        Info[0 ].Suplidos++;
                                                Info[0 ].Columna++;
                                                Info[0 ].ColumnaReal++;
                                                Pos.Columna++;
                                        }
                                }
                                Pos.NumColumna=Pos.Columna-Info[0].Columna;
                                MemoriaBorra(Mem,Info[Pos.NumLinea ].PosIni+Pos.NumColumna,1);
                                Pos.BanderaActualizar++;
                                if(Pos.NumColumna==NUMCOLUMNAS) {
                                        PintaPantalla(Mem,Info,0,&Pos);
                                        ProcesaTecla(TECLA_DER,Mem,Info,&Pos);
                                }
                        } else if(t==TECLADO_ENTER) {
                                char MiLetra;
                                MiLetra='\n';
                                if(!MemoriaInserta(Mem,Info[Pos.NumLinea ].PosIni+Pos.NumColumna,&MiLetra,1)) {
                                        gv_reverse(0,0,101,63);
                                        Pos.BanderaActualizar++;
                                } else {
                                        AjustaMarcado(1,Info,&Pos);
                                        PintaPantalla( Mem, Info+Pos.DespCursor, 0, &Pos);
                                        while(Info[0 ].Columna>0) {
                                                Info[0 ].Columna--;
                                                Info[0 ].ColumnaReal--;
                                                if(Info[0 ].Suplidos==0) {
                                                        Info[0 ].PosIni--;
                                                } else
                                                        Info[0 ].Suplidos--;
                                        }
                                        Pos.BanderaActualizar++;
                                        Pos.Columna=0;
                                        Pos.NumColumna= Pos.Columna- Info[ 0].Columna;
                                        PintaPantalla(Mem,Info,0,&Pos);
                                        ProcesaTecla(TECLA_ABJ,Mem,Info,&Pos);
                                }
                        } else if(t!=TECLADO_BORRAR && t>0 && t<256) {
                                char MiLetra;
                                MiLetra=t;
                                if(!MemoriaInserta(Mem,Info[ Pos.NumLinea].PosIni+Pos.NumColumna,&MiLetra,1)) {
                                        gv_reverse(0,0,101,63);
                                        Pos.BanderaActualizar++;
                                } else {
                                        AjustaMarcado(1,Info,&Pos);
                                        PintaPantalla( Mem, Info+Pos.DespCursor, Pos.LinMostradas,&Pos);
                                        Pos.BanderaCursor=0;
                                        ProcesaTecla(TECLA_DER,Mem,Info,&Pos);
                                }
                        }
                } else {
#ifdef LINUX
                        printf("---Actual: Lin=%li, Col=%li (NumLin=%li, NumCol=%li)\n",Pos.Linea,Pos.Columna,Pos.NumLinea,Pos.NumColumna);
#endif
                        n=EsperaTecla(TECLA_DER | TECLA_IZQ | TECLA_ARR | TECLA_ABJ)&0xff;
                        if(n==TECLA_MENU) {
                                if(Pos.ManejadorBlink!=-1) {
                                        blend(Pos.ManejadorBlink);
                                        Pos.ManejadorBlink=-1;
                                }
                                if(NombreFich[0]=='\0')
                                        MenuFicheros[menuSalvar&0xFF].Space=-ABS(MenuFicheros[menuSalvar&0xFF].Space);
                                else
                                        MenuFicheros[menuSalvar&0xFF].Space=ABS(MenuFicheros[menuSalvar&0xFF].Space);
                                if(Pos.MarcadoIni>=Pos.MarcadoFin) {
                                        MenuEdit[menuCopiar&0xFF].Space=-ABS(MenuEdit[menuCopiar&0xFF].Space);
                                        MenuEdit[menuMover&0xFF].Space=-ABS(MenuEdit[menuMover&0xFF].Space);
                                        MenuEdit[menuCortar&0xFF].Space=-ABS(MenuEdit[menuCortar&0xFF].Space);
                                } else {
                                        MenuEdit[menuCopiar&0xFF].Space=ABS(MenuEdit[menuCopiar&0xFF].Space);
                                        MenuEdit[menuMover&0xFF].Space=ABS(MenuEdit[menuMover&0xFF].Space);
                                        MenuEdit[menuCortar&0xFF].Space=ABS(MenuEdit[menuCortar&0xFF].Space);
                                }
                                t=MenuInit(MenuPrincipal);
                                if(t==menuSalir)
                                        break;
                                switch(t) {
                                case menuNuevo:
                                        MemoriaBorra(Mem,0,MemoriaOcupados(Mem));
                                        IrAPrincipio(Info,&Pos);
                                        Pos.MarcadoIni=Pos.MarcadoFin=0;
                                        break;
                                case menuCargar:
                                        {
                                                char CopiaNombreFich[TAMNOMBREFICH];
                                                char *Ptr;
                                                fs_copiacad(CopiaNombreFich,NombreFich,sizeof(CopiaNombreFich));
                                                if((Ptr=FileSel(MenuFicheros[menuCargar&0xFF].String,NombreFich,TAMNOMBREFICH))==NULL) {
                                                        fs_copiacad(NombreFich,CopiaNombreFich,TAMNOMBREFICH);
                                                        break;
                                                }
                                                if(CargaFichero(Mem,NombreFich)==0) {
                                                        IrAPrincipio(Info,&Pos);
                                                        Pos.MarcadoIni=Pos.MarcadoFin=0;
                                                } else
                                                        fs_copiacad(NombreFich,CopiaNombreFich,TAMNOMBREFICH);
                                        }
                                        break;
                                case menuSalvar:
                                        {
                                                int Fich;
                                                if((Fich=dos_fopen(NombreFich,1))>=0) {
                                                        if(MemoriaVuelcaFich(Mem,0,Fich,MemoriaOcupados(Mem))<MemoriaOcupados(Mem)) {
                                                                /* ERROR, hay que avisar al usuario */;
#ifdef SPANISH
                                                                DialogBox("Error","Error mientras se escriba el fichero (disco lleno?).",boxOk);
#else
                                                                DialogBox("Error","Error while writing file (disk full?).",boxOk);
#endif
                                                        }
                                                        dos_fclose(Fich);
                                                        bi_vwrflush();
                                                } else {
                                                        /* ERROR, hay que avisar al usuario de que no se ha podido salvar */
#ifdef SPANISH
                                                        DialogBox("Error","Error al abrir el fichero (disco lleno? solo lectura?).",boxOk);
#else
                                                        DialogBox("Error","Error while openning file (disk full? read only?).",boxOk);
#endif
                                                }
                                        }
                                        break;
                                case menuSalvarcomo:
                                        {
                                                char CopiaNombreFich[TAMNOMBREFICH];
                                                int Fich;
                                                fs_copiacad(CopiaNombreFich,NombreFich,sizeof(CopiaNombreFich));
                                                while(1) {
                                                        /* ERROR: Ahora mismo slo aade al final del fichero, no borra y escribe */
                                                        if(FileSel(MenuFicheros[menuSalvarcomo&0xFF].String,NombreFich,TAMNOMBREFICH)==NULL) {
                                                                fs_copiacad(NombreFich,CopiaNombreFich,TAMNOMBREFICH);
#ifdef SPANISH
                                                                DialogBox("Informacin","Salvar fichero cancelado por orden del usuario.",boxOk);
#else
                                                                DialogBox("Information","File save operation cancelled by user.",boxOk);
#endif
                                                                break;
                                                        }
                                                        /* Habra que mirar si el fichero existe y en su caso dar oportunidad de "sobreescribirlo" (borrarlo antes de abrir) */
                                                        if((Fich=dos_fcrnew(NombreFich))<0) {
                                                                if((Fich=dos_fopen(NombreFich,0))>=0) {
                                                                        int Sel;
                                                                        dos_fclose(Fich);
#ifdef SPANISH
                                                                        Sel=DialogBox("Aviso","El fichero existe, desea sobre escribirlo?",boxYesNo);
#else
                                                                        Sel=DialogBox("Aviso","File exists, overwrite?",boxYesNo);
#endif
                                                                        if(Sel==1)
                                                                                continue;
                                                                        if((Fich=dos_fopen(NombreFich,1))<0) {
#ifdef SPANISH
                                                                                DialogBox("Error","Error al abrir el fichero (disco lleno? solo lectura?).",boxOk);
#else
                                                                                DialogBox("Error","Error while openning file (disk full? read only?).",boxOk);
#endif
                                                                        }
                                                                }
                                                        }
                                                        if(Fich<0) {
                                                                fs_copiacad(NombreFich,CopiaNombreFich,TAMNOMBREFICH);
                                                                continue;
                                                        }
#ifdef LINUX
                                                        printf("Se est salvando %s\n",NombreFich);
#endif
                                                        if(MemoriaVuelcaFich(Mem,0,Fich,MemoriaOcupados(Mem))<MemoriaOcupados(Mem)) {
                                                                /* ERROR, hay que avisar al usuario */;
#ifdef SPANISH
                                                                DialogBox("Error","Error mientras se escriba el fichero (disco lleno?).",boxOk);
#else
                                                                DialogBox("Error","Error while writing file (disk full?).",boxOk);
#endif
                                                        }
                                                        dos_fclose(Fich);
                                                        bi_vwrflush();
                                                        break;
                                                }
                                        }
                                        break;
                                case menuMarcar:
                                        Pos.BanderaMarcando=1-Pos.BanderaMarcando;
                                        if(Pos.BanderaMarcando)
                                                Pos.MarcadoIni=Pos.MarcadoFin=LinCol2Pos(Info,&Pos);
                                        else {
                                                Pos.MarcadoFin=LinCol2Pos(Info,&Pos);
                                                if(Pos.MarcadoFin<=Pos.MarcadoIni)
                                                        Pos.MarcadoIni=Pos.MarcadoFin=0;
                                        }
                                        break;
                                case menuCopiar:
                                case menuMover:
                                        {
                                                unsigned long PosInsercion;
                                                unsigned long TamInsercion,NuevoTam;
                                                PosInsercion=LinCol2Pos(Info,&Pos);
                                                TamInsercion=Pos.MarcadoFin-Pos.MarcadoIni;
                                                if((NuevoTam=MemoriaCopiaMueve(Mem,PosInsercion,Pos.MarcadoIni,TamInsercion,(t==menuMover)?1:0))<TamInsercion) {
                                                        /* Avisamos "visualmente" de que no haba espacio suficiente */
                                                        gv_reverse(0,0,101,63);
                                                }
                                                if(t==menuMover) {
                                                        if(PosInsercion>=Pos.MarcadoIni && PosInsercion<=Pos.MarcadoFin)
                                                                PosInsercion=Pos.MarcadoIni;
                                                        else if(PosInsercion>Pos.MarcadoFin)
                                                                PosInsercion-=NuevoTam;
                                                        IrAPos(PosInsercion,Mem,Info,&Pos);
                                                }
                                                Pos.MarcadoIni=PosInsercion;
                                                Pos.MarcadoFin=PosInsercion+NuevoTam;
                                                Pos.BanderaActualizar++;
                                        }
                                        break;
                                case menuCortar:
                                        IrAPos(Pos.MarcadoIni,Mem,Info,&Pos);
                                        MemoriaBorra(Mem,Pos.MarcadoIni,Pos.MarcadoFin-Pos.MarcadoIni);
                                        Pos.MarcadoFin=Pos.MarcadoIni=0;
                                        Pos.BanderaActualizar++;
                                        break;
                                case menuIrInicio:
                                        IrAPrincipio(Info,&Pos);
                                        break;
                                case menuIrFinal:
                                        if(MemoriaOcupados(Mem)>0)
                                                IrAPos(MemoriaOcupados(Mem)-1,Mem,Info,&Pos);
                                        else
                                                IrAPrincipio(Info,&Pos);
                                        break;
                                case menuAcercade:
#ifdef SPANISH
                                        DibujaVentana("Acerca de...");
#else
                                        DibujaVentana("About...");
#endif
                                        lcdfreeze(1);
                                        {
                                                char *Texto[]={"O.K.",NULL};
                                                DibujaBotonesDialogBox(0,Texto);
                                        }
                                        gv_kput(3,11,"TECLADO v0.2",2,0,0);
#ifdef SPANISH
                                        PonCadPeq(3,22,"  Un editor de textos");
#else
                                        PonCadPeq(3,22,"     A text editor   ");
#endif
                                        gv_line(3,30,98,30,COPY_PUT,0xFF);
#ifdef SPANISH
                                        PonCadPeq(3,33,"Realizado por:");
#else
                                        PonCadPeq(3,33,"Programmed by:");
#endif
                                        PonCadPeq(3,40,"  dario@softhome.net");
                                        PonCadPeq(3,46,"  Dario Rodriguez");
                                        lcdfreeze(0);
                                        while(!(EsperaTecla(0)&TECLA_ENTER))
                                                ;
                                        break;
                                }
                                PintaPantalla(Mem, Info+Pos.DespCursor, Pos.LinMostradas, &Pos);
                        }
                        ProcesaTecla(n,Mem,Info,&Pos);
                }
        }
}


#ifdef USARBUFFER
char BufferPantalla[8*102+4];
#endif

void
CalculaLineaAnterior(sMemoria *Mem, sLineaPantalla *Info)
{
        long Ini,ColReal;
        long i;
        char BanderaContinuacion;
        char *Letra;
        Ini=Info[0].PosIni+Info[0].Suplidos-Info[0].Columna;
        Ini--;
        if((Letra=MemoriaDato(Mem,Ini))==NULL)
                return;
        BanderaContinuacion=0,ColReal=0;
        if(*Letra=='\n') {
                int IniTmp;
                for(IniTmp=Ini-1;(Letra=MemoriaDato(Mem,IniTmp))!=NULL && *Letra!='\n';IniTmp--)
                        ;
                IniTmp++;
                while((Ini-IniTmp)>MAXLINEA) {
                        IniTmp+=MAXLINEA;
                        ColReal+=MAXLINEA;
                }
                Ini=IniTmp;
                BanderaContinuacion=0;
        } else {
                Ini-=(MAXLINEA-1);
                BanderaContinuacion=1;
                ColReal=(Info[0].ColumnaReal+ Info[0].Suplidos- Info[0].Columna)- MAXLINEA;
        }
        Info[0].Linea--;
        Info[0].LineaReal-=(1-BanderaContinuacion);
        Info[0].ColumnaReal=ColReal+Info[0].Columna;
        if(Info[0].Columna!=0) {
                /* Saltamos lo que no nos interesa */
                for(i=0;(Letra=MemoriaDato(Mem,Ini))!=NULL && *Letra!='\n' && i<Info[0].Columna && i<MAXLINEA;i++,Ini++)
                        ;
                for(Info[0].Suplidos=0;i<Info[0].Columna && i<MAXLINEA;i++)
                        Info[0].Suplidos++;
        }
        Info[0].PosIni=Ini;
        for(i=0;(Letra=MemoriaDato(Mem,Ini))!=NULL && *Letra!='\n' && (i+Info[0].Columna)<MAXLINEA;i++,Ini++)
                ;
        Info[0].Longitud=i+Info[0].Columna-Info[0].Suplidos;
        Info[0].Banderas=(BanderaContinuacion?lineaLarga:0);
}

void
PintaPantalla(sMemoria *Mem, sLineaPantalla *Info, int NumLin, sPosicion *Posicion)
{
        unsigned int i,j,posy;
        long Pos;
        char *Letra;
#ifdef USARBUFFER
        char *Buf,*Buf2,*Ptr;
        BufferPantalla[0]=102;
        BufferPantalla[2]=((NumLin>=NUMLINEAS)?60:NumLin*LETRAY);
        BufferPantalla[1]=BufferPantalla[3]=0;
#else
        unsigned int posx;
        if(NumLin>0) {
                lcdfreeze(1);
                gv_clear(0,0,102,NumLin*6-1);
        }
#endif
#ifdef LINUX
        {
                int k,h,l;
                for(k=0;k<2;k++) {
                        printf("Bloque[%li] (",(long) k);
                        for(h=0;h<Mem->Bloque[k].Ocupados && h<4;h++) {
                                l=Mem->Bloque[k].Ptr[h];
                                printf("%c",(l!='\n')?l:'#');
                        }
                        printf("..");
                        for(h=Mem->Bloque[k].Ocupados-5;h<Mem->Bloque[k].Ocupados && h>0;h++) {
                                l=Mem->Bloque[k].Ptr[h];
                                printf("%c",(l!='\n')?l:'$');
                        }
                        printf("): %li\n",(long) Mem->Bloque[k].Ocupados);
                }
        }
        printf("  Num PosIni Longit Linea  Colum. Suple. LinRe. ColRe. Banderas\n");
#endif
        for(i=0;i<NUMLINEAS;i++) {
                Pos=Info[i].PosIni;
                posy=((i<<2)+(i<<1));
#ifdef USARBUFFER
                Buf=BufferPantalla+4+i*102;
                Buf2=Buf+102;
#endif
                if(i<NumLin) {
#ifdef LINUX
                        printf("+ \"");
#endif
                        for(j=0;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && j<NUMCOLUMNAS;j++,Pos++) {
#ifdef LINUX
                                printf("%c",*Letra);
#endif
#ifdef USARBUFFER
                                Ptr=Fuente+((*Letra)<<2);
                                *(Buf++)=*(Ptr++);
                                *(Buf++)=*(Ptr++);
                                *(Buf++)=*(Ptr++);
                                *(Buf++)=*(Ptr++);
#else
                                posx=j<<2;
                                PonLetraPeq(posx,posy,*Letra);
#endif
                        }
#ifdef LINUX
                        printf("\" Pos=%li Bloque=%li Ocupados=%li\n ",(long)Pos,(long)Mem->UltimoBloque,(long)Mem->Bloque[Mem->UltimoBloque].Ocupados);
#endif
#ifdef USARBUFFER
                        Ptr=&(CarExtra[((Letra!=NULL && *Letra!='\n')?1:0)][4]);
                        *(Buf++)=*(Ptr++);
                        *(Buf++)=*(Ptr++);
                        while(Buf<Buf2)
                                *(Buf++)=0;
#else
                        PonCarExtra(LETRAX*NUMCOLUMNAS,LETRAY*i,((Letra!=NULL && *Letra!='\n')?1:0));
#endif
                } else {
#ifdef LINUX
                        printf(".");
#endif
                        for(j=0;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && j<NUMCOLUMNAS;j++,Pos++)
                                ;
#ifdef USARBUFFER
                        inicializamem(Buf,0,102);
                        Buf+=102;
#endif
                }
                for(;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && (j+Info[i].Columna)<MAXLINEA;j++,Pos++)
                        ;
                Info[i].Longitud=j+Info[i].Columna-Info[i].Suplidos;
                Info[i].Banderas=(((Letra==NULL)?lineaFin:0)|((Letra!=NULL && *Letra!='\n')?lineaLarga:0));
                if(Letra!=NULL && *Letra=='\n')
                        Pos++;
#ifdef LINUX
                printf( " %2i:%6li %6li %6li %6li %6li %6li %6li %s%s\n",i, Info[i].PosIni, Info[i].Longitud, Info[i].Linea, Info[i].Columna, Info[i].Suplidos, Info[i].LineaReal, Info[i].ColumnaReal,(Info[i].Banderas & lineaLarga)?"lineaLarga":"",(Info[i].Banderas & lineaFin)?"lineaFin":"");
#endif
                if((i+1)<NUMLINEAS) {
                        if(Info[i].Columna!=0) {
                                /* Saltamos lo que no nos interesa */
                                for(j=0;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && j<Info[i].Columna && j<MAXLINEA;j++,Pos++)
                                        ;
                                for(Info[i+1].Suplidos=0;j<Info[i].Columna && j<MAXLINEA;j++)
                                        Info[i+1].Suplidos++;
                        } else
                                Info[i+1].Suplidos=0;
                        Info[i+1].PosIni=Pos;
                        Info[i+1].LineaReal=Info[i ].LineaReal+((Info[i ].Banderas==0)?1:0);
                        Info[i+1].Linea=Info[i].Linea+1;
                        Info[i+1].Columna=Info[i].Columna;
                        Info[i+1].ColumnaReal=((Info[i ].Banderas==lineaLarga)?Info[i ].ColumnaReal+Info[i ].Longitud:0);
                }
        }
        if(NumLin>0) {
                int ini,fin,mini,mfin;
                for(i=0;i<NumLin && Info[i].PosIni<Posicion->MarcadoFin;i++) {
                        ini=Info[i].PosIni;
                        if(Info[i].Suplidos>0)
                                fin=Info[i].PosIni;
                        else if(Info[i].Longitud<NUMCOLUMNAS)
                                fin=Info[i].PosIni+Info[i].Longitud;
                        else
                                fin=Info[i].PosIni+NUMCOLUMNAS;
                        if(Posicion->MarcadoFin<ini || Posicion->MarcadoIni>=fin)
                                continue;
                        if(Posicion->MarcadoIni>ini)
                                mini=Posicion->MarcadoIni-Info[i].PosIni;
                        else
                                mini=ini-Info[i].PosIni;
                        if(Posicion->MarcadoFin<fin)
                                mfin=Posicion->MarcadoFin-Info[i].PosIni;
                        else
                                mfin=fin-Info[i].PosIni;
#ifdef USARBUFFER
                        for(Buf=BufferPantalla+4+i*102+mini*4,j=mini;j<mfin;j++) {
                                *(Buf++)= ~ *(Buf);
                                *(Buf++)= ~ *(Buf);
                                *(Buf++)= ~ *(Buf);
                                *(Buf++)= ~ *(Buf);
                        }
#else
                        gv_reverse(mini<<2,i*6,(mfin<<2)-1,i*6+5);
#endif
                }
#ifdef USARBUFFER
                gv_put(0,0,BufferPantalla,COPY_PUT);
#else
                lcdfreeze(0);
#endif
        }
#ifdef LINUX
        printf("\n"),fflush(stdout);
#endif

}

void
CalculaPantalla(sMemoria *Mem, sLineaPantalla *Info, int NumLin)
{
        unsigned int i,j,posy;
        long Pos;
        char *Letra;
        for(i=0;i<NumLin;i++) {
                Pos=Info[i].PosIni;
                posy=((i<<2)+(i<<1));
                for(j=0;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && j<NUMCOLUMNAS;j++,Pos++)
                        ;
                for(;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && (j+Info[i].Columna)<MAXLINEA;j++,Pos++)
                        ;
                Info[i].Longitud=j+Info[i].Columna-Info[i].Suplidos;
                Info[i].Banderas=(((Letra==NULL)?lineaFin:0)|((Letra!=NULL && *Letra!='\n')?lineaLarga:0));
                if(Letra!=NULL && *Letra=='\n')
                        Pos++;
                if((i+1)<NumLin) {
                        if(Info[i].Columna!=0) {
                                /* Saltamos lo que no nos interesa */
                                for(j=0;(Letra=MemoriaDato(Mem,Pos))!=NULL && *Letra!='\n' && j<Info[i].Columna && j<MAXLINEA;j++,Pos++)
                                        ;
                                for(Info[i+1].Suplidos=0;j<Info[i].Columna && j<MAXLINEA;j++)
                                        Info[i+1].Suplidos++;
                        } else
                                Info[i+1].Suplidos=0;
                        Info[i+1].PosIni=Pos;
                        Info[i+1].LineaReal=Info[i ].LineaReal+((Info[i ].Banderas==0)?1:0);
                        Info[i+1].Linea=Info[i].Linea+1;
                        Info[i+1].Columna=Info[i].Columna;
                        Info[i+1].ColumnaReal=((Info[i ].Banderas==lineaLarga)?Info[i ].ColumnaReal+Info[i ].Longitud:0);
                }
        }
}



#ifdef USARBUFFER
#define INCESTADO 1
#else
#define INCESTADO 0
#endif
void
LineaEstado(int Linea, int Columna,int Pagina)
{
        int p;
        gv_clear(0,64-4-INCESTADO*2,102,64-1);
        p=4*5;
        do {
                PonNumEstado(p,64-4-INCESTADO,Linea%10);
                Linea/=10;
                p-=5;
        } while(Linea>0);
        PonSepEstado(5*5,64-4-INCESTADO);
        p=9*5;
        do {
                PonNumEstado(p,64-4-INCESTADO,Columna%10);
                Columna/=10;
                p-=5;
        } while(Columna>0);
        p=19*5;
        do {
                PonNumEstado(p,64-4-INCESTADO,Pagina%10);
                Pagina/=10;
                p-=5;
        } while(Pagina>0);
        gv_reverse(0,64-4-INCESTADO*2,102-1,64-1);
}

long
LinCol2Pos(sLineaPantalla *Info, sPosicion *Pos)
{
        long pos;
        pos=Info[ Pos->NumLinea].PosIni;
        if(Pos->NumColumna>=0 && Info[ Pos->NumLinea].Suplidos==0) {
                if(Pos->NumColumna<Info[ Pos->NumLinea].Longitud)
                        pos+=Pos->NumColumna;
                else
                        pos+=Info[ Pos->NumLinea].Longitud;
        }
        return(pos);
}

void
ProcesaTecla(int Tecla,sMemoria *Mem, sLineaPantalla *Info, sPosicion *Pos)
{
        int Rep;
        int n=Tecla;
        while(n!=0) {
                Tecla=n;
                n=0;
                switch(Tecla) {
                case TECLA_ENTER:
                        Pos->BanderaEditando=1-Pos->BanderaEditando;
                        Pos->BanderaActualizar++;
                        if(Pos->BanderaEditando && Pos->BanderaMarcando) {
                                Pos->BanderaEditando=1-Pos->BanderaEditando;
                                Pos->BanderaMarcando=1-Pos->BanderaMarcando;
                                Pos->MarcadoFin=LinCol2Pos(Info,Pos);
                                if(Pos->MarcadoFin<=Pos->MarcadoIni)
                                        Pos->MarcadoIni=Pos->MarcadoFin=0;
                        } else if(Pos->BanderaEditando) {
                                Pos->DespCursor= ((Pos->NumLinea>=NUMLINEASVISEDIT)?(Pos->NumLinea-(NUMLINEASVISEDIT-1)):0);
                                Pos->LinMostradas=NUMLINEASVISEDIT;
                                if(Info[ Pos->NumLinea].Longitud<Pos->Columna) {
                                        if(( Info[ Pos->NumLinea].Columna+NUMCOLUMNAS)>Info[Pos->NumLinea ].Longitud) {
                                                Pos->Columna= Info[Pos->NumLinea].Columna+Info[Pos->NumLinea].Longitud;
                                        } else {
                                                long Longitud;
                                                Pos->Columna-=Pos->NumColumna;
                                                Pos->NumColumna= Pos->Columna-Info[0].Columna;
                                                Longitud= Info[Pos->NumLinea].Longitud;
                                                while(Pos->Columna>0 && Longitud<Pos->Columna) {
                                                        Info[ 0].Columna--;
                                                        Info[ 0].ColumnaReal--;
                                                        if(Info[ 0].Suplidos==0) {
                                                                Info[ 0].PosIni--;
                                                                Longitud++;
                                                        } else
                                                                Info[ 0].Suplidos--;
                                                }
                                        }
                                        Pos->NumColumna=Pos->Columna-Info[0].Columna;
                                }
                                if(Info[ Pos->NumLinea].Longitud==Pos->Columna) {
                                        char Letra=' ';
                                        if(MemoriaInserta(Mem,Info[ Pos->NumLinea].PosIni+Pos->NumColumna,&Letra,1)) {
                                                Pos->BanderaEspacioInsertado=1;
                                                Pos->BanderaActualizar++;
                                        }
                                }
                        } else {
                                if(Pos->BanderaEspacioInsertado) {
                                        Pos->BanderaEspacioInsertado=0;
                                        MemoriaBorra(Mem,Info[Pos->NumLinea ].PosIni+Pos->NumColumna,1);
                                        Pos->BanderaActualizar++;
                                }
                                Pos->DespCursor=0;
                                Pos->LinMostradas=NUMLINEAS;
                        }
                        break;
                case TECLA_ARR:
                        if(Pos->NumLinea>0)
                                Pos->Linea--;
                        else if((Info[0].PosIni+ Info[0].Suplidos-Info[0].Columna)>0) {
                                CalculaLineaAnterior(Mem,Info);
                                Pos->Linea=Info[0].Linea;
                                if(Pos->DespCursor>0)
                                        PintaPantalla(Mem,Info,0,Pos);
                                Pos->BanderaActualizar++;
                        }
                        Pos->NumLinea=Pos->Linea-Info[0].Linea;
                        if(Pos->BanderaEditando)
                                Pos->DespCursor= ((Pos->NumLinea>=NUMLINEASVISEDIT)?(Pos->NumLinea-(NUMLINEASVISEDIT-1)):0);
                        break;
                case TECLA_ABJ:
                        if((Pos->NumLinea+1)<NUMLINEASVIS && (Info[Pos->NumLinea].Banderas & lineaFin)==0) {
                                Pos->Linea++;
                        } else if((Info[Pos->NumLinea].Banderas & lineaFin)==0) {
                                Pos->Linea++;
                                Info[0 ].PosIni=Info[1].PosIni;
                                Info[0 ].Linea=Info[1].Linea;
                                Info[0 ].Columna=Info[1].Columna;
                                Info[0 ].LineaReal=Info[1].LineaReal;
                                Info[0 ].ColumnaReal=Info[1].ColumnaReal;
                                Info[0 ].Suplidos=Info[1].Suplidos;
                                Info[0 ].Longitud=Info[1].Longitud;
                                Info[0 ].Banderas=Info[1].Banderas;
                                if(Pos->DespCursor>0)
                                        PintaPantalla(Mem,Info,0,Pos);
                                Pos->BanderaActualizar++;
                        }
                        Pos->NumLinea=Pos->Linea-Info[0].Linea;
                        if(Pos->BanderaEditando)
                                Pos->DespCursor= ((Pos->NumLinea>=NUMLINEASVISEDIT)?(Pos->NumLinea-(NUMLINEASVISEDIT-1)):0);
                        break;
                case TECLA_IZQ:
                        if(Pos->NumColumna>0)
                                Pos->Columna--;
                        else if(Pos->Columna>0) {
                                Pos->Columna--;
                                Rep=5;
                                do {
                                        Info[0].Columna--;
                                        Info[0].ColumnaReal--;
                                        if(Info[0].Suplidos==0)
                                                Info[0].PosIni--;
                                        else
                                                Info[0].Suplidos--;
                                } while(Rep-- && Info[0].Columna>0);
                                Pos->BanderaActualizar++;
                        } else if(Info[Pos->NumLinea].ColumnaReal>0) {
                                if((MAXLINEA-1)> (Info[ 0].Columna+NUMCOLUMNAS-1)) {
                                        do {
                                                if(Info[ 0].Longitud>Info[0].Columna)
                                                        Info[ 0].PosIni++;
                                                else
                                                        Info[ 0].Suplidos++;
                                                Info[ 0].Columna++;
                                                Info[ 0].ColumnaReal++;
                                        } while((Info[ 0].Columna+NUMCOLUMNAS)<MAXLINEA);
                                }
                                Pos->Columna=MAXLINEA-1;
                                n=TECLA_ARR;
                                Pos->BanderaActualizar++;
                        }
                        Pos->NumColumna=Pos->Columna-Info[0].Columna;
                        break;
                case TECLA_DER:
                        if((Pos->NumColumna+1)<NUMCOLUMNAS)
                                Pos->Columna++;
                        else if((Pos->Columna+1)<MAXLINEA) {
                                Pos->Columna++;
                                Rep=5;
                                do {
                                        if(Info[0 ].Longitud>Info[0 ].Columna)
                                                Info[0 ].PosIni++;
                                        else
                                                Info[0 ].Suplidos++;
                                        Info[0 ].Columna++;
                                        Info[0 ].ColumnaReal++;
                                } while(Rep-- && (Info[0].Columna+NUMCOLUMNAS)<MAXLINEA);
                                Pos->BanderaActualizar++;
                        } else if((Info[ Pos->NumLinea].Banderas & lineaLarga)!=0) {
                                if(Info[ 0].Columna>0) {
                                        do {
                                                Info[ 0].Columna--;
                                                Info[ 0].ColumnaReal--;
                                                if(Info[ 0].Suplidos==0)
                                                        Info[ 0].PosIni--;
                                                else
                                                        Info[ 0].Suplidos--;
                                        } while(Info[ 0].Columna>0);
                                }
                                Pos->Columna=0;
                                n=TECLA_ABJ;
                                Pos->BanderaActualizar++;
                        }
                        Pos->NumColumna=Pos->Columna-Info[0].Columna;
                        break;
                }
        }
}

void
IrAPrincipio(sLineaPantalla *Info,sPosicion *Pos)
{
        Pos->NumLinea=Pos->NumColumna=Pos->Linea=Pos->Columna=0;
        Pos->BanderaEditando=0;
        Pos->BanderaMarcando=0;
        Pos->BanderaActualizar=1;
        Pos->BanderaCursor=0;
        Pos->BanderaEspacioInsertado=0;
        Pos->DespCursor=0;
        Info[0].PosIni= Info[0].Linea= Info[0].LineaReal= Info[0].Columna= Info[0].ColumnaReal= Info[0].Suplidos= Info[0].Longitud=0;
        Info[0].Banderas=lineaFin;
        if(Pos->ManejadorBlink!=-1) {
                blend(Pos->ManejadorBlink);
                Pos->ManejadorBlink=-1;
        }
}

#define TAMINFOTEMP 4

void
IrAPos(long PosPedida,sMemoria *Mem,sLineaPantalla *Info,sPosicion *Pos)
{
        int i;
        long xdesp,xinc;
        sLineaPantalla InfoTemp[TAMINFOTEMP];
        /* Inicializamos la posicin de inicio de bsqueda */
        if(Info[0].PosIni<=PosPedida) {
                copiamem((char *) InfoTemp,(char *) Info,sizeof(sLineaPantalla));
                if(InfoTemp[0].Suplidos>0) {
                        InfoTemp[0].Columna-=InfoTemp[0].Suplidos;
                        InfoTemp[0].ColumnaReal-=InfoTemp[0].Suplidos;
                        InfoTemp[0].Suplidos=0;
                }
                if(InfoTemp[0].Columna>0) {
                        InfoTemp[0].PosIni-=InfoTemp[0].Columna;
                        InfoTemp[0].ColumnaReal-=InfoTemp[0].Columna;
                        InfoTemp[0].Columna=0;
                }
        } else {
                InfoTemp[0].PosIni= InfoTemp[0].Linea= InfoTemp[0].LineaReal= InfoTemp[0].Columna= InfoTemp[0].ColumnaReal= InfoTemp[0].Suplidos= InfoTemp[0].Longitud=0;
                InfoTemp[0].Banderas=lineaFin;
        }
        /* Conseguimos que la informacin que necesitamos est disponible */
        while(1) {
                CalculaPantalla(Mem,InfoTemp,TAMINFOTEMP);
                if(PosPedida<InfoTemp[TAMINFOTEMP-1].PosIni || (InfoTemp[TAMINFOTEMP-1].Banderas&lineaFin))
                        break;
                copiamem((char *) InfoTemp,(char *) (InfoTemp+TAMINFOTEMP-1),sizeof(sLineaPantalla));
        }
        /* Ahora buscamos la posicin */
        for(i=0;i<TAMINFOTEMP;i++) {
                if(PosPedida>=InfoTemp[i].PosIni && (PosPedida-InfoTemp[i].PosIni)<InfoTemp[i].Longitud)
                        break;
        }
        if(i==TAMINFOTEMP)
                return;
        /* Ajustamos la estructura Info */
        copiamem((char *) Info,(char *) (InfoTemp+i),sizeof(sLineaPantalla));
        xdesp=PosPedida-Info[0].PosIni;
        if(xdesp>=NUMCOLUMNAS) {
                xinc=xdesp-NUMCOLUMNAS+1;
                Info[0].PosIni+=xinc;
                Info[0].Columna+=xinc;
                Info[0].ColumnaReal+=xinc;
        }
        /* Ajustamos la estructura Pos */
        Pos->NumLinea=0;
        Pos->NumColumna=PosPedida-Info[0].PosIni;
        Pos->Linea=Info[0].Linea;
        Pos->Columna=Info[0].Columna+Pos->NumColumna;
        /* Ultimos ajustes y volvemos felices de haberlo conseguido ;-) */
        Pos->BanderaActualizar++;
        return;
}


void
AjustaMarcado(int NumInsertados,sLineaPantalla *Info, sPosicion *Pos)
{
        long PosPantalla;
        char BanderaModi;
        PosPantalla=LinCol2Pos(Info,Pos);
        BanderaModi=0;
        for(;NumInsertados<0;NumInsertados++) {
                if(PosPantalla>Pos->MarcadoIni && PosPantalla<=Pos->MarcadoFin) {
                        Pos->MarcadoFin--;
                        BanderaModi=1;
                } else if(PosPantalla<=Pos->MarcadoIni) {
                        Pos->MarcadoIni--;
                        Pos->MarcadoFin--;
                        BanderaModi=1;
                }
                PosPantalla--;
        }
        for(;NumInsertados>0;NumInsertados--) {
                if(PosPantalla>Pos->MarcadoIni && PosPantalla<Pos->MarcadoFin) {
                        Pos->MarcadoFin++;
                        BanderaModi=1;
                } else if(PosPantalla<=Pos->MarcadoIni) {
                        Pos->MarcadoIni++;
                        Pos->MarcadoFin++;
                        BanderaModi=1;
                }
                PosPantalla++;
        }
        if(BanderaModi) {
                Pos->BanderaActualizar++;
                if(Pos->MarcadoFin<=Pos->MarcadoIni)
                        Pos->MarcadoIni=Pos->MarcadoFin=0;
        }
}

