/*
 * mastermind.c
 *
 * Prueba del simulador del API del onhand. Es el juego de Mastermind.
 *
 * Historia:
 *      01/02/01 Empiezo el programa.
 *      04/02/01 Termino con la funcionalidad bsica. Ya es jugable ;-)
 *      05/02/01 Cambio los dibujos por palitos con un nudo en el extremo.
 *               Hago que el elemento actual parpadee. Pongo que al ganar o
 *               perder recoloque lo de tuno para que se vea el turno actual.
 *      09/02/01 Cambio lo de que mientras se juega si das al filer se salga
 *               de Partida() y lo que hace es pedir confirmacin... para eso
 *               hago una funcin de EscribeMensaje(), que cuando se la llame
 *               con NULL restaura en la parte inferior lo que haba antes de
 *               poner el mensaje (y si no es NULL guarda la parte inferior
 *               antes de escribir...)..
 */

#include <lcdbios.h>
#include <rupsys.h>
#include <wbios.h>
#include <ruptool.h>
#include <psdos.h>
#include <stdlib.h>

#ifndef COPY_PUT
#define COPY_PUT 0
#define XOR_PUT  1
#define OR_PUT   2
#define AND_PUT  3
#endif

#ifndef KCOPY_PUT
#define KCOPY_PUT 0
#define KOR_PUT   1
#endif


void PonCadPeq(int x,int y, char *Cad);
void PonIntPeq(int x,int y, unsigned long Num);
int EsperaTecla(int Repeat);
int ProcesaPantalla(int Guardar);
void EscribeMensaje(char *Mensaje);
void Partida(void);

static char Fuente[128*8+4];
static char Pantalla[8*102+4];

#define NUMDIBUJOS 8
#define ALTURADIBUJO 5
#define ANCHURADIBUJO 5


static char Dibujos[8][9] = {
        {5,0,5,0, 0, 7,31, 7, 0}, /* arriba */
        {5,0,5,0,16, 8, 7, 7, 7}, /* arriba-derecha */
        {5,0,5,0, 4, 4,14,14,14}, /* derecha */
        {5,0,5,0, 1, 2,28,28,28}, /* abajo-derecha */
        {5,0,5,0, 0,28,31,28, 0}, /* abajo */
        {5,0,5,0,28,28,28, 2, 1}, /* abajo-izquierda */
        {5,0,5,0,14,14,14, 4, 4}, /* izquierda */
        {5,0,5,0, 7, 7, 7, 8,16}, /* arriba-izquierda */
};

static char CasillaVacia[62+4] = { 62,0,8,0,255,
                                1,85,41,85,41,85,41,85,41,85,
                                41,85,41,85,41,85,41,85,41,85,
                                41,85,41,85,41,85,41,85,41,85,
                                41,85,41,85,41,85,41,85,41,85,
                                41,85,41,85,41,85,41,85,41,85,
                                41,85,41,85,41,85,41,85,41,1, 255 };

#define PonLetraPeq(x,y,Letra) gv_aput(x,y,3,6,\
        (unsigned long) (Fuente+((unsigned short) Letra)*4),COPY_PUT)
#define PonDibujo(x,y,Num) gv_put(x,y,&(Dibujos[Num][0]),COPY_PUT)
#define TECLA_FILER 0x1
#define TECLA_MENU  0x2
#define TECLA_EL    0x4
#define TECLA_ENTER 0x8
#define TECLA_IZQ 0x10
#define TECLA_ARR 0x20
#define TECLA_DER 0x40
#define TECLA_ABJ 0x80

int
main(void)
{
        int i;
        char a,b,c,d,e,f;
        screen(1);
        cls(4);
#ifndef LINUX
        mpread(Fuente,"\\system\\mmp\\tinyfont.mmp");
#else
        mpread(Fuente,"tinyfont.mmp");
#endif
        for(i=0;i<NUMDIBUJOS;i++) {
                PonDibujo(i*((102-ANCHURADIBUJO)/NUMDIBUJOS)+
                        (102-(NUMDIBUJOS-1)*
                        ((102-ANCHURADIBUJO)/NUMDIBUJOS)-ANCHURADIBUJO)/2,
                        10,i);
        }
        gv_kput(10,26,"Mastermind",5,3,KCOPY_PUT);
        gv_kput(11,26,"Mastermind",5,3,KOR_PUT);
        gv_kput(10,27,"Mastermind",5,3,KOR_PUT);
        gv_kput(11,27,"Mastermind",5,3,KOR_PUT);
        EscribeMensaje("Pulse ENTER para continuar");
        while((EsperaTecla(0)&0xff)!=TECLA_ENTER)
                ;
        bi_tmread(&a,&b,&c);
        bi_dtread(&d,&e,&f);
        srand(a+b+c+d+e+f);
        EscribeMensaje(NULL);
        Partida();
        EscribeMensaje("   Pulse MENU para salir  ");
        while((EsperaTecla(0)&0xff)!=TECLA_MENU)
                ;
        return(0);
}

void
PonCadPeq(int x,int y, char *Cad)
{
        for(;*Cad!='\0';Cad++,x+=4)
                PonLetraPeq(x,y,*Cad);
}

void
PonIntPeq(int x,int y,unsigned long Num)
{
        long Num2=Num;
        int Desp=0;
        do {
                Desp++;
                Num2/=10;
        } while(Num2>0);
        Desp--;
        do {
                PonLetraPeq(x+Desp*4,y,(Num%10)+'0');
                Num/=10;
                Desp--;
        } while(Num>0);
}

void
PonHexPeq(int x,int y, long Num)
{
        int i;
        unsigned char Nibble;
        static char Valores[16]= {'0','1','2','3','4','5','6','7','8','9',
                                  'a','b','c','d','e','f'};
        PonLetraPeq(x,y,'0'),x+=4;
        PonLetraPeq(x,y,'x'),x+=4;
        for(i=8;i>=0;i--,x+=4) {
                Nibble=((Num>>(i*4)) & 0x0f);
                PonLetraPeq(x,y,Valores[Nibble]);
        }
}


int
EsperaTecla(int Repeat)
{
        int tecla,res;
        tecla=Keyin(Repeat,-1);
        if((res=EventCall(tecla))==-1 ||
            (res==1 && ProcesaPantalla(1) &&
            EventExec()==-1 && ProcesaPantalla(0))) {
                cls(4);
                gv_kput(0,0,"Saliendo...",0,0,COPY_PUT);
                dos_exit(0);
        } else if(res==1)
                ProcesaPantalla(0);
        return(tecla);
}

int
ProcesaPantalla(int Guardar)
{
        if(Guardar)
                gv_get(0,0,101,63,Pantalla);
        else
                gv_put(0,0,Pantalla,COPY_PUT);
        return(1);
}

void
EscribeMensaje(char *Mensaje)
{
        static char Guardado=0;
        static char ImagenGuardada[2*102+4];
        if(Mensaje!=NULL) {
                Guardado=1;
                gv_get(0,63-8,101,63,ImagenGuardada);
                gv_line(0,63-8,101,63-8,COPY_PUT,0xff);
                gv_clear(0,63-7,101,63);
                PonCadPeq(0,63-6,Mensaje);
        } else if(Guardado==1){
                Guardado=0;
                gv_put(0,63-8,ImagenGuardada,COPY_PUT);
        }
}



#define NUMHUECOS 5
#define MAXNUMINTENTOS 50
#define MAXUSADOSPANTALLA 8

#ifndef LINUX
#ifdef RAND_MAX
#undef RAND_MAX
#endif
#define RAND_MAX 65535
#endif

#define ANCHOIMAGENUSADO (101-3-37+1)
struct TipoUsado{
        char Num;
        char Clave[NUMHUECOS];
        char NumOk;
        char NumMov;
        char Imagen[ANCHOIMAGENUSADO+4];
} Usado[MAXNUMINTENTOS];

inline void
MuestraClave(int x,int y,char *Clave)
{
#if NUMHUECOS!=5
        int i;
#endif
        gv_square(x,y,x+(ANCHURADIBUJO+2)*NUMHUECOS+2,y+ALTURADIBUJO+3,
                COPY_PUT,0xffffffff);
#if NUMHUECOS!=5
        for(i=0;i<NUMHUECOS;i++)
                PonDibujo(x+2+i*(ANCHURADIBUJO+2),y+2,(int) (Clave[i]));
#else
        x+=2;
        y+=2;
        PonDibujo(x,y,(int) (Clave[0]));
        PonDibujo(x+1*(ANCHURADIBUJO+2),y,(int) (Clave[1]));
        PonDibujo(x+2*(ANCHURADIBUJO+2),y,(int) (Clave[2]));
        PonDibujo(x+3*(ANCHURADIBUJO+2),y,(int) (Clave[3]));
        PonDibujo(x+4*(ANCHURADIBUJO+2),y,(int) (Clave[4]));
#endif
}

void
Selecciona(int x, int y, int Pos)
{
        static int Manejador=-1;
        if(Manejador!=-1) {
                blend(Manejador);
                Manejador=-1;
        }
        if(Pos<0 || Pos>NUMHUECOS)
                return;
        else if(Pos==NUMHUECOS)
                Manejador=blink(100,0,101,63,0x60);
        else
                Manejador=blink(x+2+Pos*(ANCHURADIBUJO+2),y+2,x+2+Pos*(ANCHURADIBUJO+2)+4,y+2+4,0x60);
}


void
ImagenUsado(int PosNuevo,struct TipoUsado *Usado)
{
        int x,y;
        static char Nums[10]={' ','1','2','3','4','5','6','7','8','9'};
        x=37;
        y=PosNuevo*(ALTURADIBUJO+3);
        gv_clear(x,y,x+10+(ANCHURADIBUJO+2)*NUMHUECOS+2+14,y+ALTURADIBUJO+3);
        gv_square(x,y,x+10+(ANCHURADIBUJO+2)*NUMHUECOS+2+14,y+ALTURADIBUJO+3,
                COPY_PUT,0xffffffff);
        MuestraClave(x+10,y,Usado->Clave);
        PonLetraPeq(x+2,y+2,Nums[Usado->Num/10]);
        PonLetraPeq(x+2+4,y+2,'0'+(Usado->Num%10));
        PonLetraPeq(x+10+(ANCHURADIBUJO+2)*NUMHUECOS+2+14-4*3,y+2,
                (Usado->NumOk % 10) +'0');
        PonLetraPeq(x+10+(ANCHURADIBUJO+2)*NUMHUECOS+2+14-4*2,y+2,'/');
        PonLetraPeq(x+10+(ANCHURADIBUJO+2)*NUMHUECOS+2+14-4,y+2,
                (Usado->NumMov % 10) +'0');
        gv_get(x,y,x+ANCHOIMAGENUSADO-1,y+7,Usado->Imagen);
}

void
PanelUsados(int Num,int Max)
{
        int i,j;
        static RECT barra={37,0,101,63};
        /*lcdfreeze(1);*/
        pv_clear(&barra);
        for(j=0,i=Num;i<Max && j<MAXUSADOSPANTALLA;i++,j++)
                gv_put(37,j*(ALTURADIBUJO+3),Usado[i].Imagen,COPY_PUT);
        for(;j<MAXUSADOSPANTALLA;j++)
                gv_put(37,j*(ALTURADIBUJO+3),CasillaVacia,COPY_PUT);
        gv_square(37,j*(ALTURADIBUJO+3),101-3,64,COPY_PUT | 4,0xffffffff);
        if(Max!=0)
                gv_square(100,(Num<<6)/Max,101,(i<<6)/Max,COPY_PUT | 4,0xffffffff);
        else
                gv_square(100,0,101,63,COPY_PUT | 4,0xffffffff);
        /*lcdfreeze(0);*/
}

void
MuestraIntento(int x, int y, int Intento)
{
        static char Letra[2]={" "};
        Letra[0]=((Intento+1)<10)?'?':((Intento+1)/10)+'0';
        gv_kput(x,y,Letra,32,0,COPY_PUT);
        Letra[0]=((Intento+1)%10)+'0';
        gv_kput(x+8,y,Letra,32,0,COPY_PUT);
}

#define POSCLAVE 28

void
Partida(void)
{
        int i;
        int Intento;
        int PosIntentos;
        int NumIntentos;
        int Pos;
        int Tecla;
        char Clave[NUMHUECOS];
        char ClaveMovidos[NUMDIBUJOS];
        char Actual[NUMHUECOS];
        char NumExactos[NUMDIBUJOS];
        char NumMovidos[NUMDIBUJOS];
        char TotalMovidos,TotalExactos;
        cls(4);
        gv_kput(0,0,"Master",0,0,COPY_PUT);
        gv_kput(0,14,"  mind",0,0,COPY_PUT);
        PonCadPeq(0,POSCLAVE+10+4,"Turno:");
        memset(ClaveMovidos,0,NUMDIBUJOS);
        for(i=0;i<NUMHUECOS;i++) {
                Clave[i]=((unsigned int)rand())/(RAND_MAX/NUMDIBUJOS);
                Actual[i]=0;
                ClaveMovidos[((int)Clave[i])]++;
        }
        MuestraClave(0,POSCLAVE,Actual);
        memset(Usado,0,sizeof(struct TipoUsado)*MAXNUMINTENTOS);
        PosIntentos=NumIntentos=0;
        PanelUsados(PosIntentos,NumIntentos);
        for(Intento=0,Pos=0;;) {
                Selecciona(0,POSCLAVE,Pos);
                MuestraIntento(8,POSCLAVE+10+8+4,Intento);
                Tecla=(EsperaTecla(TECLA_ARR | TECLA_ABJ) & 0xff);
                if(Tecla==TECLA_MENU) {
                        EscribeMensaje("Salir ahora pulsando MENU");
                        if((EsperaTecla(TECLA_ARR | TECLA_ABJ) & 0xff)==TECLA_MENU)
                                dos_exit(0);
                        EscribeMensaje(NULL);
                }
                if(Pos==NUMHUECOS) {
                        if(Tecla==TECLA_ARR && PosIntentos>0) {
                                PosIntentos--;
                                PanelUsados(PosIntentos,Intento);
                                continue;
                        } else if(Tecla==TECLA_ABJ &&
                            PosIntentos+MAXUSADOSPANTALLA<Intento) {
                                PosIntentos++;
                                PanelUsados(PosIntentos,Intento);
                                continue;
                        }
                } else {
                        if(Tecla==TECLA_ARR) {
                                Actual[Pos]=((Actual[Pos]+1)%NUMDIBUJOS);
                                MuestraClave(0,POSCLAVE,Actual);
                                continue;
                        } else if(Tecla==TECLA_ABJ) {
                                Actual[Pos]=((Actual[Pos]+(NUMDIBUJOS-1))%
                                        NUMDIBUJOS);
                                MuestraClave(0,POSCLAVE,Actual);
                                continue;
                        }
                }
                if(Tecla==TECLA_DER && Pos<NUMHUECOS) {
                        Pos++;
                        continue;
                } else if(Tecla==TECLA_IZQ && Pos>0) {
                        Pos--;
                } else if(Tecla==TECLA_ENTER && Intento<MAXNUMINTENTOS) {
                        memset(NumExactos,0,NUMDIBUJOS);
                        memset(NumMovidos,0,NUMDIBUJOS);
                        TotalExactos=TotalMovidos=0;
                        for(i=0;i<NUMHUECOS;i++) {
                                if(Clave[i]==Actual[i]) {
                                        NumExactos[((int)Clave[i])]++;
                                        TotalExactos++;
                                }
                        }
                        for(i=0;i<NUMHUECOS;i++) {
                                if(Clave[i]!=Actual[i] &&
                                    ClaveMovidos[((int)Actual[i])]>0 &&
                                    (ClaveMovidos[((int)Actual[i])]-
                                    NumExactos[((int)Actual[i])])>
                                    NumMovidos[((int)Actual[i])]) {
                                        NumMovidos[((int)Actual[i])]++;
                                        TotalMovidos++;
                                }
                        }
                        Usado[Intento].Num=Intento+1;
                        memcpy(&(Usado[Intento].Clave[0]),Actual,NUMHUECOS);
                        Usado[Intento].NumOk=TotalExactos;
                        Usado[Intento].NumMov=TotalMovidos;
                        Intento++;
                        NumIntentos++;
                        if((NumIntentos-PosIntentos)>MAXUSADOSPANTALLA)
                                PosIntentos=NumIntentos-MAXUSADOSPANTALLA;
                        ImagenUsado(0,Usado+NumIntentos-1);
                        PanelUsados(PosIntentos,Intento);
                        if(TotalExactos==NUMHUECOS || NumIntentos==MAXNUMINTENTOS) {
                                Selecciona(0,POSCLAVE,-1);
                                gv_clear(0,0,36,POSCLAVE-1);
                                MuestraClave(0,POSCLAVE-8,Clave);
                                if(TotalExactos==NUMHUECOS)
                                        gv_kput(5,5,"Ok!",0,0,COPY_PUT);
                                else {
                                        gv_kput(3,5,"Ugh!",0,0,COPY_PUT);
                                }
                                gv_clear(0,POSCLAVE+9+1,36,63);
                                PonCadPeq(0,POSCLAVE+20,"Turno");
                                MuestraIntento(20,POSCLAVE+10+2,Intento-1);
                                return;
                        }
                }
        }
}
