/*
 * ohfuego.c
 *
 *  El juego de "fuego a discrecin" basado en las ideas que da el del libro de
 * Tim Hartnell "El libro gigante de los juegos para ZX Spectrum"
 *
 * Historia:
 *       1/01/02 Creacin. Hago los smbolos de ngulo y fuerza, que sea capaz de
 *               generar el mapa, que lo pinte, que ponga las puntuaciones, el
 *               nombre de jugador actual y el valor de ngulo y fuerza y que se
 *               pueda variar. Hago que dibuje un tanque y que use la tabla de
 *               senos. Empiezo hacer la rutina de disparo.
 *       2/01/02 Hago que el suelo ("Alturas") est en coordenadas absolutas (de
 *               pantalla) en vez de relativas al final de la pantalla. Termino
 *               la rutina de disparo. Pongo los datos de los jugadores en una
 *               estructura aparte y hago que todos utilicen esas estructuras
 *               (el tipo sJugador). Termino lo de los turnos, hago que se
 *               sumen puntuaciones cuando se acierta y que genere un nuevo
 *               mapa. Hago pequeos "hacks" para que parezca ms fluido. Hago
 *               que se acepten ngulos mayores a 90 (ahora se pueden poner
 *               ngulos comprendidos entre 0 y 180). Implemento lo del
 *               viento. Hago que desaparezca un poco de suelo en donde cae el
 *               proyectil. Gracias al viento ya no se acierta "casi siempre"
 *               con 68 y 640 de fuerza. Hecha la pantalla de final y la de
 *               bienvenida. Hago que para el jugador derecho las teclas de
 *               subir y bajar la fuerza estn "invertidas". Bueno, ya es
 *               jugable, aunque no muy adictivo, que digamos. Falta hacer
 *               que se pueda jugar contra el ordenador (y una manera de
 *               seleccionar 1/2 jugadores, viento si/no, erosin si/no, y
 *               nmero de "bazas para ganar). Tambin sera un detalle hacerlo
 *               dual espaol/ingls, tal y como est el editor "teclado".
 *
 * Autor: Dario Rodriguez dario@softhome.net
 * Este programa est sujeto a los trminos de la licencia GNU GPL.
 * This program is licensed under the terms of the GNU GPL.
 */

#include <lcdbios.h>
#include <rupsys.h>
#include <wbios.h>
#include <ruptool.h>
#include <psdos.h>
#include <stdlib.h>
#include <math.h>
#include "tinyfont.h"
#include "teclado.h"
#include "sintable.h"
#include "presentacion.h"
#include "final.h"

#ifndef LINUX
#ifdef RAND_MAX
#undef RAND_MAX
#endif
#define RAND_MAX 65535
#endif

static char Simbolos[2][10]={
        {6,0,6,0,48,40,44,58,33,32}, /* ngulo */
        {6,0,6,0,8,8,8,62,28,8},     /* fuerza */
};

static char Senial[7]={ 3,0,3,0,2,7,2};

enum enumSimbolos { simboloAngulo=0,simboloFuerza};

#define PonSimbolo(x,y,tipo) gv_put(x,y,&(Simbolos[((int) (tipo))][0]),XOR_PUT)
#define PonSenial(x,y) gv_put(x-1,y-1,Senial,XOR_PUT)
#define NumAleatorio(NumOpciones) ((unsigned int)rand())/(RAND_MAX/(NumOpciones))

typedef struct TipoJugador {
        signed char Inv;
        int x;
        int y;
        int Angulo;
        int Fuerza;
        int x1,y1,x2,y2;
        int origx,origy;
        int puntos;
        char *nombre;
} sJugador;

#define RELLENAJUGADORDATOS(ptr,a,b,c,d,e) ptr->Inv=(a),ptr->x=(b),ptr->y=(c), \
                                              ptr->Angulo=(d),ptr->Fuerza=(e)
#define RELLENAJUGADORBLOQUE(ptr,f,g,h,i) ptr->x1=(f),ptr->y1=(g),ptr->x2=(h),ptr->y2=(i)
#define RELLENAJUGADORORIG(ptr,j,k) ptr->origx=(j),ptr->origy=(k)


long seno(int angulo);
#define coseno(angulo) seno(900-(angulo))
void InitRand(void);
void PonNombreJugador(char *Jugador);
void PonEstado(int Angulo, int Fuerza);
void PonPuntuaciones(int Izq, int Der);
void GeneraPantalla(char *Alturas);
void GeneraJugadores(sJugador *Izquierda, sJugador *Derecha, char *Alturas);
void PintaAlturas(char *Alturas);
void PintaCanion(sJugador *Jugador);
void PintaSenial(sJugador *Jugador);
int HazDisparo(sJugador *Atacante, sJugador *Atacado, char *Alturas, int Viento);
void PintaViento(int Viento);
void Erosiona(char *Alturas, int px, int py, int valor);

int
main(void)
{
        char Alturas[102];
        char Pantalla[102*8+4];
        int Tecla,NuevoTurno,NuevoTerreno,Init;
        sJugador JugadorIzq,JugadorDer,*Jugador,*Oponente,*Temp;
        int Viento;
        screen(1);
        cls(4);
        TinyfontInit(); /* Aunque por ahora no la he usado... */
        /* Ponemos la presentacin */
        gv_put(0,0,presentacion,COPY_PUT);
        while((EsperaTecla(0)&(TECLA_MENU|TECLA_ENTER))==0)
                ;
        /* Aqu va el grueso del programa */
        InitRand();
        JugadorIzq.puntos=JugadorDer.puntos=0;
        JugadorIzq.nombre="Jugador1";
        JugadorDer.nombre="Jugador2";
        for(Jugador=&JugadorIzq,Oponente=&JugadorDer,NuevoTurno=1,NuevoTerreno=1,Init=0;NuevoTurno && JugadorIzq.puntos<3 && JugadorDer.puntos<3;Temp=Jugador,Jugador=Oponente,Oponente=Temp) {
                /* Generamos el terreno de juego */
                if(NuevoTerreno) {
                        if(!Init) {
                                gv_clear(1,63-12,100,62);
                                gv_square(0,63-13,101,63,COPY_PUT,0xffffffff);
                                gv_kput(13,63-11,"Generando mapa...",6,0,KCOPY_PUT);
                                Init=1;
                        }
                        GeneraPantalla(Alturas);
                        GeneraJugadores(&JugadorIzq,&JugadorDer,Alturas);
                        NuevoTerreno=0;
                }
                lcdfreeze(1);
                gv_clear(0,0,101,63);
                PintaAlturas(Alturas);
                PonPuntuaciones(JugadorIzq.puntos,JugadorDer.puntos);
                PonNombreJugador(Jugador->nombre);
                PintaCanion(Oponente);
                Viento=NumAleatorio(1000)*((NumAleatorio(100)<50)?1:-1);
                PintaViento(Viento);
                /* Ahora no hacemos un lcdfreeze(0) para evitar parpadeos */
                gv_get(0,0,101,63,Pantalla);
                /* Empezamos los turnos */
                for(Tecla=0,NuevoTurno=0;(Tecla&TECLA_MENU)==0;Tecla=(EsperaTecla(TECLA_ARR|TECLA_ABJ|TECLA_DER|TECLA_IZQ)&0xFF)) {
                        if((Tecla&(TECLA_DER|TECLA_IZQ)) && Jugador->Inv<0)
                                Tecla^=(TECLA_DER|TECLA_IZQ);
                        switch(Tecla) {
                                case TECLA_ARR:
                                        if(Jugador->Angulo<18000)
                                                Jugador->Angulo+=200;
                                        break;
                                case TECLA_ABJ:
                                        if(Jugador->Angulo>0)
                                                Jugador->Angulo-=200;
                                        break;
                                case TECLA_DER:
                                        if(Jugador->Fuerza<1000)
                                                Jugador->Fuerza+=20;
                                        break;
                                case TECLA_IZQ:
                                        if(Jugador->Fuerza>0)
                                                Jugador->Fuerza-=20;
                                        break;
                                case TECLA_ENTER:
                                        if(HazDisparo(Jugador,Oponente,Alturas,Viento)) {
                                                gv_reverse(0,0,101,64);
                                                Jugador->puntos++;
                                                NuevoTerreno=1;
                                        }
                                        NuevoTurno=1;
                                        break;
                        }
                        lcdfreeze(1);
                        gv_put(0,0,Pantalla,COPY_PUT);
                        PonEstado(Jugador->Angulo,Jugador->Fuerza);
                        PintaCanion(Jugador);
                        PintaSenial(Jugador);
                        lcdfreeze(0);
                        if(NuevoTurno)
                                break;
                }
        }
        /* Comprobamos si ha habido un ganador y en su caso lo decimos */
        if(Jugador->puntos<Oponente->puntos)
                Temp=Jugador,Jugador=Oponente,Oponente=Temp;
        if(Jugador->puntos>=3) {
                gv_put(0,0,final,COPY_PUT);
                gv_kput(14,54,"Ganador",6,0,KCOPY_PUT);
                gv_kput(48,54,Jugador->nombre,6,0,KCOPY_PUT);
                while((EsperaTecla(0)&0xFF)!=TECLA_MENU)
                        ;
        }
        /* Limpiamos y salimos */
        return(0);
}

long
seno(int angulo)
{
        /* El ngulo est en dcimas de grado */
        int multres=1;
        if(angulo<0) {
                angulo=-angulo;
                multres*=-1;
        }
        angulo%=3600;
        if(angulo>=1800) {
                angulo-=1800;
                multres*=-1;
        }
        if(angulo>=900)
                angulo=1800-angulo;
        return(multres*sintable[angulo]);
}

void
InitRand(void)
{
        char a,b,c,d,e,f;
        bi_tmread(&a,&b,&c);
        bi_dtread(&d,&e,&f);
        srand(a+b+c+d+e+f);
}

void
PonNombreJugador(char *Jugador)
{
        gv_clear(0,56,41,63);
        PonCadPeq(2,57,Jugador);
        gv_reverse(0,56,41,63);
}


void
PonEstado(int Angulo, int Fuerza)
{
        int MiAngulo;
        char Bandera;
        gv_clear(42,56,101,63);
        PonSimbolo(42,56,simboloAngulo);
        MiAngulo=(Angulo>=10000)?Angulo/10:Angulo;
        Bandera=(Angulo!=MiAngulo)?1:0;
        PonLetraPeq(50,57,(MiAngulo/1000)%10+'0');
        PonLetraPeq(50+4,57,(MiAngulo/100)%10+'0');
        gv_pset(58+Bandera*4,61,COPY_PUT|4);
        PonLetraPeq(60-Bandera*2,57,(MiAngulo/10)%10+'0');
        PonLetraPeq(60+4,57,(MiAngulo)%10+'0');
        PonSimbolo(76,56,simboloFuerza);
        PonLetraPeq(84,57,(Fuerza/1000)%10+'0');
        PonLetraPeq(84+4,57,(Fuerza/100)%10+'0');
        PonLetraPeq(84+8,57,(Fuerza/10)%10+'0');
        PonLetraPeq(84+12,57,(Fuerza)%10+'0');
        gv_reverse(42,56,101,63);
}

void
PonPuntuaciones(int Izq, int Der)
{
        char Letra[2]={" "};
        gv_clear(0,0,6,11);
        Letra[0]=(Izq%10)+'0';
        gv_kput(1,0,Letra,0,0,KCOPY_PUT);
        gv_clear(95,0,101,11);
        Letra[0]=(Der%10)+'0';
        gv_kput(96,0,Letra,0,0,KCOPY_PUT);
}

void
GeneraPantalla(char *Alturas)
{
        int x;
        int a1,a2;
        int ancho,alto,m1,m2;
        int nuevo;
        /* La pantalla consta de dos plataformas y una montaa senoidal en el centro */
        a1=a2=7;
        if(NumAleatorio(100)<50)
                a1=7+NumAleatorio(10);
        else
                a2=7+NumAleatorio(10);
        for(x=0;x<51;x++)
                Alturas[x]=a1;
        for(;x<102;x++)
                Alturas[x]=a2;
        ancho=20+NumAleatorio(30);
        alto=40+NumAleatorio(20);
        m1=51-ancho/2;
        m2=m1+ancho;
        for(x=m1;x<=m2;x++) {
                nuevo=(seno((x-m1)*1800L/ancho)*alto)/10000;
                if(Alturas[x]<nuevo)
                        Alturas[x]=nuevo;
        }
        /* Pasamos las alturas de relativas al fondo de pantalla a absolutas */
        for(x=0;x<102;x++)
                Alturas[x]=63-Alturas[x];

}

void
GeneraJugadores(sJugador *Izquierda, sJugador *Derecha, char *Alturas)
{
        char Lim;
        int px;
        /* Buscamos la posicin x jugador izquierdo */
        for(px=6,Lim=Alturas[0];Alturas[px]==Lim;px++)
                ;
        px-=6;
        if(px>0)
                px=NumAleatorio(px);
        /* Rellenamos las estructuras */
        RELLENAJUGADORDATOS(Izquierda,1,px,Alturas[0]-1,6800,640);
        RELLENAJUGADORBLOQUE(Izquierda,Izquierda->x,Izquierda->y-2-5,Izquierda->x+5,Izquierda->y);
        RELLENAJUGADORORIG(Izquierda,Izquierda->x+2,Izquierda->y-2);
        /* Buscamos la posicin x jugador derecho */
        for(px=101-6,Lim=Alturas[101];Alturas[px]==Lim;px--)
                ;
        px+=6;
        if(px<101)
                px=101-NumAleatorio(101-px);
        /* Rellenamos las estructuras */
        RELLENAJUGADORDATOS(Derecha,-1,px,Alturas[101]-1,6800,640);
        RELLENAJUGADORBLOQUE(Derecha,Derecha->x-5,Derecha->y-2-5,Derecha->x,Derecha->y);
        RELLENAJUGADORORIG(Derecha,Derecha->x-2,Derecha->y-2);
}



void
PintaAlturas(char *Alturas)
{
        int x;
        for(x=0;x<102;x++)
                gv_line(x,Alturas[x],x,63,COPY_PUT,0xff);
}

void
PintaCanion(sJugador *Jugador)
{
        int Angulo;
        gv_clear(Jugador->x1,Jugador->y1,Jugador->x2,Jugador->y2);
        gv_line(Jugador->x,Jugador->y,Jugador->x+2*Jugador->Inv,Jugador->y-2,COPY_PUT,0xFF);
        gv_line(Jugador->x+3*Jugador->Inv,Jugador->y-2,Jugador->x+5*Jugador->Inv,Jugador->y,COPY_PUT,0xFF);
        Angulo=Jugador->Angulo/10;
        gv_line(Jugador->origx,Jugador->origy,Jugador->origx+(coseno(Angulo)/(10000/5))*Jugador->Inv,Jugador->origy-(seno(Angulo)/(10000/5)),COPY_PUT,0xFF);
}

void
PintaSenial(sJugador *Jugador)
{
        int Angulo,Fuerza;
        Angulo=Jugador->Angulo/10;
        Fuerza=Jugador->Fuerza/20;
        PonSenial(Jugador->origx+Jugador->Inv*(coseno(Angulo)*Fuerza/10000),Jugador->origy-(seno(Angulo)*Fuerza/10000));
}

#ifdef LINUX
#include <sys/time.h>
#include <unistd.h>

volatile char Llego=0;

void
misleep_sighandler(int a)
{
        if(a==SIGVTALRM)
                Llego++;
}


void
misleep(long usec)
{
        static struct itimerval tiempo;
        void (*ptrantfn)(int);
        tiempo.it_interval.tv_sec=tiempo.it_value.tv_sec=0;
        tiempo.it_interval.tv_usec=tiempo.it_value.tv_usec=usec;
        ptrantfn=signal(SIGVTALRM,misleep_sighandler);
        setitimer(ITIMER_VIRTUAL,&tiempo,NULL);
        pause();
        signal(SIGVTALRM,ptrantfn);
        tiempo.it_interval.tv_sec=tiempo.it_value.tv_sec=0;
        tiempo.it_interval.tv_usec=tiempo.it_value.tv_usec=0;
        setitimer(ITIMER_VIRTUAL,&tiempo,NULL);
        return;
}
#endif

int
HazDisparo(sJugador *Atacante, sJugador *Atacado, char *Alturas, int Viento)
{
        int xini,yini;
        int px,py,ax,ay;
        int t;
        int fx,fy;
        int vez;
        int Angulo,Fuerza;
        char BanderaBlanco;
        xini=Atacante->origx;
        yini=Atacante->origy;
        Angulo=Atacante->Angulo/10;
        Fuerza=Atacante->Fuerza/20;
        Viento/=60;
        fx=Atacante->Inv*(coseno(Angulo)*Fuerza/10000);
        fy=seno(Angulo)*Fuerza/10000;
        for(BanderaBlanco=0,vez=0;vez<2;vez++) {
                for(t=0;t<500;t++) {
                        px=xini+fx*t/20+(t*t*Viento/20000);
                        py=yini-fy*t/20+t*t/100;
                        if(px>=0 && px<=101 && py>=0 && py<=63)
                                gv_pset(px,py,(1-vez)*4);
                        if(px>=Atacado->x1 && px<=Atacado->x2 && py>=Atacado->y1 && py<=Atacado->y2) {
                                gv_reverse(0,0,101,64);
                                BanderaBlanco=1;
                                gv_reverse(0,0,101,64);
                                break;
                        }
                        if(px<0 || px>101 || py>=Alturas[px] || (ax<(px-1) && py>=Alturas[px-1]))
                                break;
                        ax=px,ay=py;
#ifdef LINUX
                        if((t%8)==0)
                                misleep(1);
#endif
                }
        }
        Erosiona(Alturas,px-1,py,2);
        Erosiona(Alturas,px,py,4);
        Erosiona(Alturas,px+1,py,2);
        return(BanderaBlanco);
}

void
PintaViento(int Viento)
{
        int Longitud;
        int Inc;
        int Ini;
        Inc=(Viento>0)?1:(Viento<0)?-1:0;
        Ini=(Viento>0)?51:50;
        Longitud=Viento/25;
        gv_line(Ini,3,Ini+Longitud-Inc,3,COPY_PUT,0xFF);
        gv_line(Ini,5,Ini+Longitud-Inc,5,COPY_PUT,0xFF);
        gv_line(Ini+Longitud-Inc,2,Ini+Longitud+Inc,4,COPY_PUT,0xFF);
        gv_line(Ini+Longitud-Inc,6,Ini+Longitud+Inc,4,COPY_PUT,0xFF);
}

void
Erosiona(char *Alturas, int px, int py, int valor)
{
        if(px<0 || px>101)
                return;
        if(Alturas[px]>py)
                return;
        if((Alturas[px]+valor)>57)
                valor=57-Alturas[py];
        Alturas[px]+=valor;
}

