#!/bin/bash

make normalizer

if [ $# -ne 5 ]; then
  echo "Usage: $0 abortSec numWeather6 numForest3 numCensus6 numWeather5"
  echo
  echo all arguments are integers.
  exit
fi

timelimit=$1
numWeather6=$2
numForest3=$3
numCensus6=$4
numWeather5=$5

#./normalizer ~/OLAPData/OwenData/census.bin -dumpinfo
#

#calculate available memory (Linux specific)
memamt=`grep MemTotal /proc/meminfo | sed s/[^0-9]//g`
echo This machine seems to have $memamt kB RAM.


export FLAGS=" -memorylimit $memamt -fast -roundup_even" #-dumpinfo -stat -prescramble -roundup_sqrt
#./normalizer ~/OLAPData/OwenData/census.bin -dumpinfo -groupby 1,2,3,4,5,6 
#
# passing
#{1,0,1,0}
#{0,1,1,1}
#{1,1,1,0}
#{0,1,0,1}
#
# which can be normalized to
#{1,1,0,0}
#{0,1,1,1}
#{1,1,1,0}
#{0,0,1,1}
# and to 
#{1,1,0,0}
#{1,1,1,0}
#{0,1,1,1}
#{0,0,1,1}
# which appears to me to be optimal in a 2x2 chunk kind of way (two full chunks)
#
#./normalizer -toy 1 0 1 0 / 0 1 1 1 / 1 1 1 0 / 0 1 0 1 //


datasets[1]=weather ;groupbys[1]=6of18 ;  numcubes[1]=$numWeather6
datasets[2]=forest ; groupbys[2]=3of11 ;  numcubes[2]=$numForest3
datasets[3]=census ; groupbys[3]=6of18 ;  numcubes[3]=$numCensus6

datasets[4]=weather ; groupbys[4]=5of18 ; numcubes[4]=$numWeather5

datadir=~/OLAPData/OwenData

for i in 1 2 3 4; do 
    typeset -i cubectr=0    
    for gbcode in `cat $datadir/${groupbys[$i]}` ; do
        if [ $cubectr -ge ${numcubes[$i]} ]; then
	   break
	fi
	commnd="./normalizer $datadir/${datasets[$i]}.bin -groupbits $gbcode $FLAGS"
	echo 
	echo Test run at `date`: $commnd
	# the ulimit SHOULD abort the command after $timelimit/3600 hours, if it hasn't finished then
	( ulimit -t $timelimit ; eval time $commnd  )  && cubectr=$cubectr+1    # count successes only
    done
done
    
