#!/bin/bash

gnuplot <<'EOF'
  set yrange [0.85:1.3]
	set xrange [0:0.9]
	set xlabel "Independence Sum"
	set ylabel "Ratio FS/IM"
	set xtics ("0.1" 0.1, "0.2" 0.2, "0.3" 0.3, "0.4" 0.4, "0.5" 0.5, "0.6" 0.6, "0.7" 0.7, "0.8" 0.8, "0.9" 0.9, "1.0" 1.0)
  set x2tics ("0.59" 0.59, "0.72" 0.72)
	set y2tics ("FS=IM" 1.0, "" 1.05) 
	set grid x2tics y2tics
	plot "indep-forest.bin.dat" title "Forest" with points ,\
    "indep-census.bin.dat" title "Census" with points,\
    "indep-weather.bin.dat" title "Weather" with points
  set terminal postscript eps
  set output "indepsum-vs-solratio.eps"
  replot
  set output "foo"
  pause 10
EOF
cp indepsum-vs-solratio.eps ../../LaTeX/DOLAP03
# echo "You probably need to move the .eps file I just built"
