/* simple opendir() etc. for Win32 */

#include <string.h>
#include <ctype.h>
#define strcmp stricmp
#include <stdlib.h>

#include <io.h>
#include <errno.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <ndir.h>

DIR *opendir(const char *name)
{
	char localname[_MAX_NAME];
	DIR *rval = malloc(sizeof(DIR));
	strcpy(localname,name);
        strcat(localname,"\\*.*");
	if (rval == NULL)
                return NULL;
        if ((rval->handle = _findfirst(localname,&rval->dta)) == -1)
        	return free(rval), NULL;
	rval->first = 1;
	return rval;
}

int closedir(DIR *x)
{
  	_findclose(x->handle);
	free(x);
	return 0;
}

struct direct *readdir(DIR *thisdir)
{
        if(!thisdir->first)
	{
                if(_findnext(thisdir->handle, &thisdir->dta) != 0)
			return NULL;
	} else
                thisdir->first = 0;
        strcpy(thisdir->current.d_name,thisdir->dta.name);
	thisdir->current.d_namlen = strlen(thisdir->current.d_name);
	/* thisdir->current.d_name[13] = '\0'; */
	return &thisdir->current;
}

#undef rename
int
sys_rename (const char * oldname, const char * newname)
{
  int  result;
  char temp[_MAX_NAME];

  /* MoveFile on Win95 doesn't correctly change the short file name
     alias in a number of circumstances (it is not easy to predict when
     just by looking at oldname and newname, unfortunately).  In these
     cases, renaming through a temporary name avoids the problem.

     A second problem on Win95 is that renaming through a temp name when
     newname is uppercase fails (the final long name ends up in
     lowercase, although the short alias might be uppercase) UNLESS the
     long temp name is not 8.3.

     So, on Win95 we always rename through a temp name, and we make sure
     the temp name has a long extension to ensure correct renaming.  */

  if (GetVersion () & 0x80000000)
    {
      char * o;
      char * p;
      int    i = 0;

      if ((o = strrchr (oldname, '/')) || (o = strrchr (oldname, '\\')))
	o++;
      else
	o = oldname;

      strcpy (temp, oldname);
      if ((p = strrchr (temp, '/')) || (p = strrchr (temp, '\\')))
	p++;
      else
	p = temp;

      do
	{
	  /* Force temp name to require a manufactured 8.3 alias - this
	     seems to make the second rename work properly.  */
	  sprintf (p, ".%s.%u", o, i);
	  i++;
	}
      /* This loop must surely terminate!  */
      while (rename (oldname, temp) < 0 && errno == EEXIST);
      if (errno != EEXIST)
	return -1;

      oldname = temp;
    }

  /* Emulate Unix behaviour - newname is deleted if it already exists
     (at least if it is a file; don't do this for directories).

     Since we mustn't do this if we are just changing the case of the
     file name (we would end up deleting the file we are trying to
     rename!), we let rename detect if the destination file already
     exists - that way we avoid the possible pitfalls of trying to
     determine ourselves whether two names really refer to the same
     file, which is not always possible in the general case.  (Consider
     all the permutations of shared or subst'd drives, etc.)  */

  result = rename (oldname, newname);

  if (result < 0
      && errno == EEXIST
      && _chmod (newname, 0666) == 0
      && _unlink (newname) == 0)
    result = rename (oldname, newname);

  return result;
}

int
unlink (const char * path)
{
  _chmod (path, 0666);
  return _unlink (path);
}

#ifdef TEST
void main(void)
{
  DIR *d = opendir(".");
  struct direct *f;
  
  if (d)
    while ((f = readdir(d)) != NULL)
      printf(">%s<\n", f->d_name);
}
#endif
