package jacob.tool;

import java.util.*;

import jacob.*;

import ccl.awt.*;
import ccl.util.*;

import javancss.*;

/**
 * Example wrapper class for JavaNCSS.
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: JavancssAll.java,v 1.2 1999/02/22 11:44:14 clemens Exp clemens $
 * @see JavancssSelected
 */
public class JavancssAll extends JavancssSelected {
    /**
     * Communicates with JavancssSelected via _vAllClasses.
     * This method gets invoked from JavancssSelected.run().
     */
    protected void _setAllClasses() {
        // get Vector with source and compile classen
        Package pckMain = _pJacobInterface.getMainPackage();
        /*_vAllClasses = pckMain.getAllClassPathNames(true, false);
        Transformer pTransformer = new Transformer() {
            public Object transform(Object pObject_) {
                return(((String)pObject_) + ".java");
            }
        };
        _vAllClasses = Util.map(_vAllClasses, pTransformer);*/
        _vAllClasses = new Vector();
        Enumeration enJavaClasses = pckMain.getClassElements();
        while ( enJavaClasses.hasMoreElements() ) {
            JavaClass jclNext = (JavaClass)enJavaClasses.nextElement();
            String sFullName = jclNext.getSourceFullFileName();
            _vAllClasses.addElement( sFullName );
        }        
    }
    
    public JavancssAll() {
        super();
    }
}
