/* Hauptprogramm HXC
Berechnung von austauschbaren H-Ionen aus dem 1-molaren NH4Cl-Extrakt

Es wird der Anteil der pH-Absenkung, der auf Hydrolyse von Aluminium-Ionen
zurckgefhrt werden kann, bercksichtigt. Siehe auch Kommentare in akeh.c.

2 Argumente in der Aufrufzeile:
  1.) Eingabefile
  2.) Ausgabefile
   
Struktur des Eingabefiles: 
   6 Spalten, durch Leerzeichen getrennt, Dezimaltrennzeichen "."
      1. Spalte: Probenbezeichnung (maximal 12 Zeichen, ohne Leerzeichen)
      2. Spalte: pH des Extraktionsmittels
      3. Spalte: pH des Extrakts
      4. Spalte: Al im Extrakt [mol/l]
      5. Spalte: Extraktvolumen [l]
      6. Spalte: Einwaage [g]

Struktur des Ausgabefiles:
    2 Spalten, durch Leerzeichen getrennt, Dezimaltrennzeichen "."
      1. Spalte: Probenbezeichnung
      2. Spalte: austauschbare H-Ionen [mmol/kg]
                 Sonderfall : "NA" = "Wert konnte nicht berechnet werden." 
                 negative Werte: sind wie Null anzusehen
*/

#include <stdio.h>
#include <unistd.h>


#define IONENSTAERKE 1
int akeh(double ph0, double ph1, double ctal, double str, double* exh);

int main(int narg, char *arg[]){
  int i,rc,lin;
  float ph1,ph2,cal,vol,ein;
  double exh;
  char kenn[13];
  FILE * input;
  FILE * output;

  if(narg<3){
    fprintf(stderr,"HXC: Aufruf mit 2 Argumenten:\n");
    fprintf(stderr,"        1.: Inputfile\n");
    fprintf(stderr,"        2.: Outputfile\n");
    return 1 ;
  }

  input = fopen(arg[1],"r");
  if(input == NULL){
    fprintf(stderr,"HXC: Inputfile nicht gefunden.\n");
    return 99; 
  }
  output = fopen(arg[2],"w");
  if(access(arg[2],W_OK) == -1){
    fprintf(stderr,"HXC: Outputfile kann nicht angelegt werden.\n");
    return 99; 
  }

  for(lin=1;;lin++){
    rc = fscanf(input," %12s %g %g %g %g %g ",kenn,&ph1,&ph2,&cal,&vol,&ein);
    if(rc == EOF){
      break;
    }
    if(rc != 6){
      fprintf(stderr,"HXC: Fehler in Input-File (Zeile %d)\n",lin);
      return 99;
    }
    rc = akeh(ph1,ph2,cal,IONENSTAERKE,&exh);
    if(rc != 0){
      fprintf(output,"%12s NA\n",kenn);
    }
    else{    
      fprintf(output,"%12s %g\n",kenn,exh);
    }
  }
  printf("HXC: %d Flle bearbeitet.\n",lin);
  printf("HXC: Ergebnisse in %s.\n",arg[2]);

}

/*.....................................................................*/
