DROP TABLE POLICY_CHILDREN IF EXISTS;
DROP TABLE RESOURCE_PERMISSION_DELEGATION IF EXISTS;

ALTER TABLE POLICY ADD COLUMN REALM_ID INTEGER DEFAULT 1;

ALTER TABLE POLICY DROP COLUMN PARENT_RESOURCE_PERMISSION;
ALTER TABLE RESOURCE_PERMISSION DROP COLUMN PARENT_RESOURCE_PERMISSION;
ALTER TABLE RESOURCE_PERMISSION DROP COLUMN ONWARD_DELEGATION;

ALTER TABLE RESOURCE_PERMISSION ADD COLUMN REALM_ID INTEGER DEFAULT 1;

ALTER TABLE POLICY_RESOURCE_RELATIONSHIP ADD COLUMN REALM_ID INTEGER DEFAULT 1;

CREATE CACHED TABLE POLICY_RESOURCE_RELATIONSHIP_TMP
(
   RESOURCE_ID INTEGER not null,
   POLICY_ID INTEGER not null,
   RESOURCE_TYPE INTEGER not null,
   SEQUENCE INTEGER,
   REALM_ID INTEGER,
   CONSTRAINT POLICY_RESOURCE_RELATIONSHIP_TMP_PK PRIMARY KEY (RESOURCE_ID,RESOURCE_TYPE,POLICY_ID,REALM_ID)
);

INSERT INTO POLICY_RESOURCE_RELATIONSHIP_TMP (RESOURCE_ID,POLICY_ID,RESOURCE_TYPE,SEQUENCE,REALM_ID) SELECT * FROM POLICY_RESOURCE_RELATIONSHIP;

DROP TABLE POLICY_RESOURCE_RELATIONSHIP;

CREATE CACHED TABLE POLICY_RESOURCE_RELATIONSHIP
(
   RESOURCE_ID INTEGER not null,
   POLICY_ID INTEGER not null,
   RESOURCE_TYPE INTEGER not null,
   SEQUENCE INTEGER,
   REALM_ID INTEGER,
   CONSTRAINT POLICY_RESOURCE_RELATIONSHIP_PK PRIMARY KEY (RESOURCE_ID,RESOURCE_TYPE,POLICY_ID,REALM_ID)
);

INSERT INTO POLICY_RESOURCE_RELATIONSHIP (RESOURCE_ID,POLICY_ID,RESOURCE_TYPE,SEQUENCE,REALM_ID) SELECT * FROM POLICY_RESOURCE_RELATIONSHIP_TMP;

DROP TABLE POLICY_RESOURCE_RELATIONSHIP_TMP;

