/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  parallel_monitor_ph.lex
Dates:		  3 Jun 2004
Purpose:	  parse arbitration contruct
Output:       Err_no_syntax_code_present
              Err_comment_overrun
              Err_duplicate_directive 
              Err_no_close_brace
              Err_no_directive_present
              Err_not_arbitration_code_kw
	      Err_no_pp_ctrl_mntor_kw_present
*/

/@
@i "/usr/local/yacco2/copyright.w"
@** |parallel_monitor_ph| thread.\fbreak
Parse arbitration contruct.
Typically there is no arbitration to be done but
when 2 or more threads of subset / superset
context are deployed
deplomacy is required.
This thread is a ``chained procedure call''.
\fbreak
Example of a parallel-control-monitor construct to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/ppmntr.txt"}
@/
fsm	
(fsm-id "parallel_monitor_ph.lex"
,fsm-filename parallel_monitor_ph
,fsm-namespace NS_parallel_monitor_ph
,fsm-class Cparallel_monitor_ph{
  user-prefix-declaration
    using namespace NS_yacco2_terminals;
#include "lint_balls.h"
#include "eol.h"
#include "c_comments.h"
#include "cweb_or_c_k.h"
#include "identifier.h"
#include "c_string.h"
#include "o2_sdc.h"
  ***
  user-declaration
    public:
    void add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc);
    T_parallel_monitor_phrase* parallel_monitor_phrase_;
  ***
  constructor
    parallel_monitor_phrase_ = 0;
  ***
  user-implementation
    void Cparallel_monitor_ph::
    add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc){
      using namespace NS_yacco2_T_enum;
      using namespace NS_yacco2_terminals;
      yacco2::INT eid = Dir->enumerated_id__;
      switch (eid){
		case T_Enum::T_T_arbitrator_code_: {
		  T_arbitrator_code* k = (T_arbitrator_code*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		default: {
          CAbs_lr1_sym* sym = new Err_improper_directive;
          sym->set_rc(*Dir,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true);
   		}      
      }    
    }
  ***
  op
    if(parallel_monitor_phrase_ != 0){
      delete parallel_monitor_phrase_;
      parallel_monitor_phrase_ = 0;
    }
    parallel_monitor_phrase_ = new T_parallel_monitor_phrase;
    parallel_monitor_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*parallel_monitor_phrase_);
    parallel_monitor_phrase_->phrase_tree(t);
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "false"
,fsm-comments "Parse a rule's arbitration code: \n into the valley of someone's dementia...")
parallel-parser
(	
  parallel-thread-function
    TH_parallel_monitor_ph
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rparallel_monitor_phrase  (){
  -> "#parallel-control-monitor"
  Rlint
       Ropen_brace Rlint
         Rdirective_phrase
       Rclose_brace Rlint
         {
    op
      Cparallel_monitor_ph* fsm = 
	(Cparallel_monitor_ph*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->parallel_monitor_phrase_);
      fsm->parallel_monitor_phrase_ = 0;
    ***
    }	
}


Ropen_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_brace;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "{"
}

Rclose_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
       RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rdirective_phrase  (){ 
  ->  Rlint Rparallel_directive_cweb_k Rlint Rdirective Rsyntax_code Rlint {
    op
      AST* cwebt = sf->p2__->cweb_t_;
      Rdirective* dir = sf->p4__;
      Rsyntax_code* sdc = sf->p5__;
      if(cwebt != 0)
        sdc->syntax_code_->add_cweb_marker(cwebt);
      Cparallel_monitor_ph* fsm = 
	(Cparallel_monitor_ph*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rdirective  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  op
    if(directive_ == 0) return;
    Cparallel_monitor_ph* fsm = (Cparallel_monitor_ph*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* result = 
	fsm->parallel_monitor_phrase_->add_directive_to_mntr(directive_,rule_info__.parser__);
    if(result == 0) return;// ok added
    directive_->set_auto_delete(true);//dup: delete when popped from stack
    RSVP(result);
    rule_info__.parser__->set_stop_parse(true);
  ***
 } 
){ 
  ->  ||| "#arbitrator-code" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL { 
    op
     directive_ = 0;
     CAbs_lr1_sym* sym = new Err_not_arbitration_code_kw;
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_no_directive_present;
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
    ***
    } 
}

Rsyntax_code  (
lhs {
  user-declaration
    T_syntax_code* syntax_code_;
  ***
 } 
){
  -> ||| "syntax-code" NS_o2_sdc::TH_o2_sdc {
      op
        syntax_code_ = sf->p2__;
      ***
      }
  -> ||| "no syntax-code present" NULL {// allow no syntax code 
      op
        syntax_code_ = 0;
        sf->p2__->set_auto_delete(true);
      ***
      }
  -> ||| |?| NULL { // catcher in the Rye? These are errors
      op
        syntax_code_ = 0;
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}

Rparallel_directive_cweb_k  (
lhs {
	user-declaration
	  AST* cweb_t_;
	***
	constructor
	  cweb_t_ = 0;
	***
	}
){
  -> 
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
        AST::set_content(*cweb_t_,*cw);
        AST::join_pts(*cweb_t_,*cwebk_t_);
	***
	}
  ->  ||| |?| NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
}
}// end of rules
