/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:       int_no.lex
Dates:      3-mar-2003
Purpose:	recognize long integer
Returned:	T_int_no
        	Err_bad_int_no
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |int_no| thread.\fbreak
Recognize long integer. 
Does a conversion for validity only.
Data returned in text form.
@/
fsm	
(fsm-id "int_no.lex",fsm-filename int_no,fsm-namespace NS_int_no
,fsm-class Cint_no{
  user-prefix-declaration
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
  ***
   user-declaration
    public: 
    char ddd_[1024*32];
    int ddd_idx_;
   ***
  constructor
    ddd_idx_ = 0;
    ddd_[ddd_idx_] = 0;
 ***
  op
    ddd_idx_ = 0;
    ddd_[ddd_idx_] = 0;
  ***
}
,fsm-version "1.0",fsm-date "3 mar 2003",fsm-debug "false"
,fsm-comments "Integer number lexer.")
parallel-parser	
(	
  parallel-thread-function
    TH_int_no
  ***
  parallel-la-boundary
    eolr 
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rint_no (){
  ->  Rdec_no |.| {
    op
	Cint_no* fsm = (Cint_no*)rule_info__.parser__->fsm_tbl__;
	long lno = strtol(fsm->ddd_,0,10);
 if (errno == ERANGE){
	  Err_bad_int_no* sym = new Err_bad_int_no;
	  sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	  RSVP(sym);
	}else{
	  T_int_no* sym = new T_int_no(lno);
	  sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	  RSVP(sym);
	}
    ***
    }
}

Rdec_no (){	
  ->  Rdigit
  ->  Rdec_no Rdigit
}

Rdigit (
lhs{
   op
    Cint_no* fsm = (Cint_no*)rule_info__.parser__->fsm_tbl__;
    size_t pos = rule_info__.parser__->parse_stack__.top_sub__ - 1;
    CAbs_lr1_sym* sym = rule_info__.parser__->get_spec_stack_token(pos);
    fsm->ddd_[fsm->ddd_idx_] = sym->id__[0];
    ++fsm->ddd_idx_;
    fsm->ddd_[fsm->ddd_idx_] = 0;
  ***
  }
){
  -> 0 -> 1 -> 2 -> 3 -> 4 -> 5 -> 6 -> 7 -> 8 -> 9	
}
}// end of rules
