# (install)

alpha::mode Java 1.12 javaMenu {*.java *.j} {
    javaMenu electricBraces electricSemicolon electricReturn
} {
    addMenu javaMenu "140" Java
    alpha::package require AlphaTcl 7.2.1b5
}

array set javacompilerAppSignatures {
    Suncompiler Javc
}
array set javacompilerAppScripts {
    Suncompiler {
	{sendOpenEvent -n $quotedSig $filename}
    }
}

# required for use of C++::correctIndentation
newPref f useFasterButWorseIndentation 0 Java
newPref v indentComments "code 0" Java "" indentationTypes varitem
newPref v indentC++Comments "code 0" Java "" indentationTypes varitem

newPref	f elecColon {1} Java
newPref	v leftFillColumn {3} Java
newPref	v prefixString {//} Java 
newPref	f wordWrap {0} Java
newPref	v funcExpr {^[^ \t\(#\r/@].*\(.*\)$} Java
newPref	v parseExpr {\b([_:\w]+)\s*\(} Java
newPref v wordBreak {[\w_]+} Java
newPref v wordBreakPreface {[^_\w]} Java
newPref	f autoMark	0 Java
# To synchronise Alpha's value for your java class path with the current
# value in your system environment each time Alpha starts up, click this 
# box||To let Alpha maintain its own value for your classpath independent
# of the systemwide value, click this box.
newPref	f classPathSynchroniseWithEnv	1 Java
# Your Java class path.
newPref v classSearchPath "" Java
newPref	v stringColor	green Java
newPref	v commentColor	red	 Java
newPref	v keywordColor	blue Java
newPref v funcColor yellow Java
newPref f includeMenu 1 Java
newPref variable showJavacompilerLog 1 Java "" \
  [list "Never" "Only after error" "Always"] index

ensureset Java_projectStore(placeClassesHere) ""
ensureset Java_projectStore(compileFromThisFolder) ""
ensureset JavaProjects(Usual) [array get Java_projectStore]
ensureset JavaProject Usual

regModeKeywords	 -e {//} -b {/*} {*/}	-c $JavamodeVars(commentColor) \
		 -f $JavamodeVars(funcColor) -k $JavamodeVars(keywordColor) \
		 -s $JavamodeVars(stringColor) Java {
    abstract boolean break byte byvalue case catch char class const 
    continue default do double else extends false final finally float for 
    goto if implements import instanceof int interface long native new 
    null package private protected public return short static super switch 
    synchronized this throw throws transient true try void while future 
    generic inner outer operator rest var volatile
}
regModeKeywords -a -k color_9 Java { Object String }

proc javaMenu {} {}

if {$JavamodeVars(classPathSynchroniseWithEnv)} {
    if {[info exists env(CLASSPATH)]} {
	set JavamodeVars(classSearchPath) [split $env(CLASSPATH) ";"]
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "menu::buildjavaMenu" --
 # 
 #  Use a build proc so we can add things on the fly.
 # -------------------------------------------------------------------------
 ##
proc Java::buildMenu {} {
    global javaMenu
    set ma {
	"/S<U<OswitchToCompiler"
	"(-"
	"/K<U<OcompileFile"
	"(-"
	"/V<U<OviewApplet"
	"//<BnewJavadocComment"
	"editProjects"
    }
    return [list build $ma Java::MenuProc "" $javaMenu]
}
menu::buildProc javaMenu Java::buildMenu

set Java::commentCharacters(Paragraph) [list "/**" " */" " * "]

# If this package exists, add the headers menu
if {[alpha::package exists searchPaths]} {
    menu::buildProc javaSearchPath {mode::rebuildSearchPathMenu javaSearchPath}
    menu::insert javaMenu submenu end javaSearchPath
}

menu::buildSome javaMenu

proc Java::MenuProc {menu item} {
    eval Java::$item
}

proc Java::electricLeft {args} {
    uplevel 1 C++::electricLeft $args
}

proc Java::correctIndentation {args} {
    uplevel 1 C++::correctIndentation $args
}
proc Java::indentLine {args} {
    uplevel 1 C++::indentLine $args
}

proc Java::newJavadocComment {} {
    elec::Insertion "/**\r * comment body\r */\r"
}

proc Java::editProjects {} {
    dialog::editOneOfMany "Edit or create a new Java project" \
      JavaProject JavaProjects Java_projectStore project
}

# Launches Java Compiler
proc Java::switchToCompiler {} {
    global javacompilerSig
    app::launchAnyOfThese Javc javacompilerSig "Please locate the Java compiler:"
    switchTo '$javacompilerSig'
}

# Sends the window to the compiler.
proc Java::compileFile {} {
    global showJavacompilerLog classSearchPath JavaProjects
    set path [stripNameCount [win::Current]]

    if {[winDirty]} {
	case [askyesno -c "Save '[file tail $path]'?"] in {
	    "yes" {
		save
		# Get path again, in case it was Untitled before.
		set path [stripNameCount [win::Current]]
	    }
	    "no" {
		if {![file exists $path]} {
		    alertnote "Can't send window to compiler."
		    return
		}
	    }
	    "cancel" {return}
	}
    }
    # Experimental code which will allow you to compile into a hierarchy
    # using javac's ability to find related class files in multiple packages
    # automatically.  This is needed for any project which contains files
    # in more than one directory.

    # Of course we only want to do this if the current file is in the 
    # compilation path given.  Else we'll assume it's a standalone file.
    set compileFrom ""
    set placeClasses ""

    # We check automatically whether a given file is in a project
    # by examining whether the path matches.
    foreach proj [array names JavaProjects] {
	array set tmp $JavaProjects($proj)
	if {$tmp(compileFromThisFolder) != "" \
	  && [string first $tmp(compileFromThisFolder) $path] == 0} {
	    set compileFrom $tmp(compileFromThisFolder)
	    set placeClasses $tmp(placeClassesHere)
	    break
	}
    }
    
    if {$placeClasses != ""} {
	app::runScript javacompiler "Java compiler" \
	  $path 0 $showJavacompilerLog \
	  "-d $placeClasses -classpath [join $classSearchPath {;}]" \
	  $compileFrom
    } else {
	app::runScript javacompiler "Java compiler" \
	  $path 0 $showJavacompilerLog "-classpath [join $classSearchPath {;}]" \
	  $compileFrom
    }
}

# Opens a HTML file corresponding to a java file in the Applet Viewer.
# If there is a file some_applet.html in the same folder as some_applet.java
# it is sent. Otherwise the user is asked to select a HTML file.
# This file is remembered throughout this session with Alpha.
proc Java::viewApplet {} {
    global javaAppletFile javaviewerSig
    set name [stripNameCount [win::Current]]
    set dir [file dirname $name]
    set root [file rootname [file tail $name]]
    set path [file join $dir $root.html]
    if {[info exists javaAppletFile($name)] && [file exists $javaAppletFile($name)]} {
	set path $javaAppletFile($name)
    } elseif {![file exists $path]} {
	set path [getfile "Please locate HTML file for applet."]
	set javaAppletFile($name) $path
    }
    app::launchAnyOfThese [list AppV WARZ] javaviewerSig "Please locate the Applet viewer:"
    sendOpenEvent noReply '$javaviewerSig' $path
    switchTo '$javaviewerSig'
}

proc Java::MarkFile {} {
    Java::MarkFile2 1
}

proc Java::parseFuncs {} {
    Java::MarkFile2 0
}


# My version of	Java::MarkFile. First revision, April 1996.
# Jim Menard, jimm@io.com
# Improved by Vince: both start and end position of embedded classes are
# stored, so if we order methods/sub-classes randomly, we still mark 
# things properly.
proc Java::MarkFile2 {marking} {
    # Sorry, but globals are a lot easier than using "upvar" in subroutines
    global markArray
    global classInfo
    
    catch {unset markArray}
    set classInfo ""
    
    # Look for class definitions first
    set markExpr "^\[ \t\]*(\[A-Za-z_\]\[A-Za-z0-9_\]*\[ \t\]+)*class\[ \t\]+\[A-Za-z_\]\[A-Za-z0-9_\]*\[ \t\r\](\[A-Za-z_\]\[A-Za-z0-9_.\]*\[ \t\]+)*\{"
    set wordExpr "class\[ \t\]+(\[A-Za-z_\]\[A-Za-z0-9_\]*)"
    set commands {
	set markArray([concat $word "class"]) $markPos
	# Remember mark	position and name separately so	we can call
	# Java::getClassFromPos() later.
	lappend	classInfo [list $word $markPos $endPos]
    }
    Java::searchAndDestroy $markExpr $wordExpr $commands 0
    
    # The following regular expression is overly restrictive. After the open
    # paren, I disallow semicolons. That avoids finding lines like
    # throw new FooException(arg);
    # which is good, but unfortunately also avoids finding lines like
    # public int foo(arg) // comment with semi;
    #
    # It doesn't find constructors without a "public", "private", or other phrase
    # before the method name since it requires at least one word before the
    # method name. They are special-cased below. I did that so function calls,
    # "if" statements, and the like wouldn't be found.
    set markExpr "^\[ \t\]*(\[A-Za-z_\]\[A-Za-z0-9_\]*(\\\[\\])*\[ \t\]+)+\[A-Za-z_\]\[A-Za-z0-9_\]*\[ \t\r\]*\\(\[^;\]+$"
    set wordExpr "(\[A-Za-z_\]\[A-Za-z0-9_\]*)\[ \t\]*\\("
    set commands {
	if {$className == $word} {
	    set markArray([concat $className "constructor"]) $markPos
	} else {
	    set markArray(${className}::$word) $markPos
	}
    }
    Java::searchAndDestroy $markExpr $wordExpr $commands 1
    
    # One more time; let's go back for constructors	with no	modifiers.
    set markExpr "^\[ \t\]*\[A-Za-z\]\[A-Za-z0-9_\]*\[ \t\r\]*\\(\[^;\]+$"
    set wordExpr "(\[A-Za-z\]\[A-Za-z0-9_\]*)\[ \t\]*\\("
    set commands {
	if {$className == $word} {
	    set markArray([concat $className "constructor"]) [lineStart [expr $start - 1]]
	}
    }
    Java::searchAndDestroy $markExpr $wordExpr $commands 1
    
    if {[info exists markArray]} {
	foreach	f [lsort -ignore [array	names markArray]] {
	    set next [nextLineStart $markArray($f)]
	    
	    if {[regexp {.*(::if)$} $f] == 0} {
		if {[string length $f] > 35} { 
		    set ff "[string range $f 0 31]..." 
		} else {
		    set ff $f
		}
		if {$marking} {
		    setNamedMark "$ff" "$markArray($f)" $next $next
		} else {
		    lappend parse $ff $next
		}
	    }
	}
    }
    if {!$marking} {return $parse}
}

# Start	at top of file and find	text that matches markExpr. Clean it up	and
# use wordExpr to find the word	we want. Execute commands.
proc Java::searchAndDestroy {markExpr wordExpr commands needClassName} {
    global markArray
    global classInfo
    if {!$needClassName} {
	set getEnd 0
    }
    
    set pos [minPos]
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 -- "$markExpr" $pos} res]} {
	set start [lindex $res 0]
	set end	[pos::math [lindex $res 1] + 1]
	if {[pos::compare $end > [maxPos]]} {
	    set end [maxPos]
	}
	set thistext [getText $start $end]
	if {$needClassName} {
	    set className [Java::getClassFromPos $start $classInfo]
	}
	# regexp doesn't like carriage returns or tabs
	regsub -all "\[\n\r\t\]" $thistext " " thistext
	# If the open paren was	the last character on the line,
	# the selected text included the last carriage return as well.
	# Trim this off	now that it is changed into a space.
	set thistext [string trimright $thistext]
	if {[regexp -- $wordExpr $thistext dummy word]} {
	    set markPos [lineStart [pos::math $start - 1]]
	    if {[info exists getEnd]} {
		if {$getEnd} {
		    set endPos [lindex [search -s -f 1 -m 0 -i 0 -- "\{" $markPos] 1]
		    set endPos [matchIt "\{" $endPos]
		} else {
		    # little efficiency thing: the first class we find, we know
		    # extends to the end of the file, so we don't bother doing
		    # its 'matchIt' because it is very time-consuming.
		    set endPos [maxPos]
		    set getEnd 1
		}
	    }
	    eval $commands
	}
	set pos	$end
    }
}

# Given	a file position, find the class	definition in which it resides.
# There's got to be an easier way than passing two separate lists. 
# I tried fooling
# around with markArray(), but don't know Tcl well enough to use it instead.
proc Java::getClassFromPos {pos classInfo} {
    set nClasses [llength $classInfo]
    for {set i [expr {$nClasses - 1}]} {$i >= 0} {incr i -1} {
	set range [lindex $classInfo $i]
	if {[pos::compare [lindex $range 1] <= $pos] && [pos::compare [lindex $range 2] >= $pos]} {
	    return [lindex $range 0]
	}
    }
    return ""
}
