:: INKSC_WMF2PDFC.CMD: Inkscape conversion WMF|EMF to PDF
:: (without WMF2EPS virtual printer installation):
:: https://wiki.inkscape.org/wiki/Using_the_Command_Line
:: https://inkscape.org/de/gallery/item/12515/view/
:: https://inkscape.org/de/doc/inkscape-man.html
:: This cmd script is free, without any warranty.
:: 2023 W. Schulter
:: ---------------------------------------------------------------------------
:: Usage:
:: > inksc_wmf2pdfc.cmd <wmf|emf-filespec> [dir-spec]
::   produces [dir-spec]\<wmf|emf-filespec>.pdf files
:: Example: inksc_wmf2pdfc.cmd fant.wmf --> .\fant.wmf.pdf
:: ---------------------------------------------------------------------------
@echo off

:: 64 bit version of Inkscape
set INKSC="%ProgramFiles%\Inkscape\inkscape.exe"

:: output dir, . is default
set OUT=.
if [%2] NEQ [] (
  set OUT=%2
  mkdir %2
)

:: output resolution
set DPI=600

:: for loop, if argument %1 contains wildcard chars (* or ?)
for %%f in (%1) do (
  echo %%f
  %INKSC% --without-gui --file=%%f --export-pdf=%OUT%\%%f.pdf --export-dpi=%DPI%
)
