#ifndef	_TEXCMDS
#define	_TEXCMDS
/****************************************************************************
 *
 * Copyright (c) 1992, John Forkosh Associates.  All rights reserved.
 * --------------------------------------------------------------------------
 *
 * Header:	texcmds
 *
 * Purpose:	Defines command strings that are different
 *		for TeX, LaTeX and AMS-TeX.
 *
 * Source:	TEXCMDS.H
 *
 * Notes:     o
 *
 * --------------------------------------------------------------------------
 * Revision History:
 * 12/25/92	J.Forkosh	Installation.
 *
 ***************************************************************************/

/* --------------------------------------------------------------------------
Command table structure
-------------------------------------------------------------------------- */
#define	TEXCMD struct texcmd_struct	/* typedef for tex command struct */
TEXCMD
  {
  int	command;			/* e.g., HEADER,TRAILER,EJECT,etc */
  int	textype;			/* TEX, LATEX or AMSTEX */
  int	nstrings;			/* usually 1, more for HEADER */
  char	**strings;			/* xlation string(s) for command */
  } ; /* --- end-of-struct texcmd_struct --- */

/* --------------------------------------------------------------------------
Command strings
-------------------------------------------------------------------------- */
/* --- concatanate blanks to a string --- */
#define stretch0(string) #string "\000                                      "
#define stretchb(string) #string " \000                                     "
#define stretchc(string) #string "\012\000                                  "
/* --- mode commands --- */
static	char	*tex_parmode[]  = { stretch0($), NULL };
static	char	*tex_mathmode[] = { stretch0($), NULL };
static	char	*tex_dispmath[] = { stretch0($$), NULL };
static	char	*tex_userpar[]  = { stretch0($$), NULL };
static	char	*tex_pardisp[]  = { stretch0($$), NULL };
static	char	*ltx_dispmath[] = { stretchc(\\[), NULL };
static	char	*ltx_userpar[]  = { stretchc(\\]), NULL };
static	char	*ltx_pardisp[]  = { stretchc(\\]), NULL };
/* --- page eject commands --- */
static	char	*tex_eject[] = { stretch0(\\eject), NULL };
static	char	*ltx_eject[] = { stretch0(\\clearpage), NULL };
static	char	*ams_eject[] = { stretch0(\\eject), NULL };
/* --- attribute commands --- */
static	char	*all_superscript[]  = { stretch0(^{), NULL };
static	char	*all_subscript[]    = { stretch0(_{), NULL };
static	char	*all_bold[]         = { stretchb({\\bf ), NULL };
static	char	*all_italics[]      = { stretchb({\\it ), NULL };
static	char	*all_underline[]    = { stretch0(\\underline{), NULL };
static	char	*all_large[]        = { stretchb({\\large ), NULL };
static	char	*all_verylarge[]    = { stretchb({\\Large ), NULL };
static	char	*all_extralarge[]   = { stretchb({\\LARGE ), NULL };
static	char	*all_small[]        = { stretchb({\\small ), NULL };
static	char	*all_fine[]         = { stretchb({\\tiny ), NULL };
static	char	*all_attributeoff[] = { stretch0(}), NULL };

/* --------------------------------------------------------------------------
Strings with arguments (initialized on first call to texcommand()).
-------------------------------------------------------------------------- */
/* --- headers with TeX filename, WP filename, creation date, etc --- */
static	char	filenamehdr[128] = "%* File:      $texfile$";
static	char	purposehdr[128] =
	      "%* Purpose:   LaTeX version of WordPerfect file $wpfile$";
static	char	creationhdr[128] = "%* $mmddyy$   J.Forkosh      Creation.";
static	char	ltx_pagestyle[128] =
	     "\\pagestyle{myheadings} \\markright{$wpfile$} %page headings";
static	char	ltx_title[128]  = "\\title{$title$}";
static	char	ltx_author[128] = "\\author{$author$";
/* --- array of strings to be initialized --- */
char	*hdrstrings[] =
  { filenamehdr,   purposehdr, creationhdr,
    ltx_pagestyle, ltx_title,  ltx_author,
    NULL } ; /* --- end-of-hdrstrings[] --- */

/* --------------------------------------------------------------------------
Frequently-used strings
-------------------------------------------------------------------------- */
static	char	stars[] =		/* comment line with asterisks */
"%**************************************************************************";
static	char	stripes[] =		/* comment line with dashes */
"%* ------------------------------------------------------------------------";
static	char	lonestar[] = "%*";	/* comment line for layout */
static	char	copyright[] =		/* copyright string */
"%* TexPerfect  Copyright (c) 1992-1996, John Forkosh.  All rights reserved.";
static	char	endoffile[] =		/* comment line at end-of-file */
"%* ---------------------------- END-OF-FILE -------------------------------";
/* --- document trailer commands --- */
static	char	*ltx_trailer[] = { "\\end{document}", endoffile, NULL };

/* --------------------------------------------------------------------------
Document header and preamble commands
-------------------------------------------------------------------------- */
static	char	*tex_header[] = {
  /* --- same header for everyone --- */
  stars, lonestar, copyright, stripes, lonestar, filenamehdr, lonestar,
  purposehdr, lonestar, stripes, "%* Revision History:", creationhdr,
  lonestar, stars, "", stripes, "% Preamble Settings", stripes,
  NULL } ; /* --- end-of-tex_header[] --- */
static	char	*ltx_preamble[] = {	/* LaTeX Preamble */
  "% --- page formatting ---",
  "\\documentstyle[12pt]{article}          %type=12pt, LaTeX article style",
  "\\setlength{\\oddsidemargin}{0.0in}      %left margin relative to 1inch",
  "\\setlength{\\textwidth}{7.0in}          %right margin = left + textwidth",
  "\\setlength{\\topmargin}{-0.25in}        %top margin relative to 1inch",
  "\\setlength{\\textheight}{9.0in}         %top margin + textheight",
  "\\setlength{\\parskip}{0.0in}            %vert space between paragraphs",
  "", stripes, "%* Document settings", stripes,
  "\\begin{document}",
  "\\setcounter{page}{1}                   %first page number of document",
  ltx_pagestyle,
  "\\tolerance=10000                       %prevent overfull hboxes",
  "% --- title ---",
  ltx_title, ltx_author,
  "\\thanks{These notes were typeset by the author using",
  "\\TeX Perfect supplied by John Forkosh, Jersey City, NJ.}}",
  "\\date{ }",
  "\\maketitle",
  "", stripes, "%* Text of Document", stripes,
  NULL } ; /* --- end-of-ltx_preamble[] --- */

/* --------------------------------------------------------------------------
Command table
-------------------------------------------------------------------------- */
TEXCMD texcmds[] =
  {
    /* --- mode commands --- */
    { PARMODE,	TEX,	1,	tex_parmode },
    { PARMODE,	LATEX,	1,	tex_parmode },
    { PARMODE,	AMSTEX,	1,	tex_parmode },
    { MATHMODE,	TEX,	1,	tex_mathmode },
    { MATHMODE,	LATEX,	1,	tex_mathmode },
    { MATHMODE,	AMSTEX,	1,	tex_mathmode },
    { DISPMATH,	TEX,	1,	tex_dispmath },
    { DISPMATH,	LATEX,	1,	ltx_dispmath },
    { DISPMATH,	AMSTEX,	1,	tex_dispmath },
    { PARDISP,	TEX,	1,	tex_pardisp },
    { PARDISP,	LATEX,	1,	ltx_pardisp },
    { PARDISP,	AMSTEX,	1,	tex_pardisp },
    { USERPAR,	TEX,	1,	tex_userpar },
    { USERPAR,	LATEX,	1,	ltx_userpar },
    { USERPAR,	AMSTEX,	1,	tex_userpar },
    /* --- page eject commands --- */
    { EJECT,	TEX,	1,	tex_eject },
    { EJECT,	LATEX,	1,	ltx_eject },
    { EJECT,	AMSTEX,	1,	ams_eject },
    /* --- header and trailer commands --- */
    { HEADER,	TEX,	18,	tex_header },
    { HEADER,	LATEX,	18,	tex_header },
    { HEADER,	AMSTEX,	18,	tex_header },
    { PREAMBLE,	LATEX,	26,	ltx_preamble },
    { TRAILER,	LATEX,	2,	ltx_trailer },
    /* --- attribute commands --- */
    { SUPERSCRIPT,  ALLTEX, 1,	all_superscript },
    { SUBSCRIPT,    ALLTEX, 1,	all_subscript },
    { BOLD,         ALLTEX, 1,	all_bold },
    { ITALICS,      ALLTEX, 1,	all_italics },
    { UNDERLINE,    ALLTEX, 1,	all_underline },
    { LARGE,        ALLTEX, 1,	all_large },
    { VERYLARGE,    ALLTEX, 1,	all_verylarge },
    { EXTRALARGE,   ALLTEX, 1,	all_extralarge },
    { SMALL,        ALLTEX, 1,	all_small },
    { FINE,         ALLTEX, 1,	all_fine },
    { ATTRIBUTEOFF, ALLTEX, 1,	all_attributeoff },
    { -1, -1, -1, (char **)NULL }	/* end-of-table trailer */
  } ; /* --- end-of-struct texcmds --- */
/* ----------------------- END-OF-FILE TEXCMDS.H ------------------------- */
#endif
