/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.texlipse.DDEClient;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.SelectedResourceManager;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.TexlipseNature;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.viewer.FileLocationOpener;
import net.sourceforge.texlipse.viewer.ViewerAttributeRegistry;
import net.sourceforge.texlipse.viewer.ViewerOutputScanner;
import net.sourceforge.texlipse.viewer.util.FileLocationServer;
import net.sourceforge.texlipse.viewer.util.ViewerErrorScanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ViewerManager {
    public static final String FILENAME_PATTERN = "%file";
    public static final String LINE_NUMBER_PATTERN = "%line";
    public static final String TEX_FILENAME_PATTERN = "%texfile";
    public static final String FILENAME_FULLPATH_PATTERN = "%fullfile";
    public static final String TEX_FILENAME_FULLPATH_PATTERN = "%fulltexfile";
    private ViewerAttributeRegistry registry;
    private Map envSettings;
    private IProject project;

    public static Process preview(ViewerAttributeRegistry reg, Map addEnv, IProgressMonitor monitor) throws CoreException {
        ViewerManager mgr = new ViewerManager(reg, addEnv);
        if (!mgr.initialize()) {
            return null;
        }
        Process process = mgr.getExisting();
        if (process != null) {
            mgr.sendDDEViewCommand();
            return process;
        }
        process = mgr.execute();
        if (Platform.getOS().equals("win32")) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            mgr.sendDDEViewCommand();
        }
        return process;
    }

    public static void closeOutputDocument() throws CoreException {
        ViewerAttributeRegistry registry = new ViewerAttributeRegistry();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = manager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch l = launches[i];
            ILaunchConfiguration configuration = l.getLaunchConfiguration();
            if (configuration != null && configuration.exists() && configuration.getType().getIdentifier().equals("net.sourceforge.texlipse.viewer.launchConfigurationType")) {
                Map regMap = configuration.getAttributes();
                registry.setValues(regMap);
                break;
            }
            ++i;
        }
        ViewerManager mgr = new ViewerManager(registry, null);
        if (!mgr.initialize()) {
            return;
        }
        Process process = mgr.getExisting();
        if (process != null) {
            mgr.sendDDECloseCommand();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            ViewerManager.returnFocusToEclipse(false);
        }
    }

    public static void returnFocusToEclipse(final boolean useMinimizeTrick) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    if (i < workbenchWindows.length) {
                        Shell shell = workbenchWindows[i].getShell();
                        if (useMinimizeTrick) {
                            shell.setMinimized(true);
                            shell.setMinimized(false);
                        }
                        shell.setActive();
                        shell.forceActive();
                    }
                }
            });
        }
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                            int i = 0;
                            while (i < workbenchWindows.length) {
                                IWorkbenchPage activePage = workbenchWindows[i].getActivePage();
                                activePage.activate((IWorkbenchPart)activePage.getActiveEditor());
                                activePage.getActiveEditor().setFocus();
                                ++i;
                            }
                        }
                    });
                }
            }
        }).start();
    }

    protected ViewerManager(ViewerAttributeRegistry reg, Map addEnv) {
        this.registry = reg;
        this.envSettings = addEnv;
    }

    protected boolean initialize() {
        this.project = TexlipsePlugin.getCurrentProject();
        if (this.project == null) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("viewerNoCurrentProject"));
            return false;
        }
        try {
            if (this.project.getNature(TexlipseNature.NATURE_ID) == null) {
                return false;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    protected Process getExisting() {
        Object o = TexlipseProperties.getSessionProperty((IResource)this.project, "active.viewer");
        if (o != null) {
            if (o instanceof HashMap) {
                HashMap viewerInfo = (HashMap)o;
                Process p = (Process)viewerInfo.get("process");
                String cmd = (String)viewerInfo.get("command");
                int code = -1;
                try {
                    code = p.exitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
                if (code == -1 && !this.registry.getForward()) {
                    return p;
                }
                if (cmd.toLowerCase().indexOf("acrobat.exe") > -1 && code == 1 && Platform.getOS().equals("win32")) {
                    try {
                        String s = "";
                        Runtime Rt = Runtime.getRuntime();
                        InputStream ip = Rt.exec("tasklist").getInputStream();
                        BufferedReader in = new BufferedReader(new InputStreamReader(ip));
                        while ((s = in.readLine()) != null) {
                            if (s.toLowerCase().indexOf("acrobat.exe") <= -1) continue;
                            return p;
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            TexlipseProperties.setSessionProperty((IResource)this.project, "active.viewer", null);
        }
        return null;
    }

    protected Process execute() throws CoreException {
        IResource outputRes;
        if (TexlipseProperties.isProjectPropertiesFileChanged(this.project)) {
            TexlipseProperties.loadProjectProperties(this.project);
        }
        if ((outputRes = ViewerManager.getOuputResource(this.project)) == null || !outputRes.exists()) {
            String msg = TexlipsePlugin.getResourceString("viewerNothingWithExtension");
            BuilderRegistry.printToConsole(msg.replaceAll("%s", this.registry.getFormat()));
            return null;
        }
        IContainer sourceDir = TexlipseProperties.getProjectSourceDir(this.project);
        File dir = sourceDir.getLocation().toFile();
        try {
            return this.execute(dir);
        }
        catch (IOException e) {
            throw new CoreException(TexlipsePlugin.stat("Could not start previewer '" + this.registry.getActiveViewer() + "'. Please make sure you have entered " + "the correct path and filename in the viewer preferences.", e));
        }
    }

    protected void sendDDEViewCommand() throws CoreException {
        if (Platform.getOS().equals("win32")) {
            String topic;
            String command = this.translatePatterns(this.registry.getDDEViewCommand());
            String server = this.registry.getDDEViewServer();
            int error = DDEClient.execute(server, topic = this.registry.getDDEViewTopic(), command);
            if (error != 0) {
                String errorMessage = "DDE command " + command + " failed! " + "(server: " + server + ", topic: " + topic + ")";
                TexlipsePlugin.log(errorMessage, new Throwable(errorMessage));
            }
        }
    }

    protected void sendDDECloseCommand() throws CoreException {
        if (Platform.getOS().equals("win32")) {
            String topic;
            String command = this.translatePatterns(this.registry.getDDECloseCommand());
            String server = this.registry.getDDECloseServer();
            int error = DDEClient.execute(server, topic = this.registry.getDDECloseTopic(), command);
            if (error != 0) {
                String errorMessage = "DDE command " + command + " failed! " + "(server: " + server + ", topic: " + topic + ")";
                TexlipsePlugin.log(errorMessage, new Throwable(errorMessage));
            }
        }
    }

    public static String resolveRelativePath(IPath sourcePath, IPath outputPath) {
        int same = sourcePath.matchingFirstSegments(outputPath);
        if (same == sourcePath.segmentCount() && same == outputPath.segmentCount()) {
            return "";
        }
        outputPath = outputPath.removeFirstSegments(same);
        sourcePath = sourcePath.removeFirstSegments(same);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < sourcePath.segmentCount()) {
            sb.append("..");
            sb.append(File.separatorChar);
            ++i;
        }
        i = 0;
        while (i < outputPath.segmentCount()) {
            sb.append(outputPath.segment(i));
            sb.append(File.separatorChar);
            ++i;
        }
        return sb.toString();
    }

    public static IResource getOuputResource(IProject project) throws CoreException {
        IResource resource;
        String outFileName = TexlipseProperties.getOutputFileName(project);
        if (outFileName == null || outFileName.length() == 0) {
            throw new CoreException(TexlipsePlugin.stat("Empty output file name."));
        }
        IFolder outputDir = null;
        outputDir = TexlipseProperties.getProjectOutputDir(project);
        if (outputDir == null) {
            outputDir = project;
        }
        return (resource = outputDir.findMember(outFileName)) != null ? resource : project.getFile(outFileName);
    }

    private int getCurrentLineNumber() {
        int lineNumber = 0;
        final IWorkbenchPage currentWorkbenchPage = TexlipsePlugin.getCurrentWorkbenchPage();
        if (currentWorkbenchPage != null) {
            final int[] buf = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ISelection selection = currentWorkbenchPage.getSelection();
                    if (selection != null && selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        buf[0] = textSelection.getStartLine() + 1;
                    }
                }
            });
            lineNumber = buf[0];
        }
        if (lineNumber <= 0) {
            lineNumber = 1;
        }
        return lineNumber;
    }

    private Process execute(File dir) throws IOException, CoreException {
        ArrayList<String> list = new ArrayList<String>();
        String command = this.registry.getCommand();
        if (command.indexOf(32) > 0) {
            command = "\"" + command + "\"";
        }
        list.add(command);
        String args = this.translatePatterns(this.registry.getArguments());
        PathUtils.tokenizeEscapedString(args, list);
        Properties env = PathUtils.getEnv();
        if (this.envSettings != null) {
            env.putAll((Map<?, ?>)this.envSettings);
        }
        String[] envp = PathUtils.mergeEnvFromPrefs(env, "viewerEnvSet");
        BuilderRegistry.printToConsole(String.valueOf(TexlipsePlugin.getResourceString("viewerRunning")) + " " + command + " " + args);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(list.toArray(new String[0]), envp, dir);
        HashMap<String, Object> viewerInfo = new HashMap<String, Object>();
        viewerInfo.put("process", process);
        viewerInfo.put("command", command);
        viewerInfo.put("arguments", args);
        TexlipseProperties.setSessionProperty((IResource)this.project, "active.viewer", viewerInfo);
        this.startOutputListener(process.getInputStream(), this.registry.getInverse());
        new Thread(new ViewerErrorScanner(process)).start();
        return process;
    }

    private String translatePatterns(String input) throws CoreException {
        IResource selectedRes;
        if (input == null) {
            return null;
        }
        IContainer sourceDir = TexlipseProperties.getProjectSourceDir(this.project);
        if (input.indexOf(FILENAME_PATTERN) >= 0) {
            IResource outputRes = ViewerManager.getOuputResource(this.project);
            String outFileName = outputRes.getName();
            outFileName = ViewerManager.resolveRelativePath(sourceDir.getFullPath(), outputRes.getFullPath());
            if ((outFileName = outFileName.substring(0, outFileName.length() - 1)).indexOf(32) >= 0) {
                outFileName = "\"" + outFileName + "\"";
            }
            input = input.replaceAll(FILENAME_PATTERN, this.escapeBackslashes(outFileName));
        }
        if (input.indexOf(FILENAME_FULLPATH_PATTERN) >= 0) {
            input = input.replaceAll(FILENAME_FULLPATH_PATTERN, this.escapeBackslashes(ViewerManager.getOuputResource(this.project).getLocation().toOSString()));
        }
        if (input.indexOf(LINE_NUMBER_PATTERN) >= 0) {
            input = input.replaceAll(LINE_NUMBER_PATTERN, "" + this.getCurrentLineNumber());
        }
        if (input.indexOf(TEX_FILENAME_PATTERN) >= 0) {
            selectedRes = SelectedResourceManager.getDefault().getSelectedResource();
            if (selectedRes.getType() != 2) {
                selectedRes = SelectedResourceManager.getDefault().getSelectedTexResource();
            }
            String relPath = ViewerManager.resolveRelativePath(sourceDir.getFullPath(), selectedRes.getFullPath().removeLastSegments(1));
            String texFile = String.valueOf(relPath) + selectedRes.getName();
            input = input.replaceAll(TEX_FILENAME_PATTERN, this.escapeBackslashes(texFile));
        }
        if (input.indexOf(TEX_FILENAME_FULLPATH_PATTERN) >= 0) {
            selectedRes = SelectedResourceManager.getDefault().getSelectedResource();
            if (selectedRes.getType() != 2) {
                selectedRes = SelectedResourceManager.getDefault().getSelectedTexResource();
            }
            input = input.replaceAll(TEX_FILENAME_FULLPATH_PATTERN, this.escapeBackslashes(selectedRes.getLocation().toOSString()));
        }
        return input;
    }

    private String escapeBackslashes(String file) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < file.length()) {
            char c = file.charAt(i);
            sb.append(c);
            if (c == '\\') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private void startOutputListener(final InputStream in, String inverse) {
        if (inverse.equals("run")) {
            FileLocationServer server = FileLocationServer.getInstance();
            server.setListener(new FileLocationOpener(this.project));
            if (!server.isRunning()) {
                new Thread(server).start();
            }
            new Thread(new Runnable(){

                public void run() {
                    BufferedInputStream st = new BufferedInputStream(in);
                    try {
                        byte[] buf = new byte[1024];
                        while (((InputStream)st).read(buf) != -1) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ((InputStream)st).close();
                    }
                    catch (IOException iOException) {}
                }
            }).start();
        } else if (inverse.equals("std")) {
            new Thread(new ViewerOutputScanner(this.project, in)).start();
        }
    }
}

