/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import net.sourceforge.texlipse.actions.InputQueryDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;

public class StringListFieldEditor
extends ListEditor
implements IInputValidator {
    public static final String SEPARATOR = ",";
    private static final String INVALID_CHARS = " ,()[]{}<>|\\?+/&#%$\u00c2\u00a4\u00c2\u00a3#@\"!\u00c2\u00a7\u00c2\u00bd";

    public StringListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected String createList(String[] items) {
        StringBuffer sb = new StringBuffer();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length - 1) {
                sb.append(items[i]);
                sb.append(SEPARATOR);
                ++i;
            }
            sb.append(items[items.length - 1]);
        }
        return sb.toString();
    }

    protected String getNewInputObject() {
        InputQueryDialog dialog = InputQueryDialog.createQuery("Enter string", "Please enter keyword", IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL);
        dialog.setValidator(this);
        int code = dialog.open();
        if (code == 0) {
            String g = dialog.getInput();
            if (g != null && g.length() == 0) {
                return null;
            }
            return g;
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        return stringList.split(SEPARATOR);
    }

    public String isValid(String newText) {
        boolean error = false;
        int i = 0;
        while (i < newText.length()) {
            if (INVALID_CHARS.indexOf(newText.charAt(i)) >= 0) {
                error = true;
                break;
            }
            ++i;
        }
        return error ? "invalid character" : null;
    }
}

