/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.outline;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.outline.TexOutlinePage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TexOutlineDNDAdapter
extends ViewerDropAdapter
implements DragSourceListener {
    private TexOutlinePage outline;
    private OutlineNode dragSource;
    private int removeOffset;

    public TexOutlineDNDAdapter(Viewer viewer, TexOutlinePage outlinePage) {
        super(viewer);
        this.outline = outlinePage;
        this.setFeedbackEnabled(false);
    }

    public boolean performDrop(Object data) {
        int sourceOffset;
        OutlineNode target = (OutlineNode)this.getCurrentTarget();
        int targetOffset = target.getPosition().getOffset() + target.getPosition().getLength();
        this.removeOffset = targetOffset < (sourceOffset = this.dragSource.getPosition().getOffset()) ? sourceOffset + ((String)data).length() : sourceOffset;
        try {
            this.getDocument().replace(targetOffset, 0, (String)data);
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Could not perform drop operation.", e);
            return false;
        }
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (this.outline.isModelDirty()) {
            return false;
        }
        if (!TextTransfer.getInstance().isSupportedType(transferType)) {
            return false;
        }
        OutlineNode targetNode = (OutlineNode)target;
        if (targetNode == null || targetNode.getType() == 14) {
            return false;
        }
        return !targetNode.equals(this.dragSource) && !this.isAncestor(this.dragSource, targetNode);
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = false;
        if (this.outline.isModelDirty()) {
            return;
        }
        OutlineNode node = this.getSelection();
        if (node == null) {
            return;
        }
        if (node.getType() == 14) {
            return;
        }
        this.dragSource = node;
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        if (!TextTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        this.dragSource.getPosition().getOffset();
        this.dragSource.getPosition().getLength();
        Position sourcePosition = this.dragSource.getPosition();
        String sourceText = "";
        try {
            sourceText = this.getDocument().get(sourcePosition.getOffset(), sourcePosition.getLength());
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Could not set drag data.", e);
            return;
        }
        event.data = sourceText;
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            int sourceLength = this.dragSource.getPosition().getLength();
            try {
                this.getDocument().replace(this.removeOffset, sourceLength, "");
            }
            catch (BadLocationException e) {
                TexlipsePlugin.log("Could not remove drag'n'drop source.", e);
            }
        }
        this.outline.getEditor().updateModelNow();
    }

    private IDocument getDocument() {
        return this.outline.getEditor().getDocumentProvider().getDocument((Object)this.outline.getEditor().getEditorInput());
    }

    private OutlineNode getSelection() {
        ISelection selection = this.getViewer().getSelection();
        if (selection == null) {
            return null;
        }
        return (OutlineNode)((IStructuredSelection)selection).getFirstElement();
    }

    private boolean isAncestor(OutlineNode ancestor, OutlineNode child) {
        OutlineNode parent = child.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.equals(ancestor)) {
            return true;
        }
        return this.isAncestor(ancestor, parent);
    }
}

