/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.util.ArrayList;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BiberRunner;
import net.sourceforge.texlipse.builder.BibtexRunner;
import net.sourceforge.texlipse.builder.Builder;
import net.sourceforge.texlipse.builder.DviBuilder;
import net.sourceforge.texlipse.builder.DvipdfRunner;
import net.sourceforge.texlipse.builder.DvipsRunner;
import net.sourceforge.texlipse.builder.KpsewhichRunner;
import net.sourceforge.texlipse.builder.LatexRunner;
import net.sourceforge.texlipse.builder.LualatexRunner;
import net.sourceforge.texlipse.builder.MakeindexNomenclRunner;
import net.sourceforge.texlipse.builder.MakeindexRunner;
import net.sourceforge.texlipse.builder.PdflatexRunner;
import net.sourceforge.texlipse.builder.ProgramRunner;
import net.sourceforge.texlipse.builder.Ps2pdfRunner;
import net.sourceforge.texlipse.builder.PsBuilder;
import net.sourceforge.texlipse.builder.PslatexRunner;
import net.sourceforge.texlipse.builder.TexBuilder;
import net.sourceforge.texlipse.builder.XelatexRunner;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderRegistry {
    private static BuilderRegistry instance = new BuilderRegistry();
    private Builder[] builderList;
    private ProgramRunner[] runnerList = new ProgramRunner[]{new LatexRunner(), new PslatexRunner(), new PdflatexRunner(), new XelatexRunner(), new LualatexRunner(), new BibtexRunner(), new BiberRunner(), new MakeindexRunner(), new DvipsRunner(), new DvipdfRunner(), new Ps2pdfRunner(), new MakeindexNomenclRunner(), new KpsewhichRunner()};
    private MessageConsoleStream consoleStream;
    private MessageConsole console;

    public static void printToConsole(String msg) {
        instance.getConsoleStream().println(msg);
    }

    public static void clearConsole() {
        BuilderRegistry.instance.consoleStream = null;
        TexlipsePlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                instance.getConsole().getDocument().set("");
            }
        });
    }

    private MessageConsole getConsole() {
        if (this.console == null) {
            this.console = new MessageConsole("Texlipse", null);
            IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
            mgr.addConsoles(new IConsole[]{this.console});
        }
        return this.console;
    }

    private MessageConsoleStream getConsoleStream() {
        if (this.consoleStream == null) {
            this.consoleStream = this.getConsole().newMessageStream();
        }
        return this.consoleStream;
    }

    public static Builder get(Class<? extends Builder> clazz, String format) {
        return instance.getBuilder(clazz, format);
    }

    public static Builder[] getAll(String format) {
        if (BuilderRegistry.instance.builderList == null) {
            instance.initBuilders();
        }
        return instance.getAllBuilders(format);
    }

    public static Builder get(int i) {
        if (BuilderRegistry.instance.builderList == null) {
            instance.initBuilders();
        }
        if (i >= 0 && i < BuilderRegistry.instance.builderList.length) {
            return BuilderRegistry.instance.builderList[i];
        }
        return null;
    }

    public static ProgramRunner getRunner(int i) {
        return instance.getProgramRunner(i);
    }

    public static ProgramRunner getRunner(String in, String out, int alternative) {
        return instance.getProgramRunner(in, out, alternative);
    }

    protected BuilderRegistry() {
    }

    protected void initBuilders() {
        this.builderList = new Builder[9];
        this.builderList[0] = new TexBuilder(0, "dvi", 0);
        this.builderList[1] = new TexBuilder(1, "ps", 0);
        this.builderList[2] = new TexBuilder(2, "pdf", 0);
        this.builderList[3] = new DviBuilder(3, "ps");
        this.builderList[4] = new DviBuilder(4, "pdf");
        this.builderList[5] = new PsBuilder(5, TexBuilder.class);
        this.builderList[6] = new PsBuilder(6, DviBuilder.class);
        this.builderList[7] = new TexBuilder(7, "pdf", 1);
        this.builderList[8] = new TexBuilder(8, "pdf", 2);
    }

    protected Builder getBuilder(Class<? extends Builder> builderClass, String outputFormat) {
        if (outputFormat == null) {
            return null;
        }
        Builder builder = null;
        int i = 0;
        while (i < this.builderList.length) {
            if (this.builderList[i] != null && this.builderList[i].getOutputFormat().equals(outputFormat) && (builderClass == null || this.builderList[i].getClass().equals(builderClass))) {
                builder = this.builderList[i];
            }
            ++i;
        }
        if (builder == null) {
            return null;
        }
        return builder;
    }

    protected Builder[] getAllBuilders(String format) {
        ArrayList<Builder> list = new ArrayList<Builder>();
        int i = 0;
        while (i < this.builderList.length) {
            if (this.builderList[i] != null && this.builderList[i].getOutputFormat().equals(format)) {
                list.add(this.builderList[i]);
            }
            ++i;
        }
        return list.toArray(new Builder[0]);
    }

    protected ProgramRunner getProgramRunner(int i) {
        if (i >= 0 && i < this.runnerList.length) {
            return this.runnerList[i];
        }
        return null;
    }

    protected ProgramRunner getProgramRunner(String in, String out, int alternative) {
        int size = BuilderRegistry.getNumberOfRunners();
        int i = 0;
        while (i < size) {
            ProgramRunner r = this.getProgramRunner(i);
            if (in.equals(r.getInputFormat()) && (out == null || r.getOutputFormat().equals(out))) {
                if (alternative == 0) {
                    return r;
                }
                --alternative;
            }
            ++i;
        }
        return null;
    }

    public static int getNumberOfRunners() {
        return BuilderRegistry.instance.runnerList.length;
    }
}

