/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibparser;

import java.io.PushbackReader;
import net.sourceforge.texlipse.bibparser.lexer.Lexer;
import net.sourceforge.texlipse.bibparser.lexer.LexerException;
import net.sourceforge.texlipse.bibparser.node.EOF;
import net.sourceforge.texlipse.bibparser.node.TLBrace;
import net.sourceforge.texlipse.bibparser.node.TRBrace;
import net.sourceforge.texlipse.bibparser.node.TStringLiteral;
import net.sourceforge.texlipse.bibparser.node.TWhitespace;
import net.sourceforge.texlipse.bibparser.node.Token;

public class BibLexer
extends Lexer {
    private int count;
    private Token stringStart;
    private StringBuffer text;

    public BibLexer(PushbackReader in) {
        super(in);
    }

    protected void filter() throws LexerException {
        if (this.state.equals(Lexer.State.BRACESTRING)) {
            if (this.stringStart == null) {
                this.stringStart = this.token;
                this.text = new StringBuffer("");
                this.count = 1;
                this.token = null;
            } else {
                if (this.token instanceof TLBrace) {
                    ++this.count;
                } else if (this.token instanceof TRBrace) {
                    --this.count;
                } else if (this.token instanceof EOF) {
                    throw new LexerException("[" + this.stringStart.getLine() + "," + this.stringStart.getPos() + "] Unexpected end of file");
                }
                if (this.count != 0) {
                    if (this.token instanceof TWhitespace) {
                        this.text.append(" ");
                    } else {
                        this.text.append(this.token.getText());
                    }
                    this.token = null;
                } else {
                    TStringLiteral tsl = new TStringLiteral(this.text.toString(), this.stringStart.getLine(), this.stringStart.getPos());
                    this.token = tsl;
                    this.state = Lexer.State.ASSIGN;
                    this.stringStart = null;
                }
            }
        } else if (this.state.equals(Lexer.State.REMOVE)) {
            if (this.token instanceof TLBrace) {
                ++this.count;
                if (this.stringStart == null) {
                    this.stringStart = this.token;
                }
            } else if (this.token instanceof TRBrace) {
                --this.count;
            } else if (this.token instanceof EOF) {
                throw new LexerException("[" + this.stringStart.getLine() + "," + this.stringStart.getPos() + "] Unexpected end of file");
            }
            this.token = null;
            if (this.count == 0 && this.stringStart != null) {
                this.state = Lexer.State.NORMAL;
                this.stringStart = null;
            }
        }
    }
}

