/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties.editor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.TexlipseHelpIds;
import net.sourceforge.texlipse.properties.TexlipsePreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class TexEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_WRAP_LENGTH = 1000;
    private static final int MIN_WRAP_LENGTH = 10;
    private static final int MAX_COMPLETION_DELAY = 10000;
    private static final int MIN_COMPLETION_DELAY = 0;
    private static final int MAX_AUTO_DELAY = 30000;
    private static final int MIN_AUTO_DELAY = 0;
    private IWorkbench workbench;

    public TexEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(TexlipsePlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        TexlipsePreferencePage.addSpacer(this.getFieldEditorParent());
        this.addField((FieldEditor)new BooleanFieldEditor("texCompletion", TexlipsePlugin.getResourceString("preferenceTexCompletion"), this.getFieldEditorParent()));
        String completionMessage = TexlipsePlugin.getResourceString("preferenceTexCompletionDelay").replaceFirst("%1", "0").replaceFirst("%2", "10000");
        IntegerFieldEditor completionDelay = new IntegerFieldEditor("texDelay", completionMessage, this.getFieldEditorParent());
        completionDelay.setValidateStrategy(0);
        completionDelay.setValidRange(0, 10000);
        this.addField((FieldEditor)completionDelay);
        this.addField((FieldEditor)new BooleanFieldEditor("texItemCompletion", TexlipsePlugin.getResourceString("preferenceTexItemCompletion"), this.getFieldEditorParent()));
        Label itemLabel = new Label(this.getFieldEditorParent(), 16448);
        itemLabel.setText(TexlipsePlugin.getResourceString("preferenceTexItemCompletionText"));
        this.addField((FieldEditor)new BooleanFieldEditor("autoParsing", TexlipsePlugin.getResourceString("preferenceAutoParsing"), this.getFieldEditorParent()));
        String autoParsingMessage = TexlipsePlugin.getResourceString("preferenceAutoParsingDelay").replaceFirst("%1", "0").replaceFirst("%2", "30000");
        IntegerFieldEditor autoDelay = new IntegerFieldEditor("autoParsingDelay", autoParsingMessage, this.getFieldEditorParent());
        autoDelay.setValidateStrategy(0);
        autoDelay.setValidRange(0, 30000);
        this.addField((FieldEditor)autoDelay);
        this.addField((FieldEditor)new BooleanFieldEditor("sectionCheck", TexlipsePlugin.getResourceString("preferenceSectionCheck"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("textEditorAnnotations", TexlipsePlugin.getResourceString("preferencesEditorHighlighting"), this.getFieldEditorParent()));
        TexlipsePreferencePage.addSpacer(this.getFieldEditorParent());
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText(TexlipsePlugin.getResourceString("preferenceWrapping"));
        group.setLayout((Layout)new GridLayout());
        GridData layData = new GridData(768);
        layData.horizontalSpan = 2;
        group.setLayoutData((Object)layData);
        Composite wordWrapParent = this.getFieldEditorParent(group);
        this.addField((FieldEditor)new BooleanFieldEditor("wrapDefault", TexlipsePlugin.getResourceString("preferenceWrappingDefault"), wordWrapParent));
        TexlipsePreferencePage.addSpacer(wordWrapParent);
        String message = TexlipsePlugin.getResourceString("preferenceWrapLineLength").replaceFirst("%1", "10").replaceFirst("%2", "1000");
        IntegerFieldEditor wordWrapLength = new IntegerFieldEditor("lineLength", message, wordWrapParent);
        wordWrapLength.setValidateStrategy(0);
        wordWrapLength.setValidRange(10, 1000);
        this.addField((FieldEditor)wordWrapLength);
        IWorkbenchHelpSystem helpsystem = this.workbench.getHelpSystem();
        helpsystem.setHelp((Control)wordWrapLength.getTextControl(wordWrapParent), TexlipseHelpIds.WRAP_LENGTH);
        TexlipsePreferencePage.addSpacer(wordWrapParent);
        Label label = new Label(wordWrapParent, 16448);
        label.setText(TexlipsePlugin.getResourceString("preferenceWrapSoftWarning"));
        GridData lgl = new GridData(768);
        lgl.horizontalSpan = 2;
        label.setLayoutData((Object)lgl);
        this.addField((FieldEditor)new RadioGroupFieldEditor("wrapType", TexlipsePlugin.getResourceString("preferenceWrapType"), 1, (String[][])new String[][]{{TexlipsePlugin.getResourceString("preferenceWrapSoftLabel"), "soft"}, {TexlipsePlugin.getResourceString("preferenceWrapHardLabel"), "hard"}}, this.getFieldEditorParent(group)));
    }

    private Composite getFieldEditorParent(Group group) {
        Composite parent = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        return parent;
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }
}

