/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import net.sourceforge.texlipse.model.OutlineNode;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

public class TexProjectionAnnotation
extends ProjectionAnnotation {
    private OutlineNode node;

    public TexProjectionAnnotation(OutlineNode node) {
        this.node = node;
    }

    public TexProjectionAnnotation(OutlineNode node, boolean isCollaped) {
        super(isCollaped);
        this.node = node;
    }

    public Position getPosition() {
        return this.node.getPosition();
    }

    public boolean likelySame(OutlineNode on) {
        if (on.getType() != this.node.getType() || !this.node.getName().equals(on.getName())) {
            return false;
        }
        return this.node.getPosition().equals((Object)on.getPosition());
    }

    public boolean contains(int offset) {
        Position pos = this.node.getPosition();
        return offset >= pos.getOffset() && offset < pos.getOffset() + pos.getLength();
    }

    public boolean isDeeperThan(TexProjectionAnnotation tpa) {
        Position thisPos = this.node.getPosition();
        Position alienPos = tpa.getPosition();
        return thisPos.offset > alienPos.offset && thisPos.offset + thisPos.length <= alienPos.offset + alienPos.length;
    }

    public boolean isBetween(int startOffset, int endOffset) {
        Position pos = this.node.getPosition();
        return startOffset <= pos.offset && pos.length + pos.offset < endOffset;
    }
}

