/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    public static final String DEFAULT = "def.TexColor";
    public static final String STRING = "str.TexColor";
    public static final String COMMAND = "cmd.TexColor";
    public static final String CURLY_BRACKETS = "crl.TexColor";
    public static final String SQUARE_BRACKETS = "sqr.TexColor";
    public static final String EQUATION = "equ.TexColor";
    public static final String COMMENT = "com.TexColor";
    public static final String VERBATIM = "verb.TexColor";
    public static final String TEX_NUMBER = "num.TexColor";
    public static final String TEX_SPECIAL = "spe.TexColor";
    public static final String DEFAULT_STYLE = "def.TexStyle";
    public static final String STRING_STYLE = "str.TexStyle";
    public static final String COMMAND_STYLE = "cmd.TexStyle";
    public static final String CURLY_BRACKETS_STYLE = "crl.TexStyle";
    public static final String SQUARE_BRACKETS_STYLE = "sqr.TexStyle";
    public static final String EQUATION_STYLE = "equ.TexStyle";
    public static final String COMMENT_STYLE = "com.TexStyle";
    public static final String VERBATIM_STYLE = "verb.TexStyle";
    public static final String TEX_NUMBER_STYLE = "num.TexStyle";
    public static final String TEX_SPECIAL_STYLE = "spe.TexStyle";
    private static final RGB DEFAULT_DEFAULT_COLOR = new RGB(0, 0, 0);
    private static final RGB DEFAULT_STRING_COLOR = new RGB(255, 0, 0);
    private static final RGB DEFAULT_COMMAND_COLOR = new RGB(128, 0, 255);
    private static final RGB DEFAULT_CURLY_BRACKETS_COLOR = new RGB(3, 54, 222);
    private static final RGB DEFAULT_SQUARE_BRACKETS_COLOR = new RGB(243, 129, 37);
    private static final RGB DEFAULT_EQUATION_COLOR = new RGB(190, 100, 100);
    private static final RGB DEFAULT_COMMENT_COLOR = new RGB(190, 190, 190);
    private static final RGB DEFAULT_VERBATIM_COLOR = new RGB(80, 80, 80);
    private static final RGB DEFAULT_TEX_NUMBER_COLOR = new RGB(255, 100, 0);
    private static final RGB DEFAULT_TEX_SPECIAL_COLOR = new RGB(255, 0, 0);
    private static final int DEFAULT_DEFAULT_STYLE = 0;
    private static final int DEFAULT_STRING_STYLE = 0;
    private static final int DEFAULT_COMMAND_STYLE = 1;
    private static final int DEFAULT_CURLY_BRACKETS_STYLE = 0;
    private static final int DEFAULT_SQUARE_BRACKETS_STYLE = 0;
    private static final int DEFAULT_EQUATION_STYLE = 0;
    private static final int DEFAULT_COMMENT_STYLE = 0;
    private static final int DEFAULT_VERBATIM_STYLE = 2;
    private static final int DEFAULT_TEX_NUMBER_STYLE = 0;
    private static final int DEFAULT_TEX_SPECIAL_STYLE = 0;
    protected Map fColorTable = new HashMap(10);
    protected Map fStyleTable = new HashMap(10);
    protected Color bgColor;

    public static void initializeDefaults(IPreferenceStore preferences) {
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)DEFAULT, (RGB)DEFAULT_DEFAULT_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)STRING, (RGB)DEFAULT_STRING_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)COMMAND, (RGB)DEFAULT_COMMAND_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)CURLY_BRACKETS, (RGB)DEFAULT_CURLY_BRACKETS_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)SQUARE_BRACKETS, (RGB)DEFAULT_SQUARE_BRACKETS_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)EQUATION, (RGB)DEFAULT_EQUATION_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)COMMENT, (RGB)DEFAULT_COMMENT_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)VERBATIM, (RGB)DEFAULT_VERBATIM_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)TEX_NUMBER, (RGB)DEFAULT_TEX_NUMBER_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)TEX_SPECIAL, (RGB)DEFAULT_TEX_SPECIAL_COLOR);
        preferences.setDefault(DEFAULT_STYLE, 0);
        preferences.setDefault(STRING_STYLE, 0);
        preferences.setDefault(COMMAND_STYLE, 1);
        preferences.setDefault(CURLY_BRACKETS_STYLE, 0);
        preferences.setDefault(SQUARE_BRACKETS_STYLE, 0);
        preferences.setDefault(EQUATION_STYLE, 0);
        preferences.setDefault(COMMENT_STYLE, 0);
        preferences.setDefault(VERBATIM_STYLE, 2);
        preferences.setDefault(TEX_NUMBER_STYLE, 0);
        preferences.setDefault(TEX_SPECIAL_STYLE, 0);
    }

    public Color getColor(String rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)TexlipsePlugin.getDefault().getPreferenceStore(), (String)rgb));
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public int getStyle(String styleC) {
        Integer style = (Integer)this.fStyleTable.get(styleC);
        if (style == null) {
            style = new Integer(TexlipsePlugin.getDefault().getPreferenceStore().getInt(styleC));
            this.fColorTable.put(styleC, style);
        }
        return style;
    }

    public void dispose() {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }
}

