type picture = Picture of float * float * float * float * pic_object list
               (* xsize, ysize, xorigin, yorigin, picture objects *)

and point = float * float
             (* x, y *)

and pic_object = Line of point * int * int * float * option list 
                 (* xpos, ypos, xslope, yslope, length, option list *)

               | Circle of point * float * option list
                 (* xpos, ypos, diameter, option list *)

               | Oval of point * float * float * option list
                 (* xpos, ypos, length, height, option list *)

               | Text of point * string * option list
                 (* xpos, ypos, text, option list *)

               | Curve of point * point * point * option list
                 (* first point, control point, last point, option list *)

               | SubPicture of point * picture * option list
                 (* xpos, ypos, subpicture, option list *)

               | Framebox of point * float * float * option list
                 (* xpos, ypos, length, height, option list *)

and option = Arrowhead                  (* line *)
           | Anchor of anchor * anchor  (* oval, text, framebox *)
           | Filled                     (* circle *)
           | Dashed of float            (* framebox *)
           | Framed                     (* circle, oval, text, subpicture *)
           | Points of int              (* curve *)

and anchor =  N | L | R | T | B


val output : out_channel -> picture -> unit
