#ifndef RUNTEX_STRSTUFF_H
#define RUNTEX_STRSTUFF_H

/* get a char* pointing to filename+extension inside
	a char* of the full path */
char* get_file_name_pointer(char* src);
/* get a char* pointing to the (last) extension inside
	a char* of the full path */
char* get_file_suffix_pointer(char* src);
/* get a char* containing the file's name without the suffix inside
	a char* of the full path */
char* get_file_name(char* src);
/* get a char* containing the dir's name inside
	a char* of the full path */
char* get_dir_name(char* src);
/* create full name of file
	dir_name and suffix may be NULLs
	are both NULLs the file_name will be returned without copying */
char* create_full_file_name(char* dir_name, char* file_name, char* suffix);
/* create array containing the space delimited options
	inside xxx_cmd+file_name for tex variant/util.
	On error file_name will *not* be free'd */
char** create_spawn_options(char* exe_name, char* options, char* file_name);
#endif
