#!/bin/awk -f 

#
#   REFERENCES -- bibliographic software
#   Copyright (C) 1995-2006  Volker Kiefel
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#
#
#
# tocite.awk is a filter to convert a line like
# 
#   This is described in refscite(Mueller98), refscite(Hauff02) and has been used by ...
# 
# to
# 
#   This is described in \cite{Mueller98}, \cite{Hauff02} and has been used ...
#
# It can be used:
# 
#   awk -f tocite.awk < input.tex > output.tex
#
#


BEGIN {
   while((getline inp < "/dev/stdin") > 0)
   {
     match(inp,/refscite\([a-zA-Z0-9\.\_]*\)/)
     if (RSTART > 0)
     {
        inp = zeile_bearbeiten(inp)
        print inp
     }
     else 
     {
       print inp
     }
  }
}

function zeile_bearbeiten(ein,  citestr,refnr,neurefnr)
{
   while (match(ein,/refscite\([a-zA-Z0-9\.\_]*\)/))
   {
       citestr = substr(ein,RSTART,RLENGTH)
       refnr = substr(citestr,length("refscite(")+1,length(citestr)-length("refscite(")-1)
       neurefnr = "\\cite{" refnr "}"
       altstr = "refscite\\(" refnr "\\)"
       gsub(altstr,neurefnr,ein)
   }
   return ein
}


END {
   close("/dev/stdin")
}

# vim:tw=2048 hls
