/* listsetc.h    include file for lists, etc */

#ifndef LISTSETC_H
#define LISTSETC_H

typedef char *genptr;           /* a generic pointer */

typedef struct lbs_node_struct {    /* a listset node */
  genptr dataptr;
  struct lbs_node_struct *next;
} LBS_NODE, *LBS_NODE_PTR;

typedef struct dynagg {             /* a listset header */
  LBS_NODE_PTR front;               /* first element */
  LBS_NODE_PTR back;                /* last element */
  int numel;                        /* number of elements */
} LBS, *LBS_PTR;

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* MACROS */

#define DATA(e)   ((e)->dataptr)
#define NEXTEL(e) ((e)->next)
#define FRONT(d)  ((d)->front)
#define BACK(d)   ((d)->back)
#define NELS(d)   ((d)->numel)


/* Supplied functions */

extern LBS_PTR lbs_init();             /* create an empty list/bag/set */
extern int lbs_empty();                /* TRUE iff arg is empty */
extern LBS_NODE_PTR lbs_prepend();     /* add element at front */
extern LBS_NODE_PTR lbs_append();      /* add element at back */
extern LBS_NODE_PTR lbs_insert();      /* add element after */
extern LBS_NODE_PTR lbs_remove();      /* remove el at pos */
extern LBS_NODE_PTR lbs_get_first();   /* the first el */
extern LBS_NODE_PTR lbs_get_last();    /* the last el */
extern LBS_NODE_PTR lbs_get_nth();     /* the n'th el */
extern LBS_NODE_PTR lbs_get_next_el(); /* the next el */
extern void free_lbsnode();            /* free an el */

#endif
