package ch.bfh.lpdg;

import ch.bfh.lpdg.datastructure.DependencyType;
import org.apache.commons.cli.ParseException;

import static java.util.Collections.emptyList;

public class Application {
    public static void main(String[] args) {

        var interactionHandler = InteractionHandler.getInstance();
        var graphHelper = GraphHelper.getInstance();

        try {
            interactionHandler.handleOptions(args);
        } catch (ParseException pE) {
            System.err.println("Handling parameters went wrong: " + pE.getMessage());
        }

        var files = interactionHandler.getFiles();
        for (var file:files) {
            try {
                var res = DependencyScanner.getInstance().findDependencies(file.getAbsolutePath(), DependencyType.FILE, "", emptyList(), interactionHandler.getDepth());
                interactionHandler.printDebugMessage("Dependencies for file: "+file.getName());
                interactionHandler.printDebugMessage(res.toString());
                var latexHelper = new LatexHelper(file, res);
                latexHelper.findUnnecessaryDependencies(interactionHandler.hasOverwriteFlag(), interactionHandler.hasMinimizeFlag());
                graphHelper.createFileForDependency(res, "./");
            }
            catch (Exception e)
            {
                System.out.println("Error on scanning the file: "+file.getAbsolutePath()+"\n"+e);
            }
        }
    }
}
