program nic2nic;
{$m 65520,0,600000}
uses
  crt,dos, ch_files, ch_chess, ch_parse;

var
  not_printed_games, temp : longint;
  i : integer;
  numb_of_games, game_numb : longint;
  kk : byte;
  source, target, target2 : sourcetype;
  game : gametype;
  target_idx, t_game_numb : longint;
  omit_f : text;


{mainprogram}
begin
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln;
  writeln('SYNTAX: NIC2NIC source-file target-file');
  writeln;
  writeln('The following games will be omitted: ');
  writeln;
  writeln('- deleted, and overwritten games');
  writeln('- game fragments (games starting with a position)');
  writeln;
  writeln;
  source.name:='';
  target.name:='';
  not_printed_games:=0;
  if paramcount<2 then
  begin
    write('The name of old NicBase file:    ');
    readln(source.name);
    target.name:=source.name;
    write('The name of new NicBase file:    ');
    readln(target.name);
  end
  else
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
  end;
  remove_ext(source.name);
  remove_ext(target.name);
  find_path(source.name,source.path);
  find_path(target.name,target.path);
  if source.name+source.path=target.name+target.path then
  begin
    writeln('Source and target file have the same name');
    halt;
  end;

  if file_exist(source.path+source.name+'.I30') and
     file_exist(source.path+source.name+'.G30') then
  begin
    open_file_for_write(target.index,target.path+target.name+'.I30');
    open_file_for_write(target.game,target.path+target.name+'.G30');
    io_test;
    open_file_for_read(source.index  ,source.path+source.name+'.I30');
    open_file_for_read(source.game   ,source.path+source.name+'.G30');
    if not io_error then
    begin
      target_idx:=0;
      t_game_numb:=0;
      game.game_format:='NIC';
      game.beg:=get_index_val(source.index);
      numb_of_games:=(filesize(source.index.f)-4) div 4;
      writeln(numb_of_games:6,' Games to examine');
      put_index_val(target.index,target_idx);
      game_numb:=1;
      assign(omit_f,'nic2nic.log');
      if file_exist('nic2nic.log') then
        erase(omit_f);
      io_test;
      rewrite(omit_f);
      io_test;
      while (game_numb<=numb_of_games) and (not io_error) and
            (not keypressed) do
      begin
        game.beg_next:=get_index_val(source.index);
        game.len:=game.beg_next-game.beg;
        if game.len<0 then
        begin
          write('game.len<0');
          halt;
        end;
        i:=0;
        while (i<game.len) and (not io_error) do
        begin
          game.bytes[i]:=get_next_byte(source.game);
          inc(i);
        end;
        game.bytes[game.len]:=-1;
        parse_nic_gamehead(game);
        if not (game.deleted or game.overwritten or
                game.position or game.quiz)
        then
        begin
          parse_nic_moves(game);
          write_nic_gamehead(game);
          if not game.illegal_move then
          begin
            inc(t_game_numb);
            target_idx:=target_idx+game.len;
            put_index_val(target.index,target_idx);
            for i:=0 to game.len-1 do
            begin
              put_next_byte(target.game,game.bytes[i]);
            end;
          end
          else
          begin
            inc(not_printed_games);
            writeln(omit_f,game_numb:5,'  ILLEGAL MOVE  ',game.cb_players);
            print_pgn(omit_f,game);
          end;
        end
        else
          inc(not_printed_games);
        game.beg:=game.beg_next;
        gotoxy(1,wherey);
        write(game_numb:6,' Games Examined ',not_printed_games:6,
              ' Games omitted');
        inc(game_numb);
      end;
    end;
    close_read_file(source.index);
    close_read_file(source.game);
    close_write_file(target.index);
    close_write_file(target.game);
    close(omit_f);
  end
  else
  begin
    writeln(source.path+source.name,'Does not exist');
  end;
  writeln;
end.
