/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.parallel;

import de.nm.ant.parallel.AbstractParallelTask;
import de.nm.file.XFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.FileSet;

public class IfNewerTask
extends AbstractParallelTask
implements TaskContainer {
    protected File destdir;
    protected String destextname;
    protected final List<FileSet> fileset = new ArrayList<FileSet>();
    protected final Vector<Task> nestedTasks = new Vector();
    protected File srcdir;
    protected String srcextname;

    public void addFileset(FileSet set) {
        this.fileset.add(set);
    }

    public void addTask(Task task) {
        this.nestedTasks.add(task);
    }

    private void checkNewer(LinkedList<File> todofiles) {
        long lastModified = this.getLastModified();
        int n = todofiles.size();
        for (int i = 0; i < n; ++i) {
            File sf = todofiles.removeFirst();
            if (!sf.exists()) {
                this.log("File " + sf.getAbsoluteFile() + " not exists!", 0);
            }
            File df = new File(this.destdir + File.separator + XFile.getBasename((File)sf) + "." + this.destextname);
            try {
                if (!XFile.isnewerDate((File)sf, (File)df) && df.lastModified() >= lastModified) continue;
                if (this.verboseheader) {
                    this.log(sf.getName(), 2);
                }
                if (this.verbose) {
                    this.log(sf.getAbsolutePath() + " -> " + df.getAbsolutePath());
                }
                this.runTasks(sf, df);
                continue;
            }
            catch (IOException e) {
                this.log(((Object)((Object)this)).getClass().getName() + " " + e.getMessage(), 0);
            }
        }
    }

    protected void checkThread() {
        if (!this.parallelQueue && this.isThread()) {
            this.waitForFinish();
        }
    }

    public void execute() {
        this.checkNewer(this.tofofiles());
        this.checkThread();
    }

    protected void runTasks(File sf, File df) {
        if (!this.isThread()) {
            List<Task> copytask = this.copyTask(this.nestedTasks);
            for (Task task : copytask) {
                task = this.checkTask(task);
                this.checkMethod(task, "setWorkdir", this.destdir);
                this.checkMethod(task, "setSrcfile", sf);
                this.checkMethod(task, "setDestfile", df);
                this.checkMethod(task, "setBasename", XFile.getBasename((File)sf));
                task.perform();
            }
        } else {
            List<Task> copytask = this.copyTask(this.nestedTasks);
            for (Task task : copytask) {
                task = this.checkTask(task);
                this.checkMethod(task, "setWorkdir", this.destdir);
                this.checkMethod(task, "setSrcfile", sf);
                this.checkMethod(task, "setDestfile", df);
                this.checkMethod(task, "setBasename", XFile.getBasename((File)sf));
            }
            this.addRunnerTasks(copytask);
        }
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setDestextname(String destextname) {
        this.destextname = destextname;
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void setSrcextname(String srcextname) {
        this.srcextname = srcextname;
    }

    protected LinkedList<File> tofofiles() {
        File[] files;
        if (this.srcdir == null) {
            throw new BuildException("No srcdir set.");
        }
        if (this.destdir == null) {
            throw new BuildException("No destdir set.");
        }
        if (this.destextname == null) {
            throw new BuildException("No destextname set.");
        }
        this.checkInit();
        this.logStatus();
        LinkedList<File> todofiles = new LinkedList<File>();
        for (FileSet fs : this.fileset) {
            String[] files2;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String f : files2 = ds.getIncludedFiles()) {
                todofiles.add(new File(this.srcdir + File.separator + f));
            }
        }
        if (this.srcextname != null && (files = this.srcdir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches(IfNewerTask.this.srcextname);
            }
        })) != null) {
            for (File f : files) {
                todofiles.add(f);
            }
        }
        return todofiles;
    }
}

