unit data;


interface

uses pathunit;

(* options: *)

var corelfix, generate, split, ttfix, verbose, stdenc, 
    noOtherSubrs, afmcheck: Boolean;

(* flags: *)

var afmopen, ccopen: Boolean;

(* CharStrings storage *)

const	maxCharStrings = 300;

var	CharStrings: array [1..maxCharStrings] of CharStrpointer;
	CharStringscount: integer;

(* Encoding vectors *)

const	(* Windows encoding vector used for ttfix option *)
	WinANSI: array [0..255] of string [30] = (
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/space', '/exclam', '/quotedbl', '/numbersign', '/dollar', '/percent', '/ampersand', '/quotesingle',
	'/parenleft', '/parenright', '/asterisk', '/plus', '/comma', '/hyphen', '/period', '/slash',
	'/zero', '/one', '/two', '/three', '/four', '/five', '/six', '/seven',
	'/eight', '/nine', '/colon', '/semicolon', '/less', '/equal', '/greater', '/question',
	'/at', '/A', '/B', '/C', '/D', '/E', '/F', '/G', '/H', '/I', '/J', '/K', '/L', '/M', '/N', '/O',
	'/P', '/Q', '/R', '/S', '/T', '/U', '/V', '/W',
	'/X', '/Y', '/Z', '/bracketleft', '/backslash', '/bracketright', '/asciicircum', '/underscore',
	'/grave', '/a', '/b', '/c', '/d', '/e', '/f', '/g', '/h', '/i', '/j', '/k', '/l', '/m', '/n', '/o',
	'/p', '/q', '/r', '/s', '/t', '/u', '/v', '/w',
	'/x', '/y', '/z', '/braceleft', '/bar', '/braceright', '/asciitilde', '/.notdef',
	'/.notdef', '/.notdef', '/quotesinglbase', '/florin',
	'/quotedblbase', '/ellipsis', '/dagger', '/daggerdbl',
	'/circumflex', '/perthousand', '/Scaron', '/guilsinglleft', '/OE', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/quoteleft', '/quoteright', '/quotedblleft',
	'/quotedblright', '/bullet', '/endash', '/emdash',
	'/tilde', '/trademark', '/scaron', '/guilsinglright', '/oe', '/.notdef', '/.notdef', '/Ydieresis',
	'/space', '/exclamdown', '/cent', '/sterling', '/currency', '/yen', '/brokenbar', '/section',
	'/dieresis', '/copyright', '/ordfeminine', '/guillemotleft',
	'/logicalnot', '/minus', '/registered', '/macron',
	'/degree', '/plusminus', '/twosuperior', '/threesuperior',
	'/acute', '/mu', '/paragraph', '/periodcentered',
	'/cedilla', '/onesuperior', '/ordmasculine', '/guillemotright',
	'/onequarter', '/onehalf', '/threequarters', '/questiondown',
	'/Agrave', '/Aacute', '/Acircumflex', '/Atilde', '/Adieresis', '/Aring', '/AE', '/Ccedilla',
	'/Egrave', '/Eacute', '/Ecircumflex', '/Edieresis', '/Igrave', '/Iacute', '/Icircumflex', '/Idieresis',
	'/Eth', '/Ntilde', '/Ograve', '/Oacute', '/Ocircumflex', '/Otilde', '/Odieresis', '/multiply',
	'/Oslash', '/Ugrave', '/Uacute', '/Ucircumflex', '/Udieresis', '/Yacute', '/Thorn', '/germandbls',
	'/agrave', '/aacute', '/acircumflex', '/atilde', '/adieresis', '/aring', '/ae', '/ccedilla',
	'/egrave', '/eacute', '/ecircumflex', '/edieresis', '/igrave', '/iacute', '/icircumflex', '/idieresis',
	'/eth', '/ntilde', '/ograve', '/oacute', '/ocircumflex', '/otilde', '/odieresis', '/divide',
	'/oslash', '/ugrave', '/uacute', '/ucircumflex', '/udieresis', '/yacute', '/thorn', '/ydieresis'
	);

	(* StandardEncoding vector used for generate option *)
	StandardEncoding: array [0..255] of string [30] = (
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/space', '/exclam', '/quotedbl', '/numbersign', '/dollar', '/percent', '/ampersand', '/quoteright',
	'/parenleft', '/parenright', '/asterisk', '/plus', '/comma', '/hyphen', '/period', '/slash',
	'/zero', '/one', '/two', '/three', '/four', '/five', '/six', '/seven',
	'/eight', '/nine', '/colon', '/semicolon', '/less', '/equal', '/greater', '/question',
	'/at', '/A', '/B', '/C', '/D', '/E', '/F', '/G', '/H', '/I', '/J', '/K', '/L', '/M', '/N', '/O',
	'/P', '/Q', '/R', '/S', '/T', '/U', '/V', '/W',
	'/X', '/Y', '/Z', '/bracketleft', '/backslash', '/bracketright', '/asciicircum', '/underscore',
	'/quoteleft', '/a', '/b', '/c', '/d', '/e', '/f', '/g', '/h', '/i', '/j', '/k', '/l', '/m', '/n', '/o',
	'/p', '/q', '/r', '/s', '/t', '/u', '/v', '/w',
	'/x', '/y', '/z', '/braceleft', '/bar', '/braceright', '/asciitilde', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/exclamdown', '/cent', '/sterling', '/fraction', '/yen', '/florin', '/section',
	'/currency', '/quotesingle', '/quotedblleft', '/guillemotleft',
	'/guilsinglleft', '/guilsinglright', '/fi', '/fl',
	'/.notdef', '/endash', '/dagger', '/daggerdbl',
	'/periodcentered', '/.notdef', '/paragraph', '/bullet',
	'/quotesinglbase', '/quotedblbase', '/quotedblright', '/guillemotright',
	'/ellipsis', '/perthousand', '/.notdef', '/questiondown',
	'/.notdef', '/grave', '/acute', '/circumflex', '/tilde', '/macron', '/breve', '/dotaccent',
	'/dieresis', '/.notdef', '/ring', '/cedilla', '/.notdef', '/hungarumlaut', '/ogonek', '/caron',
	'/emdash', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/AE', '/.notdef', '/ordfeminine', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/Lslash', '/Oslash', '/OE', '/ordmasculine', '/.notdef', '/.notdef', '/.notdef', '/.notdef',
	'/.notdef', '/ae', '/.notdef', '/.notdef', '/.notdef', '/dotlessi', '/.notdef', '/.notdef',
	'/lslash', '/oslash', '/oe', '/germandbls', '/.notdef', '/.notdef', '/.notdef', '/.notdef'
	);

function getCharString (n: string): CharStrpointer;
function getSEcode (n: string): integer;
procedure makefilebuffer (var buf: text; name: string);
procedure getfilebuffer (var buf, out: text);


implementation

uses Dos;

function getCharString (n: string): CharStrpointer;
var i: integer;
begin
	i := 1;
	getCharString := nil;
	while i <= CharStringscount do
		if CharStrings [i] ^.name = n then begin
			getCharString := CharStrings [i];
			i := CharStringscount + 1
		end
		else	i := i + 1
end;

function getSEcode (n: string): integer;
var i: integer;
    weiter: Boolean;
begin
	i := 255;
	weiter := true;
	while weiter and (i >= 0) do
		if StandardEncoding [i] = n
		then	weiter := false
		else	i := i - 1;
	getSEcode := i
end;

procedure makefilebuffer (var buf: text; name: string);
begin
	if getenv ('TEMP') <> ''
	then	assign (buf, getenv ('TEMP') + '\' + name)
	else	assign (buf, name);
	rewrite (buf);
end;

procedure getfilebuffer (var buf, out: text);
var s: string;
begin
	reset (buf);
	while not eof (buf) do begin
		readln (buf, s);
		writeln (out, s)
	end;
	close (buf);
	erase (buf);
end;

end.
