/* assoc.h 2.9.0 92/07/06 - simple association list
 *  Created - Damian Cugley <pdc@oxford.prg> Fri 12 Jan 1990
 */

#include "stdc.h"

typedef struct assoc_node 
{
  struct assoc_node *next;
  char *s;
} *Assoclist;

const char *assoc ARGS((Assoclist al, const char *s));
 /* return the value associated with s, or (char*)0 if there is none. */

Assoclist assoc_destroylist ARGS((Assoclist));

Assoclist assoc_add ARGS((Assoclist al, char *s));
   /*  
    *  s is a malloc'd string of the form "KEY=VAL"
    */

const char *assoc_match_backwards ARGS((Assoclist al, const char *s,
					const char **pe));
/*
 *  Try to find a KEY=VAL in al such that KEY is a suffix
 *  of  the string from s to just before *pe.
 *
 *  Returns VAL, if found,  otherwise (char *)0.
 *
 *  If ne is non-NULL, then *pe is set to (*pe - length(KEY)),
 *  i.e., the start of the matching suffix ( s <= *pe < *pe0 ).
 *
 *  If no match is found, then returns (char *)0, and *pe is unchanged.
 */


void	assoc_print ARGS((Assoclist));
				/* Print a list (for debugging purposes) */
